/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.refrig;

import org.lsst.ccs.subsystems.refrig.RefrigTest;

public class RefrigTestSim
extends RefrigTest {
    private static final float CDT_OVALUE = 110.0f;
    private static final float CDT_OTIME = 120.0f;
    private static final float CDT_RTIME = 1200.0f;
    private static final float CDP_OVALUE = 300.0f;
    private static final float CDP_OTIME = 30.0f;
    private static final float CDP_RTIME = 30.0f;
    private static final float C3T_OVALUE = -120.0f;
    private static final float C3T_OTIME = 3600.0f;
    private static final float C3T_RTIME = 7200.0f;
    private static final float C4T_OVALUE = -120.0f;
    private static final float C4T_OTIME = 3600.0f;
    private static final float C4T_RTIME = 7200.0f;
    private static final float CSP_OVALUE = 10.0f;
    private static final float CSP_OTIME = 30.0f;
    private static final float CSP_RTIME = 30.0f;
    private static final float HLT_OVALUE = -100.0f;
    private static final float HLT_OTIME = 3600.0f;
    private static final float HLT_RTIME = 7200.0f;
    private static final float AMBIENT_TEMP = 20.0f;
    private static final float AMBIENT_PRESS = 30.0f;
    private static final float LOAD_POWER = 90.0f;
    private int state = 0;
    private ChanSim[] simData = new ChanSim[7];
    private long baseTime = System.currentTimeMillis();

    public RefrigTestSim() {
        this.simData[0] = new ChanSim(110.0f, 120.0f, 1200.0f);
        this.simData[1] = new ChanSim(300.0f, 30.0f, 30.0f);
        this.simData[2] = new ChanSim(-120.0f, 3600.0f, 7200.0f);
        this.simData[3] = new ChanSim(-120.0f, 3600.0f, 7200.0f);
        this.simData[5] = new ChanSim(10.0f, 30.0f, 30.0f);
        this.simData[4] = new ChanSim(-100.0f, 3600.0f, 7200.0f);
    }

    @Override
    void initSensors() {
        this.simData[0].startVal = 20.0f;
        this.simData[0].endVal = 20.0f;
        this.chanData[0].value = 20.0f;
        this.simData[2].startVal = 20.0f;
        this.simData[2].endVal = 20.0f;
        this.chanData[2].value = 20.0f;
        this.simData[3].startVal = 20.0f;
        this.simData[3].endVal = 20.0f;
        this.chanData[3].value = 20.0f;
        this.simData[4].startVal = 20.0f;
        this.simData[4].endVal = 20.0f;
        this.chanData[4].value = 20.0f;
        this.simData[1].startVal = 30.0f;
        this.simData[1].endVal = 30.0f;
        this.chanData[1].value = 30.0f;
        this.simData[5].startVal = 30.0f;
        this.simData[5].endVal = 30.0f;
        this.chanData[5].value = 30.0f;
    }

    @Override
    void readSensors() {
        this.mccTS = this.powerTS = System.currentTimeMillis();
        int j = 0;
        while (j < 7) {
            float value;
            RefrigTest.Channel chan = this.chanData[j];
            if (chan.type == 0) {
                float intvl = (float)((double)(System.currentTimeMillis() - this.baseTime) / 1000.0);
                ChanSim sim = this.simData[j];
                value = sim.startVal + sim.rate * intvl;
                if (sim.rate < 0.0f) {
                    if (value < sim.endVal) {
                        value = sim.endVal;
                    }
                } else if (value > sim.endVal) {
                    value = sim.endVal;
                }
            } else {
                value = (this.state >> 6 & this.state >> 7 & 1) != 0 ? 90.0f : 0.0f;
            }
            chan.value = Math.signum(value) * (float)(Math.floor(100.0 * (double)Math.abs(value) + 0.5) / 100.0);
            this.configAlarm(j);
            ++j;
        }
    }

    @Override
    void configAlarm(int id) {
        RefrigTest.Channel chan = this.chanData[id];
        if (chan.type != 0) {
            return;
        }
        int value = 1;
        if (chan.checkLo && chan.value < chan.limitLo) {
            value = 0;
        }
        if (chan.checkHi && chan.value > chan.limitHi) {
            value = 0;
        }
        this.setStateBit(chan.stateBitNum, value);
    }

    @Override
    void setStateBit(int bit, int value) {
        this.state = value != 0 ? (this.state |= 1 << bit) : (this.state &= ~(1 << bit));
        if (bit == 7) {
            this.baseTime = System.currentTimeMillis();
            int j = 0;
            while (j < 7) {
                RefrigTest.Channel chan = this.chanData[j];
                if (chan.type == 0) {
                    ChanSim sim = this.simData[j];
                    float relaxVal = chan.isTemp ? 20.0f : 30.0f;
                    sim.startVal = chan.value;
                    if (value != 0) {
                        sim.endVal = sim.operVal;
                        sim.rate = (sim.endVal - relaxVal) / sim.operTime;
                    } else {
                        sim.endVal = relaxVal;
                        sim.rate = (sim.endVal - sim.operVal) / sim.relaxTime;
                    }
                }
                ++j;
            }
        }
    }

    @Override
    int getStateBit(int bit) {
        return this.state >> bit & 1;
    }

    @Override
    int getStateWord() {
        return this.state;
    }

    private static class ChanSim {
        float operVal;
        float operTime;
        float relaxTime;
        float startVal;
        float endVal;
        float rate;

        public ChanSim(float operVal, float operTime, float relaxTime) {
            this.operVal = operVal;
            this.operTime = operTime;
            this.relaxTime = relaxTime;
            this.startVal = 0.0f;
            this.endVal = 0.0f;
            this.rate = 0.0f;
        }
    }
}

