/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.refrig;

import javax.usb.UsbException;
import org.lsst.ccs.drivers.mcc.MccTc;
import org.lsst.ccs.drivers.mcc.MccTcAi;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.refrig.RefrigTest;

public class RefrigTestHdw
extends RefrigTest
implements WattsUp.DataListener {
    private static final int STATE_FLIP_MASK = 127;
    private static final int STATE_LEDS_MASK = 127;
    private static final int LED_UPDATE_PERIOD = 1000;
    private static final float PRESSURE_SCALE = 10000.0f;
    private MccTcAi tcai;
    private MccTc tc;
    private WattsUp wtu;
    private float power;
    private Thread updateLEDs = new Thread(new UpdateLEDs());

    @Override
    void initSensors() {
        try {
            this.tcai = new MccTcAi();
            this.tcai.open(null, true);
            this.tcai.blink();
            int j = 0;
            while (j < 8) {
                this.tcai.configAlarm(j, 0, 0, 0.0f, 0.0f);
                ++j;
            }
            this.tcai.dioConfig(0);
            this.tcai.dioOut(0);
            this.tcai.setTCType(0, 2);
            this.tcai.setTCType(1, 2);
            this.tcai.setTCType(2, 2);
            this.tcai.setTCType(3, 2);
            this.tcai.setGain(6, 5);
            this.tcai.setVoltageConnType(6, 0);
            this.tcai.setGain(7, 5);
            this.tcai.setVoltageConnType(7, 0);
        }
        catch (UsbException e) {
            throw new RefrigTest.RefrigException("Error initializing USB-TC-AI module", e);
        }
        try {
            this.tc = new MccTc();
            this.tc.open(null, true);
            this.tc.blink();
            this.tc.dioOut(0);
        }
        catch (UsbException e) {
            throw new RefrigTest.RefrigException("Error initializing USB_TC module", e);
        }
        try {
            this.wtu = new WattsUp();
            this.wtu.open();
            this.wtu.setLoggedFields(1);
            this.wtu.setExternalLogging(1);
            this.wtu.addDataListener((WattsUp.DataListener)this);
        }
        catch (Exception e) {
            Module.log.error((Object)("Cannot access WattsUp meter: " + e));
        }
        this.updateLEDs.start();
    }

    @Override
    void readSensors() {
        this.mccTS = System.currentTimeMillis();
        int j = 0;
        while (j < 7) {
            RefrigTest.Channel chan = this.chanData[j];
            if (chan.type == 0) {
                try {
                    chan.value = this.tcai.adcIn(chan.hwChan, 0);
                    if (!chan.isTemp) {
                        chan.value *= 10000.0f;
                    }
                }
                catch (UsbException e) {
                    Module.log.info((Object)e);
                }
            } else {
                chan.value = this.power;
            }
            chan.value = Math.signum(chan.value) * (float)(Math.floor(100.0 * (double)Math.abs(chan.value) + 0.5) / 100.0);
            ++j;
        }
    }

    public void process(float[] data) {
        this.power = data[0];
        this.powerTS = System.currentTimeMillis();
    }

    @Override
    void configAlarm(int id) {
        RefrigTest.Channel chan = this.chanData[id];
        if (chan.type != 0) {
            return;
        }
        int inOptn = chan.hwChan;
        int outOptn = 0;
        float value1 = 0.0f;
        float value2 = 0.0f;
        if (chan.checkLo) {
            outOptn = 3;
            value1 = chan.limitLo;
            if (chan.checkHi) {
                inOptn |= 0x40;
                value2 = chan.limitHi;
            } else {
                inOptn |= 0x20;
            }
        } else if (chan.checkHi) {
            outOptn = 3;
            value1 = chan.limitHi;
        }
        if (!chan.isTemp) {
            value1 /= 10000.0f;
            value2 /= 10000.0f;
        }
        try {
            this.tcai.configAlarm(chan.stateBitNum, inOptn, outOptn, value1, value2);
            if (outOptn == 0) {
                this.tcai.dioOutBit(chan.stateBitNum, 0);
            }
        }
        catch (UsbException e) {
            throw new RefrigTest.RefrigException("Error configuring alarms", e);
        }
    }

    @Override
    void setStateBit(int bit, int value) {
        try {
            this.tcai.dioOutBit(bit, (127 >> bit ^ value) & 1);
        }
        catch (UsbException e) {
            throw new RefrigTest.RefrigException("Error setting DIO line", e);
        }
    }

    @Override
    int getStateBit(int bit) {
        try {
            return this.tcai.dioInBit(bit) ^ 127 >> bit & 1;
        }
        catch (UsbException e) {
            throw new RefrigTest.RefrigException("Error setting DIO line", e);
        }
    }

    @Override
    int getStateWord() {
        int value = 0;
        try {
            value = this.tcai.dioIn() ^ 0x7F;
        }
        catch (UsbException e) {
            throw new RefrigTest.RefrigException("Error reading DIO lines", e);
        }
        return value;
    }

    private class UpdateLEDs
    implements Runnable {
        private UpdateLEDs() {
        }

        @Override
        public void run() {
            while (true) {
                int value;
                try {
                    value = (RefrigTestHdw.this.tcai.dioIn() ^ 0x7F) & 0x7F;
                }
                catch (UsbException e) {
                    throw new RefrigTest.RefrigException("Error reading DIO lines", e);
                }
                try {
                    RefrigTestHdw.this.tc.dioOut(value);
                }
                catch (UsbException e) {
                    throw new RefrigTest.RefrigException("Error writing DIO lines", e);
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

