/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * RefrigTrendingTable.java
 *
 * Created on Jan 25, 2012, 8:58:09 AM
 */
package org.lsst.ccs.subsystems.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.subsystems.refrig.data.RefrigChannel;
import org.lsst.ccs.subsystems.refrig.status.RefrigChannelLimitStatus;
import org.lsst.ccs.subsystems.refrig.status.RefrigTrendingStatus;
import org.lsst.ccs.subsystems.refrig.status.RefrigTrendingSummaryStatus;
import org.lsst.ccs.subsystems.refrig.utils.RefrigUtils;

/**
 *
 * @author turri
 */
public class RefrigTrendingTable extends javax.swing.JPanel implements TableModelListener {

    final static String[] columnNames = new String[]{"Description", "Value", "Units", "Low Limit", "High Limit", "Name"};
    final static int DESCRIPTION_IND = 0;
    final static int VALUE_IND = 1;
    final static int UNITS_IND = 2;
    final static int LOW_LIMIT_IND = 3;
    final static int HIGH_LIMIT_IND = 4;
    final static int NAME_IND = 5;
    RefrigGUISubsystem refrigGui;

    /** Creates new form RefrigTrendingTable */
    public RefrigTrendingTable(RefrigGUISubsystem refrigGui) {
        initComponents();

        jTable1.getTableHeader().setReorderingAllowed(false);
        jTable1.getModel().addTableModelListener(this);

        this.refrigGui = refrigGui;

    }

    RefrigGUISubsystem getRefrigGui() {
        return refrigGui;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.LINE_AXIS));

        jTable1.setModel(new TrendingTableModel());
        jScrollPane1.setViewportView(jTable1);

        add(jScrollPane1);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    // End of variables declaration//GEN-END:variables

    public void updateTableModel(RefrigTrendingSummaryStatus status) {
        SwingUtilities.invokeLater(new UpdateTrendingTableModel(status));
    }

    public void updateTableValue(RefrigTrendingStatus status) {
        SwingUtilities.invokeLater(new UpdateTrendingTable(status));
    }

    public void updateTableValue(RefrigChannelLimitStatus status) {
        SwingUtilities.invokeLater(new UpdateTrendingTableLimits(status));
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int column = e.getColumn();
        if (column == LOW_LIMIT_IND || column == HIGH_LIMIT_IND) {
            int row = e.getFirstRow();
            TrendingTableModel model = (TrendingTableModel) e.getSource();

            double insertedValue = ((Double) model.getValueAt(row, column)).doubleValue();
            double actualValue = column == LOW_LIMIT_IND ? model.getLowLimit(row) : model.getHighLimit(row);

            if (insertedValue != actualValue) {
                refrigGui.submitLimit(row, insertedValue, column == LOW_LIMIT_IND);
                SwingUtilities.invokeLater(new UpdateLimitsButton(true));
            }
        }

    }

    public void resetTrendingTableModel() {
        SwingUtilities.invokeLater(new ResetTrendingTableModel() );
    }    
    
    class ResetTrendingTableModel implements Runnable {

        @Override
        public void run() {            
            jTable1.setModel(new TrendingTableModel());
        }
        
    }
    
    class TrendingTableModel extends DefaultTableModel {

        ArrayList<Boolean> isValueWithinLimits = new ArrayList<Boolean>();
        ArrayList<RefrigChannel> dataChannels = new ArrayList<RefrigChannel>();
        ArrayList<RefrigChangedLimit> changedLimits = new ArrayList<RefrigChangedLimit>();

        public TrendingTableModel() {
            super(columnNames, 0);
        }

        void addTrendingRow(RefrigChannel chan) {
            addRow(new Object[]{chan.getDescription(), new Float(chan.getValue()), chan.getUnits(), new Double(chan.getLowLimit()), new Double(chan.getHighLimit()), chan.getName()});
            dataChannels.add(chan);
        }
        Class[] types = new Class[]{
            java.lang.String.class, TrendingValue.class, java.lang.String.class, java.lang.Double.class, java.lang.Double.class, java.lang.String.class
        };
        boolean[] canEdit = new boolean[]{
            false, false, false, true, true, false
        };

        public Class getColumnClass(int columnIndex) {
            return types[columnIndex];
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return canEdit[columnIndex];
        }

        public void setIsValueWithinLimits(int rowIndex, boolean isWithinLimits) {
            dataChannels.get(rowIndex).setIsWithinLimits(isWithinLimits);
        }

        public boolean getIsValueWithinLimits(int rowIndex) {
            return dataChannels.get(rowIndex).getIsWithinLimits();
        }

        public int getChannelBitNum(int rowIndex) {
            return dataChannels.get(rowIndex).getStateBit();
        }

        public void setLowLimit(int rowIndex, double value) {
            dataChannels.get(rowIndex).setLowLimit(value);
            setValueAt(value, rowIndex, LOW_LIMIT_IND);
            changedLimits.add(new RefrigChangedLimit(rowIndex, value, true));
        }

        public void setHighLimit(int rowIndex, double value) {
            dataChannels.get(rowIndex).setHighLimit(value);
            setValueAt(value, rowIndex, HIGH_LIMIT_IND);
            changedLimits.add(new RefrigChangedLimit(rowIndex, value, false));
        }

        public double getLowLimit(int rowIndex) {
            return dataChannels.get(rowIndex).getLowLimit();
        }

        public double getHighLimit(int rowIndex) {
            return dataChannels.get(rowIndex).getHighLimit();
        }

        public void addChangedLimit(RefrigChangedLimit changedLimit) {
            changedLimits.add(changedLimit);
        }

        public List<RefrigChangedLimit> getChangedLimits() {
            return changedLimits;
        }

        public boolean hasLimitChanged(int row, int column) {
            for (RefrigChangedLimit limit : changedLimits) {
                if (limit.getIndex() == row && ((column == LOW_LIMIT_IND) == limit.isLowLimit())) {
                    return true;
                }
            }
            return false;
        }
        
        public void clearChangedLimits() {
            changedLimits.clear();
        }
    }

    public void configurationSaved() {
        SwingUtilities.invokeLater(new ConfigurationSaved());
    }
    
    class TrendingValue {
    }

    class UpdateTrendingTable implements Runnable {

        RefrigTrendingStatus s;

        UpdateTrendingTable(RefrigTrendingStatus s) {
            this.s = s;
        }

        @Override
        public void run() {
            TrendingTableModel model = (TrendingTableModel) jTable1.getModel();
            for (int i = 0; i < model.getRowCount(); i++) {
                String channelName = (String) model.getValueAt(i, NAME_IND);
                for (ValueNotification vn : s.getListOfValues()) {
                    if (vn.getName().equals(channelName)) {
                        model.setValueAt(vn.getData(), i, VALUE_IND);
                        model.setIsValueWithinLimits(i, RefrigUtils.isChannelWithinLimits(model.getChannelBitNum(i), s.getRefrigState()));
                    }
                }
            }
        }
    }

    class UpdateTrendingTableLimits implements Runnable {

        RefrigChannelLimitStatus s;

        UpdateTrendingTableLimits(RefrigChannelLimitStatus s) {
            this.s = s;
        }

        @Override
        public void run() {
            TrendingTableModel model = (TrendingTableModel) jTable1.getModel();
            if (s.getType() == RefrigChannelLimitStatus.HIGH_LIMIT) {
                model.setHighLimit(s.getIndex(), s.getValue());
            } else {
                model.setLowLimit(s.getIndex(), s.getValue());
            }
        }
    }

    class UpdateTrendingTableModel implements Runnable {

        RefrigTrendingSummaryStatus s;

        UpdateTrendingTableModel(RefrigTrendingSummaryStatus s) {
            this.s = s;
        }

        @Override
        public void run() {

            ArrayList<RefrigChannel> channelsArray = s.getChannelsArray();

            TrendingTableModel model = (TrendingTableModel) jTable1.getModel();

            for (RefrigChannel chan : channelsArray) {
                model.addTrendingRow(chan);
            }

            jTable1.setDefaultRenderer(TrendingValue.class, new TrendingTableCellRenderer());
            jTable1.setDefaultRenderer(Double.class, new LimitsCellRenderer());

            jTable1.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);

            for (int i = 0; i < jTable1.getColumnCount(); i++) {
                DefaultTableColumnModel colModel = (DefaultTableColumnModel) jTable1.getColumnModel();
                TableColumn col = colModel.getColumn(i);

                TableCellRenderer renderer = col.getHeaderRenderer();
                if (renderer == null) {
                    renderer = jTable1.getTableHeader().getDefaultRenderer();
                }
                Component headerComp = renderer.getTableCellRendererComponent(jTable1, col.getHeaderValue(), false, false, 0, 0);
                int width = headerComp.getPreferredSize().width;


                for (int r = 0; r < jTable1.getRowCount(); r++) {
                    renderer = jTable1.getCellRenderer(r, i);
                    Component comp = renderer.getTableCellRendererComponent(jTable1, jTable1.getValueAt(r, i), false, false, r, i);
                    width = Math.max(width, comp.getPreferredSize().width);
                }
                col.setPreferredWidth(width + 4);
            }


        }
    }

    class LimitsCellRenderer extends DefaultTableCellRenderer {

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected,
                boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TrendingTableModel model = (TrendingTableModel) table.getModel();
            if ((column == LOW_LIMIT_IND || column == HIGH_LIMIT_IND) && model.hasLimitChanged(row, column)) {
                Font f = c.getFont();
                Font boldF = new Font(f.getName(), Font.BOLD, f.getSize() + 2);
                c.setFont(boldF);
                c.setForeground(Color.blue);
            } else {
                c.setForeground(Color.black);
            }

            return c;
        }
    }

    class TrendingTableCellRenderer extends DefaultTableCellRenderer {

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected,
                boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TrendingTableModel model = (TrendingTableModel) table.getModel();

            if (table.getModel().getColumnName(column).equals(columnNames[VALUE_IND])) {
                Color color = !model.getIsValueWithinLimits(row) ? Color.red : Color.green;
                c.setBackground(color);
            } else {
                c.setBackground(Color.white);
            }
            return c;
        }
    }

    class UpdateLimitsButton implements Runnable {

        boolean enabled;

        UpdateLimitsButton(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public void run() {
            RefrigAssembly assembly = (RefrigAssembly) getRefrigGui().getGuiLayout();
            assembly.getControlPanel().getLimitsButton().setEnabled(enabled);
        }
    }
    
    class ConfigurationSaved implements Runnable {

        @Override
        public void run() {
            RefrigAssembly assembly = (RefrigAssembly) getRefrigGui().getGuiLayout();
            assembly.getControlPanel().getLimitsButton().setEnabled(false);
            ((TrendingTableModel)jTable1.getModel()).clearChangedLimits();
            jTable1.repaint();
        }
        
    }

    class RefrigChangedLimit {

        boolean isLowLimit;
        int index;
        double value;

        RefrigChangedLimit(int index, double value, boolean isLowLimit) {
            this.index = index;
            this.value = value;
            this.isLowLimit = isLowLimit;
        }

        public int getIndex() {
            return index;
        }

        public boolean isLowLimit() {
            return isLowLimit;
        }

        public double getValue() {
            return value;
        }
    }
}
