/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * RefirgControlPanel.java
 *
 * Created on Jan 25, 2012, 8:40:10 AM
 */
package org.lsst.ccs.subsystems.refrig.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.refrig.status.RefrigTrendingStatus;

/**
 *
 * @author turri
 */
public class RefrigControlPanel extends javax.swing.JPanel {

    final Font f = new java.awt.Font("Tahoma", 1, 12);
    RefrigGUISubsystem refrigGui;

    /** Creates new form RefirgControlPanel */
    public RefrigControlPanel(RefrigGUISubsystem refrigGui) {
        this.refrigGui = refrigGui;
        initComponents();
        powerStatus.setFont(f);
        loadTripStatus.setFont(f);
        
        ControlsActionListener buttonListener = new ControlsActionListener();
        loadTripButton.addActionListener(buttonListener);
        powerButton.addActionListener(buttonListener);
        limitsButton.addActionListener(buttonListener);

        limitsButton.setActionCommand("saveLimits");
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        powerLabel = new javax.swing.JLabel();
        powerButton = new javax.swing.JButton();
        loadTripLabel = new javax.swing.JLabel();
        loadTripButton = new javax.swing.JButton();
        limitsButton = new javax.swing.JButton();
        powerStatus = new javax.swing.JLabel();
        loadTripStatus = new javax.swing.JLabel();

        powerLabel.setFont(new java.awt.Font("Tahoma", 1, 12));
        powerLabel.setText("Power:");

        powerButton.setText(".....");
        powerButton.setEnabled(false);

        loadTripLabel.setFont(new java.awt.Font("Tahoma", 1, 12));
        loadTripLabel.setText("Load Trip:");

        loadTripButton.setText(".....");
        loadTripButton.setEnabled(false);
        loadTripButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadTripButtonActionPerformed(evt);
            }
        });

        limitsButton.setText("Save Limits");
        limitsButton.setActionCommand("Save Limits");
        limitsButton.setEnabled(false);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(powerLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(powerStatus)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(powerButton)
                .addGap(18, 18, 18)
                .addComponent(loadTripLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(loadTripStatus)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(loadTripButton)
                .addGap(59, 59, 59)
                .addComponent(limitsButton)
                .addContainerGap(76, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(limitsButton)
                    .addComponent(loadTripButton)
                    .addComponent(loadTripLabel)
                    .addComponent(powerLabel)
                    .addComponent(powerButton)
                    .addComponent(powerStatus)
                    .addComponent(loadTripStatus))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void loadTripButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadTripButtonActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_loadTripButtonActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton limitsButton;
    private javax.swing.JButton loadTripButton;
    private javax.swing.JLabel loadTripLabel;
    private javax.swing.JLabel loadTripStatus;
    private javax.swing.JButton powerButton;
    private javax.swing.JLabel powerLabel;
    private javax.swing.JLabel powerStatus;
    // End of variables declaration//GEN-END:variables

    public void updateControlPanel(RefrigTrendingStatus s) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(s));
    }

    javax.swing.JButton getLimitsButton() {
        return limitsButton;
    }
    
    class UpdateRefrigStatus implements Runnable {

        RefrigTrendingStatus s;

        UpdateRefrigStatus(RefrigTrendingStatus s) {
            this.s = s;
        }

        @Override
        public void run() {
            powerStatus.setText(s.isPowerEnabled() ? "ON" : "OFF");
            powerStatus.setForeground(s.isPowerEnabled() ? Color.green : Color.black);
            powerButton.setEnabled(true);
            powerButton.setText(s.isPowerEnabled() ? "Turn Power OFF" : "Turn Power ON");
            powerButton.setActionCommand(s.isPowerEnabled() ? "turnPowerOff" : "turnPowerOn");

            loadTripStatus.setText(s.isLoadTripEnabled() ? "ON" : "OFF");
            loadTripStatus.setForeground(s.isLoadTripEnabled() ? Color.green : Color.black);
            loadTripButton.setEnabled(true);
            loadTripButton.setText(s.isLoadTripEnabled() ? "Turn Load Trip OFF" : "Turn Load Trip ON");
            loadTripButton.setActionCommand(s.isLoadTripEnabled() ? "turnLoadTripOff" : "turnLoadTripOn");
        }
    }

    class ControlsActionListener implements ActionListener {

        public void actionPerformed(ActionEvent e) {
            if ("turnPowerOff".equals(e.getActionCommand())) {
                refrigGui.setPowerStatus(false);
                powerButton.setEnabled(false);
            } else if ("turnPowerOn".equals(e.getActionCommand())){
                refrigGui.setPowerStatus(true);
                powerButton.setEnabled(false);
            }
            else if ("turnLoadTripOff".equals(e.getActionCommand())) {
                refrigGui.setLoadTripStatus(false);
                loadTripButton.setEnabled(false);
            } else if ("turnLoadTripOn".equals(e.getActionCommand())){
                refrigGui.setLoadTripStatus(true);
                loadTripButton.setEnabled(false);
            } else if ("saveLimits".equals(e.getActionCommand())){
                refrigGui.saveConfiguration();
                limitsButton.setEnabled(false);
            }
        }
    }
    
}
