/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.dispatch;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import org.lsst.ccs.utilities.dispatch.CommandFor;
import org.lsst.ccs.utilities.dispatch.PackCst;

public class ParallelCommandDispatcher<T> {
    protected ExecutorService loop;
    protected CopyOnWriteArrayList<T> list = new CopyOnWriteArrayList();

    public ParallelCommandDispatcher() {
        this.loop = PackCst.EXECUTOR_SERVICE;
    }

    public ParallelCommandDispatcher(ExecutorService execService) {
        this.loop = execService;
    }

    public void addExecutant(T executant) {
        this.list.add(executant);
    }

    public void removeExecutant(T executant) {
        this.list.remove(executant);
    }

    public void dispatchCommand(CommandFor<T> command) {
        for (T executant : this.list) {
            this.loop.submit(new DoIt<T>(executant, command));
        }
    }

    static class DoIt<T2>
    implements Runnable {
        public final T2 executant;
        public final CommandFor<T2> command;

        DoIt(T2 executant, CommandFor<T2> command) {
            this.executant = executant;
            this.command = command;
        }

        @Override
        public void run() {
            try {
                this.command.invokeOn(this.executant);
            }
            catch (Exception exc) {
                PackCst.CURLOG.log(Level.SEVERE, "while executing :", exc);
            }
        }
    }
}

