/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.Axis;
import jas.plot.ColorMapAxis;
import jas.plot.EditableLabel;
import jas.plot.LayoutFailed;
import jas.plot.SpaceRequirements;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public final class DataAreaLayout
implements LayoutManager2 {
    public static final String X_AXIS = "x";
    public static final String Y_AXIS_LEFT = "yl";
    public static final String Y_AXIS_RIGHT = "yr";
    public static final String X_AXIS_LABEL = "xl";
    public static final String Y_AXIS_LEFT_LABEL = "yll";
    public static final String Y_AXIS_RIGHT_LABEL = "yrl";
    private Axis xAxis;
    private Axis yAxis_left;
    private Axis yAxis_right;
    private EditableLabel xAxis_label;
    private EditableLabel yAxis_left_label;
    private EditableLabel yAxis_right_label;
    private static final int pad = 5;
    private static final SpaceRequirements nullSpaceRequirements;
    private int xAxisLength = -1;
    private int yLeftAxisLength = -1;
    private int yRightAxisLength = -1;
    private boolean hasColorMap = false;
    private Dimension lastParentSize;
    private static final boolean debug;

    public void addLayoutComponent(Component c, Object constraints) {
        if (c instanceof Axis) {
            if (X_AXIS.equals(constraints)) {
                this.xAxis = (Axis)c;
                this.xAxisLength = -1;
            } else if (Y_AXIS_LEFT.equals(constraints)) {
                this.yAxis_left = (Axis)c;
                this.yLeftAxisLength = -1;
            } else if (Y_AXIS_RIGHT.equals(constraints)) {
                this.yAxis_right = (Axis)c;
                this.yRightAxisLength = -1;
                if (c instanceof ColorMapAxis) {
                    this.hasColorMap = true;
                }
            }
        } else if (c instanceof EditableLabel) {
            if (X_AXIS_LABEL.equals(constraints)) {
                this.xAxis_label = (EditableLabel)c;
            } else if (Y_AXIS_LEFT_LABEL.equals(constraints)) {
                this.yAxis_left_label = (EditableLabel)c;
            } else if (Y_AXIS_RIGHT_LABEL.equals(constraints)) {
                this.yAxis_right_label = (EditableLabel)c;
            }
        }
    }

    public void addLayoutComponent(String s, Component c) {
        this.addLayoutComponent(c, s);
    }

    public void removeLayoutComponent(Component c) {
        if (c == this.xAxis) {
            this.xAxis = null;
        } else if (c == this.yAxis_left) {
            this.yAxis_left = null;
        } else if (c == this.yAxis_right) {
            this.yAxis_right = null;
            if (this.hasColorMap) {
                this.hasColorMap = false;
            }
        } else if (c == this.xAxis_label) {
            this.xAxis_label = null;
        } else if (c == this.yAxis_left_label) {
            this.yAxis_left_label = null;
        } else if (c == this.yAxis_right_label) {
            this.yAxis_right_label = null;
        }
    }

    private int getLabelSpaceOnTop() {
        int labelSpaceOnTop = 0;
        if (this.yAxis_left_label != null && !this.yAxis_left_label.isRotated()) {
            labelSpaceOnTop = this.yAxis_left_label.getPreferredSize().height + 5;
        }
        if (this.yAxis_right_label != null && this.yAxis_right != null && !this.yAxis_right_label.isRotated()) {
            labelSpaceOnTop = Math.max(this.yAxis_right_label.getPreferredSize().height, labelSpaceOnTop);
        }
        return labelSpaceOnTop;
    }

    public void layoutContainer(Container parent) {
        if (this.yAxis_left != null && this.xAxis != null) {
            int distFromRightSide;
            int yorigin;
            int xorigin;
            SpaceRequirements y_right;
            SpaceRequirements y_left;
            SpaceRequirements x;
            int height;
            int width;
            Insets insets;
            int labelSpaceOnTop;
            Dimension parentSize;
            block32: {
                parentSize = parent.getSize();
                if (parentSize.width <= 0 || parentSize.height <= 0) {
                    return;
                }
                labelSpaceOnTop = this.getLabelSpaceOnTop();
                int labelSpaceOnBottom = this.xAxis_label != null ? this.xAxis_label.getPreferredSize().height + 5 : 0;
                insets = parent.getInsets();
                width = parentSize.width - insets.right - insets.left - (this.hasColorMap ? 30 : 0);
                height = parentSize.height - insets.top - insets.bottom - labelSpaceOnTop - labelSpaceOnBottom;
                x = this.xAxis.type.spaceRequirements;
                y_left = this.yAxis_left.type.spaceRequirements;
                SpaceRequirements spaceRequirements = y_right = this.yAxis_right != null ? this.yAxis_right.type.spaceRequirements : nullSpaceRequirements;
                this.xAxisLength = this.lastParentSize != null && this.xAxisLength > 0 ? (this.xAxisLength += parentSize.width - this.lastParentSize.width) : parentSize.width * 9 / 10;
                this.yLeftAxisLength = this.lastParentSize != null && this.yLeftAxisLength > 0 ? (this.yLeftAxisLength += parentSize.height - this.lastParentSize.height) : parentSize.height * 9 / 10;
                this.yRightAxisLength = this.lastParentSize != null && this.yRightAxisLength > 0 && this.yAxis_right != null ? (this.yRightAxisLength += parentSize.height - this.lastParentSize.height) : parentSize.height * 9 / 10;
                int iterationCounter = 0;
                int maxIterations = 8;
                int x_smallest = 0;
                int y_left_smallest = 0;
                int y_right_smallest = 0;
                int normalMaximumNumberOfIterations = 2;
                int criticalNumberOfIterations = 5;
                do {
                    int minHeight;
                    boolean allLengthsAreAdequate = true;
                    if (iterationCounter < 5) {
                        this.xAxis.assumeAxisLength(this.xAxisLength);
                        this.yAxis_left.assumeAxisLength(this.yLeftAxisLength);
                        if (this.yAxis_right != null) {
                            this.yAxis_right.assumeAxisLength(this.yRightAxisLength);
                        }
                    } else {
                        if (debug) {
                            System.out.println("******* USED BACKUP PLAN FOR LAYOUT");
                        }
                        this.xAxis.assumeAxisLength(x_smallest);
                        this.yAxis_left.assumeAxisLength(y_left_smallest);
                        if (this.yAxis_right != null) {
                            this.yAxis_right.assumeAxisLength(y_right_smallest);
                        }
                    }
                    xorigin = Math.max(x.width, y_left.width) + 3;
                    yorigin = Math.max(Math.max(x.height, y_left.height), y_right.height) + 3;
                    distFromRightSide = Math.max(x.flowPastEnd, y_right.width) + 3;
                    int minWidth = xorigin + distFromRightSide + this.xAxisLength + insets.left + insets.right;
                    if (minWidth != parentSize.width) {
                        this.xAxisLength = Math.max(0, this.xAxisLength + parentSize.width - minWidth);
                        allLengthsAreAdequate = false;
                    }
                    if ((minHeight = yorigin + y_left.flowPastEnd + 3 + this.yLeftAxisLength + insets.top + insets.bottom) != parentSize.height) {
                        this.yLeftAxisLength = Math.max(0, this.yLeftAxisLength + parentSize.height - minHeight);
                        allLengthsAreAdequate = false;
                    }
                    if (this.yAxis_right != null && (minHeight = yorigin + y_right.flowPastEnd + 3 + this.yRightAxisLength + insets.top + insets.bottom) != parentSize.height) {
                        this.yRightAxisLength = Math.max(0, this.yRightAxisLength + parentSize.height - minHeight);
                        allLengthsAreAdequate = false;
                    }
                    ++iterationCounter;
                    if (allLengthsAreAdequate) {
                        if (debug) {
                            System.out.println("layout required " + iterationCounter + " iteration(s)");
                        }
                        break block32;
                    }
                    if (iterationCounter <= 2) continue;
                    if (this.xAxisLength > 0) {
                        if (x_smallest == 0) {
                            x_smallest = this.xAxisLength;
                        } else if (this.xAxisLength < x_smallest) {
                            x_smallest = this.xAxisLength;
                        }
                    }
                    if (this.yLeftAxisLength > 0) {
                        if (y_left_smallest == 0) {
                            y_left_smallest = this.yLeftAxisLength;
                        } else if (this.yLeftAxisLength < y_left_smallest) {
                            y_left_smallest = this.yLeftAxisLength;
                        }
                    }
                    if (this.yAxis_right == null || this.yRightAxisLength <= 0) continue;
                    if (y_right_smallest == 0) {
                        y_right_smallest = this.yRightAxisLength;
                        continue;
                    }
                    if (this.yRightAxisLength >= y_right_smallest) continue;
                    y_right_smallest = this.yRightAxisLength;
                } while (iterationCounter < 8);
                throw new LayoutFailed();
            }
            if (this.yAxis_left_label != null && this.yAxis_left_label.isRotated()) {
                xorigin = (int)((double)xorigin + (this.yAxis_left_label.getPreferredSize().getHeight() + 5.0));
            }
            this.yAxis_left.setLocation(xorigin - y_left.width + insets.left, insets.top + labelSpaceOnTop);
            this.yAxis_left.setSize(y_left.width, height - yorigin + y_left.height);
            if (this.yAxis_left_label != null) {
                if (this.yAxis_left_label.isRotated()) {
                    this.yAxis_left_label.setLocation(5, 5 + insets.top + (height - (int)this.yAxis_left_label.getPreferredSize().getWidth()) / 2);
                    this.yAxis_left_label.setSize((int)this.yAxis_left_label.getPreferredSize().getWidth(), (int)this.yAxis_left_label.getPreferredSize().getWidth());
                } else {
                    this.yAxis_left_label.setLocation(insets.left + 5, insets.top + 5);
                    this.yAxis_left_label.setSize(this.yAxis_left_label.getPreferredSize());
                }
            }
            if (this.yAxis_right_label != null && this.yAxis_right_label.isRotated()) {
                distFromRightSide += (int)this.yAxis_right_label.getPreferredSize().getHeight();
            }
            this.xAxis.setLocation(xorigin - x.width + insets.left, height + insets.top - yorigin + labelSpaceOnTop);
            this.xAxis.setSize(width - xorigin + x.width - distFromRightSide + 3 + x.flowPastEnd, x.height);
            if (this.xAxis_label != null) {
                Dimension prefSize = this.xAxis_label.getPreferredSize();
                this.xAxis_label.setLocation((width - xorigin - distFromRightSide) / 2 + xorigin - prefSize.width / 2 + insets.left, parentSize.height - insets.bottom - 5 - prefSize.height);
                this.xAxis_label.setSize(prefSize);
            }
            if (this.yAxis_right != null) {
                this.yAxis_right.setLocation(width - distFromRightSide - insets.left, insets.top + labelSpaceOnTop);
                this.yAxis_right.setSize(y_right.width + (this.hasColorMap ? 30 : 0), height - yorigin + y_right.height);
                if (this.yAxis_right_label != null) {
                    Dimension prefSize = this.yAxis_right_label.getPreferredSize();
                    if (this.yAxis_right_label.isRotated()) {
                        this.yAxis_right_label.setLocation(parentSize.width - insets.right - 5 - prefSize.height, 5 + insets.top + (height - (int)prefSize.getWidth()) / 2);
                        this.yAxis_right_label.setSize((int)prefSize.getWidth(), (int)prefSize.getWidth());
                    } else {
                        this.yAxis_right_label.setLocation(parentSize.width - insets.right - 5 - prefSize.width, insets.top + 5);
                        this.yAxis_right_label.setSize(prefSize);
                    }
                }
            }
            this.lastParentSize = parentSize;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension maximumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(10, 10);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    static {
        boolean result;
        nullSpaceRequirements = new SpaceRequirements();
        try {
            result = System.getProperty("debugDataAreaLayout") != null;
        }
        catch (SecurityException x) {
            result = false;
        }
        debug = result;
    }
}

