/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.wattsup;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.drivers.wattsup.WattsUpException;

public class WattsUp
implements SerialPortEventListener {
    public static final int FLD_WATTS = 0;
    public static final int FLD_VOLTS = 1;
    public static final int FLD_AMPS = 2;
    public static final int FLD_WATT_HOURS = 3;
    public static final int FLD_COST = 4;
    public static final int FLD_WH_MONTH = 5;
    public static final int FLD_COST_MONTH = 6;
    public static final int FLD_WATTS_MAX = 7;
    public static final int FLD_VOLTS_MAX = 8;
    public static final int FLD_AMPS_MAX = 9;
    public static final int FLD_WATTS_MIN = 10;
    public static final int FLD_VOLTS_MIN = 11;
    public static final int FLD_AMPS_MIN = 12;
    public static final int FLD_POWER_FACTOR = 13;
    public static final int FLD_DUTY_CYCLE = 14;
    public static final int FLD_POWER_CYCLE = 15;
    public static final int FLD_FREQUENCY = 16;
    public static final int FLD_VOLT_AMPS = 17;
    public static final int N_FIELDS = 18;
    public static final int N_CAL_FIELDS = 48;
    public static final int MEM_OPT_SUSPEND = 0;
    public static final int MEM_OPT_OVERWRITE = 1;
    public static final int MEM_OPT_CONDENSE = 2;
    public static final int LOG_STA_SUSPENDED = 0;
    public static final int LOG_STA_INTERNAL = 1;
    public static final int LOG_STA_EXTERNAL = 2;
    public static final int VER_FLD_MODEL = 0;
    public static final int VER_FLD_MEMORY = 1;
    public static final int VER_FLD_HWMAJOR = 2;
    public static final int VER_FLD_HW_MINOR = 3;
    public static final int VER_FLD_FWMAJOR = 4;
    public static final int VER_FLD_FWMINOR = 5;
    public static final int VER_FLD_FWTSTAMP = 6;
    public static final int VER_FLD_CHECKSUM = 7;
    public static final int N_VER_FIELDS = 8;
    private static final int BAUD_RATE = 115200;
    private static final int OPEN_TIMEOUT = 1000;
    private static final int READ_TIMEOUT = 2000;
    private static final int DATA_TIMEOUT = 30000;
    private static final int READ_SLEEP_TIME = 5000;
    private static final String DFLT_NAME = "/dev/ttyUSB0";
    private final Thread readw = new Thread(new Reader());
    private CommPortIdentifier portId;
    private SerialPort port;
    private InputStream winp;
    private OutputStream wout;
    private boolean gotData;
    private boolean running;
    private ArrayBlockingQueue replyQ = new ArrayBlockingQueue(10);
    private int buffCurr;
    private int replyStart;
    private int replyEnd;
    private int replyCurr;
    private int nDataSent;
    private DataListener dataListener;

    public WattsUp() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (WattsUp.this.port != null) {
                    WattsUp.this.port.close();
                }
            }
        });
        this.readw.start();
    }

    public void open() {
        this.open(DFLT_NAME);
    }

    public void open(String portName) {
        if (this.port != null) {
            throw new WattsUpException("Port already open");
        }
        try {
            this.nDataSent = 0;
            this.buffCurr = 0;
            this.replyStart = -1;
            this.replyEnd = -1;
            this.replyCurr = 0;
            this.portId = CommPortIdentifier.getPortIdentifier((String)portName);
            this.port = (SerialPort)this.portId.open("WattsUp", 1000);
            this.port.setSerialPortParams(115200, 8, 1, 0);
            this.winp = this.port.getInputStream();
            this.wout = this.port.getOutputStream();
            this.gotData = false;
            this.running = true;
            this.port.addEventListener((SerialPortEventListener)this);
            this.port.notifyOnDataAvailable(true);
        }
        catch (Exception e) {
            throw new WattsUpException(e);
        }
    }

    public void close() {
        this.checkOpen();
        this.running = false;
        this.port.notifyOnDataAvailable(false);
        this.port.removeEventListener();
        this.port.close();
        this.port = null;
    }

    public void addDataListener(DataListener listener) {
        this.dataListener = listener;
    }

    public void removeDataListener() {
        this.dataListener = null;
    }

    public int getLoggedFields() {
        this.checkOpen();
        this.send("#C,R,0;");
        String[] reply = this.receive("c", 18);
        int mask = 0;
        int j = 0;
        while (j < 18) {
            if (reply[j].equals("1")) {
                mask |= 1 << j;
            }
            ++j;
        }
        return mask;
    }

    public int setLoggedFields(int mask) {
        this.checkOpen();
        String cmnd = "#C,W,18";
        int j = 0;
        while (j < 18) {
            cmnd = String.valueOf(cmnd) + "," + ((mask & 1 << j) != 0 ? "1" : "0");
            ++j;
        }
        cmnd = String.valueOf(cmnd) + ';';
        this.send(cmnd);
        return Integer.valueOf(this.receive("n", 1)[0]);
    }

    public int[] getCalibrationData() {
        this.checkOpen();
        this.send("#F,R,0;");
        String[] reply = this.receive("f", 48);
        int[] values = new int[48];
        int j = 0;
        while (j < 48) {
            values[j] = (int)Long.valueOf(reply[j]).longValue();
            ++j;
        }
        return values;
    }

    public String[] getHeaderRecord() {
        this.checkOpen();
        this.send("#H,R,0;");
        return this.receive("h", 18);
    }

    public int getLoggedData() {
        this.checkOpen();
        this.send("#D,R,0;");
        this.receive("n", 3);
        int count = this.nDataSent;
        while (true) {
            try {
                return Integer.valueOf(this.receive("l", 2)[1]);
            }
            catch (WattsUpException e) {
                if (this.nDataSent == count) {
                    throw e;
                }
                count = this.nDataSent;
                continue;
            }
            break;
        }
    }

    public int setInternalLogging(int interval) {
        this.checkOpen();
        this.send("#L,W,3,_,I," + interval + ";");
        return Integer.valueOf(this.receive("s", 3)[1]);
    }

    public void setExternalLogging(int interval) {
        this.checkOpen();
        this.send("#L,W,3,_,E," + interval + ";");
    }

    public int getRecordLimit() {
        this.checkOpen();
        this.send("#N,R,0;");
        return Integer.valueOf(this.receive("n", 1)[0]);
    }

    public int getFullOption() {
        this.checkOpen();
        this.send("#O,R,0;");
        return Integer.valueOf(this.receive("o", 1)[0]);
    }

    public void setFullOption(int option) {
        this.checkOpen();
        this.send("#O,W,1," + option + ";");
    }

    public void resetMemory() {
        this.checkOpen();
        this.send("#R,W,0;");
    }

    public int getLoggingInterval() {
        this.checkOpen();
        this.send("#S,R,0;");
        return Integer.valueOf(this.receive("s", 3)[1]);
    }

    public int getLoggingState() {
        this.checkOpen();
        this.send("#S,R,0;");
        return Integer.valueOf(this.receive("s", 3)[2]);
    }

    public void setLoggingInterval(int interval) {
        this.checkOpen();
        this.send("#S,W,2,_," + interval + ";");
    }

    public float getUserRate() {
        this.checkOpen();
        this.send("#U,R,0;");
        return Float.valueOf(this.receive("u", 3)[0]).floatValue() / 1000.0f;
    }

    public int getUserThreshold() {
        this.checkOpen();
        this.send("#U,R,0;");
        return Integer.valueOf(this.receive("u", 3)[1]);
    }

    public boolean getUserEuro() {
        this.checkOpen();
        this.send("#U,R,0;");
        return !this.receive("u", 3)[2].equals("0");
    }

    public void setUserParameters(float rate, int threshold, boolean euro) {
        this.checkOpen();
        this.send("#U,W,3," + (int)((double)(1000.0f * rate) + 0.5) + "," + threshold + "," + (euro ? "1" : "0") + ";");
    }

    public String[] getVersionData() {
        this.checkOpen();
        this.send("#V,R,0;");
        return this.receive("v", 8);
    }

    public void restart() {
        this.checkOpen();
        this.send("#V,W,0;");
    }

    public void serialEvent(SerialPortEvent event) {
        if (event.getEventType() == 1) {
            this.gotData = true;
            this.readw.interrupt();
        }
    }

    private void send(String cmnd) {
        try {
            this.wout.write(cmnd.getBytes());
        }
        catch (IOException e) {
            throw new WattsUpException(e);
        }
    }

    private String[] receive(String id, int nFlds) {
        return this.receive(id, nFlds, 2000);
    }

    private String[] receive(String id, int nFlds, int timeout) {
        String reply = null;
        try {
            reply = (String)this.replyQ.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {}
        if (reply == null) {
            throw new WattsUpException("Receive timeout");
        }
        String[] head = reply.split(",", 4);
        if (head.length < 3 || !head[0].equals(id) || Integer.valueOf(head[2]) != nFlds) {
            throw new WattsUpException("Unexpected reply received");
        }
        if (head.length < 4) {
            return null;
        }
        return head[3].split(",");
    }

    private void sendListener(String reply) {
        ++this.nDataSent;
        if (this.dataListener == null) {
            return;
        }
        String[] fields = reply.split(",");
        float[] values = new float[18];
        int j = 0;
        while (j < 18) {
            String field = fields[j + 3];
            if (field.equals("_")) {
                values[j] = 0.0f;
            } else {
                int temp = Integer.valueOf(field);
                values[j] = j == 2 || j == 9 || j == 12 || j == 4 || j == 6 ? (float)temp / 1000.0f : (j == 5 || j == 15 ? (float)temp : (j == 13 || j == 14 ? (float)temp / 100.0f : (float)temp / 10.0f));
            }
            ++j;
        }
        this.dataListener.process(values);
    }

    private void checkOpen() {
        if (this.port == null) {
            throw new WattsUpException("Port not open");
        }
    }

    static /* synthetic */ boolean access$0(WattsUp wattsUp) {
        return wattsUp.running;
    }

    static /* synthetic */ boolean access$1(WattsUp wattsUp) {
        return wattsUp.gotData;
    }

    static /* synthetic */ void access$2(WattsUp wattsUp, boolean bl) {
        wattsUp.gotData = bl;
    }

    static /* synthetic */ InputStream access$3(WattsUp wattsUp) {
        return wattsUp.winp;
    }

    static /* synthetic */ int access$4(WattsUp wattsUp) {
        return wattsUp.buffCurr;
    }

    static /* synthetic */ void access$5(WattsUp wattsUp, int n) {
        wattsUp.buffCurr = n;
    }

    static /* synthetic */ int access$6(WattsUp wattsUp) {
        return wattsUp.replyCurr;
    }

    static /* synthetic */ int access$7(WattsUp wattsUp) {
        return wattsUp.replyStart;
    }

    static /* synthetic */ void access$8(WattsUp wattsUp, int n) {
        wattsUp.replyCurr = n;
    }

    static /* synthetic */ void access$9(WattsUp wattsUp, int n) {
        wattsUp.replyStart = n;
    }

    static /* synthetic */ int access$10(WattsUp wattsUp) {
        return wattsUp.replyEnd;
    }

    static /* synthetic */ void access$11(WattsUp wattsUp, int n) {
        wattsUp.replyEnd = n;
    }

    static /* synthetic */ DataListener access$12(WattsUp wattsUp) {
        return wattsUp.dataListener;
    }

    static /* synthetic */ void access$13(WattsUp wattsUp, String string) {
        wattsUp.sendListener(string);
    }

    static /* synthetic */ ArrayBlockingQueue access$14(WattsUp wattsUp) {
        return wattsUp.replyQ;
    }

    public static interface DataListener {
        public void process(float[] var1);
    }

    private class Reader
    implements Runnable {
        private Reader() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            buff = new byte[1024];
            while (true) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException v0) {}
                if (!WattsUp.access$0(WattsUp.this) || !WattsUp.access$1(WattsUp.this)) continue;
                WattsUp.access$2(WattsUp.this, false);
                try {
                    leng = WattsUp.access$3(WattsUp.this).read(buff, WattsUp.access$4(WattsUp.this), buff.length - WattsUp.access$4(WattsUp.this));
                }
                catch (IOException e) {
                    System.out.println(e);
                    break;
                }
                if (leng <= 0) continue;
                v1 = WattsUp.this;
                WattsUp.access$5(v1, WattsUp.access$4(v1) + leng);
                ** GOTO lbl44
                {
                    v2 = WattsUp.this;
                    v3 = WattsUp.access$6(v2);
                    WattsUp.access$8(v2, v3 + 1);
                    if (buff[v3] == 35) {
                        WattsUp.access$9(WattsUp.this, WattsUp.access$6(WattsUp.this));
                    }
                    do {
                        if (WattsUp.access$7(WattsUp.this) < 0 && WattsUp.access$6(WattsUp.this) < WattsUp.access$4(WattsUp.this)) continue block5;
                        while (WattsUp.access$10(WattsUp.this) < 0 && WattsUp.access$6(WattsUp.this) < WattsUp.access$4(WattsUp.this)) {
                            v4 = WattsUp.this;
                            v5 = WattsUp.access$6(v4);
                            WattsUp.access$8(v4, v5 + 1);
                            if (buff[v5] != 59) continue;
                            WattsUp.access$11(WattsUp.this, WattsUp.access$6(WattsUp.this) - 1);
                        }
                        if (WattsUp.access$7(WattsUp.this) < 0 || WattsUp.access$10(WattsUp.this) < 0) break block5;
                        replyId = buff[WattsUp.access$7(WattsUp.this)];
                        if (replyId != 100 || WattsUp.access$12(WattsUp.this) != null) {
                            reply = new String(buff, WattsUp.access$7(WattsUp.this), WattsUp.access$10(WattsUp.this) - WattsUp.access$7(WattsUp.this));
                            if (replyId == 100) {
                                WattsUp.access$13(WattsUp.this, reply);
                            } else {
                                WattsUp.access$14(WattsUp.this).offer(reply);
                            }
                        }
                        WattsUp.access$9(WattsUp.this, -1);
                        WattsUp.access$11(WattsUp.this, -1);
lbl44:
                        // 2 sources

                    } while (WattsUp.access$6(WattsUp.this) < WattsUp.access$4(WattsUp.this));
                }
                if (WattsUp.access$7(WattsUp.this) < 0) {
                    WattsUp.access$5(WattsUp.this, 0);
                    WattsUp.access$8(WattsUp.this, 0);
                    continue;
                }
                leng = WattsUp.access$4(WattsUp.this) - WattsUp.access$7(WattsUp.this);
                System.arraycopy(buff, WattsUp.access$7(WattsUp.this), buff, 0, leng);
                WattsUp.access$5(WattsUp.this, leng);
                WattsUp.access$9(WattsUp.this, 0);
                WattsUp.access$8(WattsUp.this, leng);
            }
        }
    }
}

