/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.wattsup;

import java.io.IOException;
import java.util.Scanner;
import jline.ConsoleReader;
import org.lsst.ccs.drivers.wattsup.WattsUp;
import org.lsst.ccs.drivers.wattsup.WattsUpException;
import org.lsst.ccs.utilities.sa.CmndProc;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestWattsUp
implements CmndProc.Dispatch,
WattsUp.DataListener {
    private static final int CMD_OPEN = 0;
    private static final int CMD_CLOSE = 1;
    private static final int CMD_FLDSHOW = 2;
    private static final int CMD_CALSHOW = 3;
    private static final int CMD_HDRSHOW = 4;
    private static final int CMD_LIMSHOW = 5;
    private static final int CMD_MEMSHOW = 6;
    private static final int CMD_LOGSHOW = 7;
    private static final int CMD_PARMSHOW = 8;
    private static final int CMD_VERSHOW = 9;
    private static final int CMD_FLDSET = 10;
    private static final int CMD_LOGSET = 11;
    private static final int CMD_MEMSET = 12;
    private static final int CMD_RESET = 13;
    private static final int CMD_INTSET = 14;
    private static final int CMD_PARMSET = 15;
    private static final int CMD_RESTART = 16;
    private static final int CMD_DATASHOW = 17;
    private static final int NUM_CMDS = 18;
    private static final String[] helpOpen = new String[]{"Open device connection", "open [<device>]", "device  The name of the serial port to connect to"};
    private static final String[] helpClose = new String[]{"Close device connection", "close"};
    private static final String[] helpFldset = new String[]{"Set the fields to be logged", "fldset <mask>", "mask  Bit mask of the fields to be logged"};
    private static final String[] helpFldshow = new String[]{"Display the fields being logged", "fldshow"};
    private static final String[] helpCalshow = new String[]{"Display calibration data", "calshow"};
    private static final String[] helpHdrshow = new String[]{"Display header record", "hdrshow"};
    private static final String[] helpLimshow = new String[]{"Display the record limit", "limshow"};
    private static final String[] helpMemset = new String[]{"Set the memory-full option", "memset <option>", "option  The memory-full option"};
    private static final String[] helpMemshow = new String[]{"Display the memory full option", "memshow"};
    private static final String[] helpLogset = new String[]{"Set the logging type and interval", "logset <type> <interval>", "type      The logging type: i = internal, e = external", "interval  The logging interval (secs)"};
    private static final String[] helpIntset = new String[]{"Set the logging interval", "intset <interval>", "interval  The logging interval (secs)"};
    private static final String[] helpLogshow = new String[]{"Display the logging state", "logshow"};
    private static final String[] helpParmset = new String[]{"Set the user parameters", "parmset <rate> <thresh> [<euro>]", "rate    The electricity rate (currency units / KWH)", "thresh  The duty cycle threshold (watts)", "euro    If non-zero, currency is euros, not dollars"};
    private static final String[] helpParmshow = new String[]{"Display the user parameters", "parmshow"};
    private static final String[] helpVershow = new String[]{"Display the version data", "vershow"};
    private static final String[] helpReset = new String[]{"Reset (clear) the logging memory", "reset"};
    private static final String[] helpRestart = new String[]{"Restart the meter", "restart"};
    private static final String[] helpDatashow = new String[]{"Read and display all the stored data", "datashow <summary>", "summary  If present and non-zero, show only the record count"};
    private final Output out = new ConsOut();
    private final CmndProc.Lookup devNames;
    private final ConsoleReader reader = new ConsoleReader();
    private final CmndProc proc = new CmndProc();
    private final WattsUp wtu = new WattsUp();
    private int fieldMask;
    private int dataCount;
    private boolean devOpen;
    private boolean dataSumm;
    private static final byte[] flags = new byte[]{124, 47, 45, 92};

    public TestWattsUp() throws IOException {
        CmndProc.Command cmnd = new CmndProc.Command(18);
        cmnd.add("open", 0, helpOpen);
        cmnd.add("close", 1, helpClose);
        cmnd.add("fldshow", 2, helpFldshow);
        cmnd.add("calshow", 3, helpCalshow);
        cmnd.add("hdrshow", 4, helpHdrshow);
        cmnd.add("limshow", 5, helpLimshow);
        cmnd.add("memshow", 6, helpMemshow);
        cmnd.add("logshow", 7, helpLogshow);
        cmnd.add("parmshow", 8, helpParmshow);
        cmnd.add("vershow", 9, helpVershow);
        cmnd.add("fldset", 10, helpFldset);
        cmnd.add("logset", 11, helpLogset);
        cmnd.add("memset", 12, helpMemset);
        cmnd.add("reset", 13, helpReset);
        cmnd.add("intset", 14, helpIntset);
        cmnd.add("parmset", 15, helpParmset);
        cmnd.add("restart", 16, helpRestart);
        cmnd.add("datashow", 17, helpDatashow);
        this.proc.add(this, cmnd);
        this.devNames = new CmndProc.Lookup(1);
        this.devNames.add("tc-ai", 0);
        this.wtu.addDataListener(this);
    }

    public static void main(String[] args) {
        TestWattsUp twtu = null;
        try {
            twtu = new TestWattsUp();
            twtu.run();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        System.exit(0);
    }

    public void run() throws IOException {
        String line;
        while ((line = this.reader.readLine(">> ")) != null) {
            try {
                if (this.proc.process(line)) continue;
                break;
            }
            catch (WattsUpException e) {
                this.out.println(e);
            }
        }
        if (this.devOpen) {
            this.wtu.close();
        }
    }

    @Override
    public boolean dispatch(int code, Scanner scan) {
        Object[] args = new Object[16];
        switch (code) {
            case 0: {
                int found = CmndProc.scanArgs(scan, "s", args);
                if (found < 0) break;
                if ((found & 1) != 0) {
                    this.wtu.open((String)args[0]);
                } else {
                    this.wtu.open();
                }
                this.devOpen = true;
                this.fieldMask = this.wtu.getLoggedFields();
                break;
            }
            case 1: {
                int found = CmndProc.scanArgs(scan, "", args);
                if (found < 0) break;
                this.wtu.close();
                this.devOpen = false;
                break;
            }
            case 10: {
                int found = CmndProc.scanArgs(scan, "I", args);
                if (found < 0) break;
                this.fieldMask = (Integer)args[0];
                int limit = this.wtu.setLoggedFields(this.fieldMask);
                this.out.println("Record limit = " + limit);
                break;
            }
            case 2: {
                int found = CmndProc.scanArgs(scan, "", args);
                if (found < 0) break;
                this.out.format("Value = %08x\n", this.wtu.getLoggedFields());
                break;
            }
            case 3: {
                int found = CmndProc.scanArgs(scan, "", args);
                if (found < 0) break;
                this.showIntegers(this.wtu.getCalibrationData());
                break;
            }
            case 4: {
                int found = CmndProc.scanArgs(scan, "", args);
                if (found < 0) break;
                this.showStrings(this.wtu.getHeaderRecord());
                break;
            }
            case 5: {
                int found = CmndProc.scanArgs(scan, "", args);
                if (found < 0) break;
                this.out.println("Record limit = " + this.wtu.getRecordLimit());
                break;
            }
            case 12: {
                int found = CmndProc.scanArgs(scan, "I", args);
                if (found < 0) break;
                this.wtu.setFullOption((Integer)args[0]);
                break;
            }
            case 6: {
                int found = CmndProc.scanArgs(scan, "", args);
                if (found < 0) break;
                this.out.println("Memory full option = " + this.wtu.getFullOption());
                break;
            }
            case 11: {
                int found = CmndProc.scanArgs(scan, "SI", args);
                if (found < 0) break;
                String type = (String)args[0];
                if (type.equalsIgnoreCase("i")) {
                    int intvl = this.wtu.setInternalLogging((Integer)args[1]);
                    this.out.println("Resulting interval = " + intvl);
                    break;
                }
                if (type.equalsIgnoreCase("e")) {
                    this.dataSumm = false;
                    this.wtu.setExternalLogging((Integer)args[1]);
                    break;
                }
                this.out.println("Invalid logging type");
                break;
            }
            case 14: {
                int found = CmndProc.scanArgs(scan, "I", args);
                if (found < 0) break;
                this.wtu.setLoggingInterval((Integer)args[0]);
                break;
            }
            case 7: {
                int found = CmndProc.scanArgs(scan, "", args);
                if (found < 0) break;
                this.out.println("Logging interval = " + this.wtu.getLoggingInterval() + ", logging state = " + this.wtu.getLoggingState());
                break;
            }
            case 15: {
                int found = CmndProc.scanArgs(scan, "FIi", args);
                if (found < 0) break;
                boolean euro = (found & 4) != 0 && (Integer)args[2] != 0;
                this.wtu.setUserParameters(((Float)args[0]).floatValue(), (Integer)args[1], euro);
                break;
            }
            case 8: {
                int found = CmndProc.scanArgs(scan, "", args);
                if (found < 0) break;
                this.out.format("Rate = %.3f, threshold = %s, euro = %s\n", Float.valueOf(this.wtu.getUserRate()), this.wtu.getUserThreshold(), this.wtu.getUserEuro());
                break;
            }
            case 9: {
                int found = CmndProc.scanArgs(scan, "", args);
                if (found < 0) break;
                this.showStrings(this.wtu.getVersionData());
                break;
            }
            case 13: {
                int found = CmndProc.scanArgs(scan, "", args);
                if (found < 0) break;
                this.wtu.resetMemory();
                break;
            }
            case 16: {
                int found = CmndProc.scanArgs(scan, "", args);
                if (found < 0) break;
                this.wtu.restart();
                break;
            }
            case 17: {
                int found = CmndProc.scanArgs(scan, "i", args);
                if (found < 0) break;
                this.dataSumm = (found & 1) != 0 && (Integer)args[0] != 0;
                this.dataCount = 0;
                int interval = this.wtu.getLoggedData();
                this.out.println("Record count = " + this.dataCount + ", logging interval = " + interval);
                this.dataSumm = false;
                break;
            }
            default: {
                this.out.println("Command not fully implemented");
            }
        }
        return true;
    }

    @Override
    public void process(float[] data) {
        ++this.dataCount;
        if (this.dataSumm) {
            if ((this.dataCount & 7) == 0) {
                byte[] flag = new byte[]{flags[this.dataCount >> 3 & 3], 8};
                this.out.write(flag, 0, 2);
            }
        } else {
            this.showFloats(data, this.fieldMask);
        }
    }

    private void showStrings(String[] value) {
        this.out.print("Values =");
        int posn = 8;
        int j = 0;
        while (j < value.length) {
            String sValue = " " + value[j];
            if ((posn += sValue.length()) > 80) {
                this.out.print("\n        ");
                posn = 8 + sValue.length();
            }
            this.out.print(sValue);
            ++j;
        }
        this.out.println();
    }

    private void showIntegers(int[] value) {
        this.out.print("Values =");
        int posn = 8;
        int j = 0;
        while (j < value.length) {
            String sValue = " " + value[j];
            if ((posn += sValue.length()) > 80) {
                this.out.print("\n        ");
                posn = 8 + sValue.length();
            }
            this.out.print(sValue);
            ++j;
        }
        this.out.println();
    }

    private void showFloats(float[] value, int mask) {
        this.out.print("Values =");
        int posn = 8;
        int j = 0;
        while (j < value.length) {
            if ((mask & 1 << j) != 0) {
                String sValue = " " + value[j];
                if ((posn += sValue.length()) > 80) {
                    this.out.print("\n        ");
                    posn = 8 + sValue.length();
                }
                this.out.print(sValue);
            }
            ++j;
        }
        this.out.println();
    }
}

