/*
 * Decompiled with CFR 0.152.
 */
package com.mcreations.usb.windows;

import com.ibm.jusb.UsbIrpImp;
import com.ibm.jusb.UsbPipeImp;
import com.ibm.jusb.os.DefaultUsbPipeOsImp;
import com.ibm.jusb.os.UsbPipeOsImp;
import com.mcreations.usb.windows.JavaxUsb;
import com.mcreations.usb.windows.WindowsInterfaceOsImp;
import java.util.LinkedList;
import java.util.List;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import net.sf.libusb.Libusb;
import net.sf.libusb.SWIGTYPE_p_usb_dev_handle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WindowsPipeOsImp
extends DefaultUsbPipeOsImp
implements UsbPipeOsImp {
    Log log = LogFactory.getLog(WindowsPipeOsImp.class);
    private UsbPipeImp usbPipeImp = null;
    private WindowsInterfaceOsImp windowsInterfaceOsImp = null;
    protected byte pipeType = 0;
    protected byte endpointAddress = 0;
    protected List inProgressList = new LinkedList();

    public WindowsPipeOsImp(UsbPipeImp pipe, WindowsInterfaceOsImp iface) {
        this.setUsbPipeImp(pipe);
        this.setWindowsInterfaceOsImp(iface);
    }

    public UsbPipeImp getUsbPipeImp() {
        return this.usbPipeImp;
    }

    public void setUsbPipeImp(UsbPipeImp pipe) {
        this.usbPipeImp = pipe;
    }

    public WindowsInterfaceOsImp getWindowsInterfaceOsImp() {
        return this.windowsInterfaceOsImp;
    }

    public void setWindowsInterfaceOsImp(WindowsInterfaceOsImp iface) {
        this.windowsInterfaceOsImp = iface;
    }

    protected byte getEndpointAddress() {
        if (this.endpointAddress == 0) {
            this.endpointAddress = this.usbPipeImp.getUsbEndpointImp().getUsbEndpointDescriptor().bEndpointAddress();
        }
        return this.endpointAddress;
    }

    protected byte getPipeType() {
        if (this.pipeType == 0) {
            this.pipeType = this.usbPipeImp.getUsbEndpointImp().getType();
        }
        return this.pipeType;
    }

    @Override
    public void open() throws UsbException {
    }

    @Override
    public void close() {
        this.log.debug((Object)"Closing Pipe");
    }

    private void submitIrp(UsbIrpImp irp, int timeout) throws UsbException {
        UsbEndpoint ep = this.getUsbPipeImp().getUsbEndpoint();
        SWIGTYPE_p_usb_dev_handle handle = this.getWindowsInterfaceOsImp().getWindowsDeviceOsImp().getHandle();
        byte epType = ep.getType();
        byte epDir = ep.getDirection();
        int result = 0;
        try {
            block1 : switch (epType) {
                case 2: {
                    if (epDir == 0) {
                        int chunkSize = 4096;
                        byte[] data = irp.getData();
                        int requested = data.length;
                        int written = 0;
                        while (written < requested) {
                            int toWrite = Math.min(requested - written, chunkSize);
                            byte[] buf = new byte[toWrite];
                            System.arraycopy(data, written, buf, 0, toWrite);
                            written += toWrite;
                            JavaxUsb.getMutex().acquire();
                            int res = Libusb.usb_bulk_write(handle, this.getEndpointAddress(), buf, timeout);
                            JavaxUsb.getMutex().release();
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Called bulk_write with buffer of size " + buf.length + ", res = " + res));
                            }
                            if (res == toWrite) continue;
                            result = res;
                            break block1;
                        }
                        break;
                    }
                    if (epDir != -128) break;
                    JavaxUsb.getMutex().acquire();
                    result = Libusb.usb_bulk_read(handle, this.getEndpointAddress(), irp.getData(), timeout);
                    JavaxUsb.getMutex().release();
                    break;
                }
                case 3: {
                    if (epDir == 0) {
                        JavaxUsb.getMutex().acquire();
                        result = Libusb.usb_interrupt_write(handle, this.getEndpointAddress(), irp.getData(), timeout);
                        JavaxUsb.getMutex().release();
                        break;
                    }
                    if (epDir != -128) break;
                    result = Libusb.usb_interrupt_read(handle, this.getEndpointAddress(), irp.getData(), timeout);
                    break;
                }
                default: {
                    throw new RuntimeException("WindowsPipeOsImp.submitIrp: end point (" + epType + ") type not (yet) supported!");
                }
            }
            JavaxUsb.isReturnCodeError(result);
            irp.setActualLength(result);
        }
        finally {
            JavaxUsb.getMutex().release();
            irp.complete();
        }
    }

    @Override
    public void asyncSubmit(UsbIrpImp irp) throws UsbException {
        this.submitIrp(irp, JavaxUsb.getIoTimeout());
    }

    @Override
    public void syncSubmit(UsbIrpImp irp) throws UsbException {
        this.submitIrp(irp, JavaxUsb.getIoTimeout());
    }
}

