/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.refrig.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.subsystems.refrig.data.RefrigChannel;
import org.lsst.ccs.subsystems.refrig.status.RefrigChannelLimitStatus;
import org.lsst.ccs.subsystems.refrig.status.RefrigTrendingStatus;
import org.lsst.ccs.subsystems.refrig.status.RefrigTrendingSummaryStatus;
import org.lsst.ccs.subsystems.refrig.ui.RefrigAssembly;
import org.lsst.ccs.subsystems.refrig.ui.RefrigGUISubsystem;
import org.lsst.ccs.subsystems.refrig.utils.RefrigUtils;

public class RefrigTrendingTable
extends JPanel
implements TableModelListener {
    static final String[] columnNames = new String[]{"Description", "Value", "Units", "Low Limit", "High Limit", "Name"};
    static final int DESCRIPTION_IND = 0;
    static final int VALUE_IND = 1;
    static final int UNITS_IND = 2;
    static final int LOW_LIMIT_IND = 3;
    static final int HIGH_LIMIT_IND = 4;
    static final int NAME_IND = 5;
    RefrigGUISubsystem refrigGui;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public RefrigTrendingTable(RefrigGUISubsystem refrigGui) {
        this.initComponents();
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jTable1.getModel().addTableModelListener(this);
        this.refrigGui = refrigGui;
    }

    RefrigGUISubsystem getRefrigGui() {
        return this.refrigGui;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setLayout(new BoxLayout(this, 2));
        this.jTable1.setModel(new TrendingTableModel());
        this.jScrollPane1.setViewportView(this.jTable1);
        this.add(this.jScrollPane1);
    }

    public void updateTableModel(RefrigTrendingSummaryStatus status) {
        SwingUtilities.invokeLater(new UpdateTrendingTableModel(status));
    }

    public void updateTableValue(RefrigTrendingStatus status) {
        SwingUtilities.invokeLater(new UpdateTrendingTable(status));
    }

    public void updateTableValue(RefrigChannelLimitStatus status) {
        SwingUtilities.invokeLater(new UpdateTrendingTableLimits(status));
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int column = e.getColumn();
        if (column == 3 || column == 4) {
            double actualValue;
            int row = e.getFirstRow();
            TrendingTableModel model = (TrendingTableModel)e.getSource();
            double insertedValue = (Double)model.getValueAt(row, column);
            double d = actualValue = column == 3 ? model.getLowLimit(row) : model.getHighLimit(row);
            if (insertedValue != actualValue) {
                this.refrigGui.submitLimit(row, insertedValue, column == 3);
                SwingUtilities.invokeLater(new UpdateLimitsButton(true));
            }
        }
    }

    public void resetTrendingTableModel() {
        SwingUtilities.invokeLater(new ResetTrendingTableModel());
    }

    public void configurationSaved() {
        SwingUtilities.invokeLater(new ConfigurationSaved());
    }

    class ConfigurationSaved
    implements Runnable {
        ConfigurationSaved() {
        }

        @Override
        public void run() {
            RefrigAssembly assembly = (RefrigAssembly)RefrigTrendingTable.this.getRefrigGui().getGuiLayout();
            assembly.getControlPanel().getLimitsButton().setEnabled(false);
            ((TrendingTableModel)RefrigTrendingTable.this.jTable1.getModel()).clearChangedLimits();
            RefrigTrendingTable.this.jTable1.repaint();
        }
    }

    class LimitsCellRenderer
    extends DefaultTableCellRenderer {
        LimitsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TrendingTableModel model = (TrendingTableModel)table.getModel();
            if ((column == 3 || column == 4) && model.hasLimitChanged(row, column)) {
                Font f = c.getFont();
                Font boldF = new Font(f.getName(), 1, f.getSize() + 2);
                c.setFont(boldF);
                c.setForeground(Color.blue);
            } else {
                c.setForeground(Color.black);
            }
            return c;
        }
    }

    class RefrigChangedLimit {
        boolean isLowLimit;
        int index;
        double value;

        RefrigChangedLimit(int index, double value, boolean isLowLimit) {
            this.index = index;
            this.value = value;
            this.isLowLimit = isLowLimit;
        }

        public int getIndex() {
            return this.index;
        }

        public boolean isLowLimit() {
            return this.isLowLimit;
        }

        public double getValue() {
            return this.value;
        }
    }

    class ResetTrendingTableModel
    implements Runnable {
        ResetTrendingTableModel() {
        }

        @Override
        public void run() {
            RefrigTrendingTable.this.jTable1.setModel(new TrendingTableModel());
        }
    }

    class TrendingTableCellRenderer
    extends DefaultTableCellRenderer {
        TrendingTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TrendingTableModel model = (TrendingTableModel)table.getModel();
            if (table.getModel().getColumnName(column).equals(columnNames[1])) {
                Color color = !model.getIsValueWithinLimits(row) ? Color.red : Color.green;
                c.setBackground(color);
            } else {
                c.setBackground(Color.white);
            }
            return c;
        }
    }

    class TrendingTableModel
    extends DefaultTableModel {
        ArrayList<Boolean> isValueWithinLimits;
        ArrayList<RefrigChannel> dataChannels;
        ArrayList<RefrigChangedLimit> changedLimits;
        Class[] types;
        boolean[] canEdit;

        public TrendingTableModel() {
            super(columnNames, 0);
            this.isValueWithinLimits = new ArrayList();
            this.dataChannels = new ArrayList();
            this.changedLimits = new ArrayList();
            this.types = new Class[]{String.class, TrendingValue.class, String.class, Double.class, Double.class, String.class};
            boolean[] blArray = new boolean[6];
            blArray[3] = true;
            blArray[4] = true;
            this.canEdit = blArray;
        }

        void addTrendingRow(RefrigChannel chan) {
            this.addRow(new Object[]{chan.getDescription(), new Float(chan.getValue()), chan.getUnits(), new Double(chan.getLowLimit()), new Double(chan.getHighLimit()), chan.getName()});
            this.dataChannels.add(chan);
        }

        public Class getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.canEdit[columnIndex];
        }

        public void setIsValueWithinLimits(int rowIndex, boolean isWithinLimits) {
            this.dataChannels.get(rowIndex).setIsWithinLimits(isWithinLimits);
        }

        public boolean getIsValueWithinLimits(int rowIndex) {
            return this.dataChannels.get(rowIndex).getIsWithinLimits();
        }

        public int getChannelBitNum(int rowIndex) {
            return this.dataChannels.get(rowIndex).getStateBit();
        }

        public void setLowLimit(int rowIndex, double value) {
            this.dataChannels.get(rowIndex).setLowLimit(value);
            this.setValueAt(value, rowIndex, 3);
            this.changedLimits.add(new RefrigChangedLimit(rowIndex, value, true));
        }

        public void setHighLimit(int rowIndex, double value) {
            this.dataChannels.get(rowIndex).setHighLimit(value);
            this.setValueAt(value, rowIndex, 4);
            this.changedLimits.add(new RefrigChangedLimit(rowIndex, value, false));
        }

        public double getLowLimit(int rowIndex) {
            return this.dataChannels.get(rowIndex).getLowLimit();
        }

        public double getHighLimit(int rowIndex) {
            return this.dataChannels.get(rowIndex).getHighLimit();
        }

        public void addChangedLimit(RefrigChangedLimit changedLimit) {
            this.changedLimits.add(changedLimit);
        }

        public List<RefrigChangedLimit> getChangedLimits() {
            return this.changedLimits;
        }

        public boolean hasLimitChanged(int row, int column) {
            for (RefrigChangedLimit limit : this.changedLimits) {
                if (limit.getIndex() != row || column == 3 != limit.isLowLimit()) continue;
                return true;
            }
            return false;
        }

        public void clearChangedLimits() {
            this.changedLimits.clear();
        }
    }

    class TrendingValue {
        TrendingValue() {
        }
    }

    class UpdateLimitsButton
    implements Runnable {
        boolean enabled;

        UpdateLimitsButton(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public void run() {
            RefrigAssembly assembly = (RefrigAssembly)RefrigTrendingTable.this.getRefrigGui().getGuiLayout();
            assembly.getControlPanel().getLimitsButton().setEnabled(this.enabled);
        }
    }

    class UpdateTrendingTable
    implements Runnable {
        RefrigTrendingStatus s;

        UpdateTrendingTable(RefrigTrendingStatus s) {
            this.s = s;
        }

        @Override
        public void run() {
            TrendingTableModel model = (TrendingTableModel)RefrigTrendingTable.this.jTable1.getModel();
            int i = 0;
            while (i < model.getRowCount()) {
                String channelName = (String)model.getValueAt(i, 5);
                for (ValueNotification vn : this.s.getListOfValues()) {
                    if (!vn.getName().equals(channelName)) continue;
                    model.setValueAt(vn.getData(), i, 1);
                    model.setIsValueWithinLimits(i, RefrigUtils.isChannelWithinLimits(model.getChannelBitNum(i), this.s.getRefrigState()));
                }
                ++i;
            }
        }
    }

    class UpdateTrendingTableLimits
    implements Runnable {
        RefrigChannelLimitStatus s;

        UpdateTrendingTableLimits(RefrigChannelLimitStatus s) {
            this.s = s;
        }

        @Override
        public void run() {
            TrendingTableModel model = (TrendingTableModel)RefrigTrendingTable.this.jTable1.getModel();
            if (this.s.getType() == 1) {
                model.setHighLimit(this.s.getIndex(), this.s.getValue());
            } else {
                model.setLowLimit(this.s.getIndex(), this.s.getValue());
            }
        }
    }

    class UpdateTrendingTableModel
    implements Runnable {
        RefrigTrendingSummaryStatus s;

        UpdateTrendingTableModel(RefrigTrendingSummaryStatus s) {
            this.s = s;
        }

        @Override
        public void run() {
            ArrayList<RefrigChannel> channelsArray = this.s.getChannelsArray();
            TrendingTableModel model = (TrendingTableModel)RefrigTrendingTable.this.jTable1.getModel();
            for (RefrigChannel chan : channelsArray) {
                model.addTrendingRow(chan);
            }
            RefrigTrendingTable.this.jTable1.setDefaultRenderer(TrendingValue.class, new TrendingTableCellRenderer());
            RefrigTrendingTable.this.jTable1.setDefaultRenderer(Double.class, new LimitsCellRenderer());
            RefrigTrendingTable.this.jTable1.setAutoResizeMode(3);
            int i = 0;
            while (i < RefrigTrendingTable.this.jTable1.getColumnCount()) {
                DefaultTableColumnModel colModel = (DefaultTableColumnModel)RefrigTrendingTable.this.jTable1.getColumnModel();
                TableColumn col = colModel.getColumn(i);
                TableCellRenderer renderer = col.getHeaderRenderer();
                if (renderer == null) {
                    renderer = RefrigTrendingTable.this.jTable1.getTableHeader().getDefaultRenderer();
                }
                Component headerComp = renderer.getTableCellRendererComponent(RefrigTrendingTable.this.jTable1, col.getHeaderValue(), false, false, 0, 0);
                int width = headerComp.getPreferredSize().width;
                int r = 0;
                while (r < RefrigTrendingTable.this.jTable1.getRowCount()) {
                    renderer = RefrigTrendingTable.this.jTable1.getCellRenderer(r, i);
                    Component comp = renderer.getTableCellRendererComponent(RefrigTrendingTable.this.jTable1, RefrigTrendingTable.this.jTable1.getValueAt(r, i), false, false, r, i);
                    width = Math.max(width, comp.getPreferredSize().width);
                    ++r;
                }
                col.setPreferredWidth(width + 4);
                ++i;
            }
        }
    }
}

