/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.refrig.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.refrig.status.RefrigTrendingStatus;
import org.lsst.ccs.subsystems.refrig.ui.RefrigGUISubsystem;

public class RefrigControlPanel
extends JPanel {
    final Font f = new Font("Tahoma", 1, 12);
    RefrigGUISubsystem refrigGui;
    private JButton limitsButton;
    private JButton loadTripButton;
    private JLabel loadTripLabel;
    private JLabel loadTripStatus;
    private JButton powerButton;
    private JLabel powerLabel;
    private JLabel powerStatus;

    public RefrigControlPanel(RefrigGUISubsystem refrigGui) {
        this.refrigGui = refrigGui;
        this.initComponents();
        this.powerStatus.setFont(this.f);
        this.loadTripStatus.setFont(this.f);
        ControlsActionListener buttonListener = new ControlsActionListener();
        this.loadTripButton.addActionListener(buttonListener);
        this.powerButton.addActionListener(buttonListener);
        this.limitsButton.addActionListener(buttonListener);
        this.limitsButton.setActionCommand("saveLimits");
    }

    private void initComponents() {
        this.powerLabel = new JLabel();
        this.powerButton = new JButton();
        this.loadTripLabel = new JLabel();
        this.loadTripButton = new JButton();
        this.limitsButton = new JButton();
        this.powerStatus = new JLabel();
        this.loadTripStatus = new JLabel();
        this.powerLabel.setFont(new Font("Tahoma", 1, 12));
        this.powerLabel.setText("Power:");
        this.powerButton.setText(".....");
        this.powerButton.setEnabled(false);
        this.loadTripLabel.setFont(new Font("Tahoma", 1, 12));
        this.loadTripLabel.setText("Load Trip:");
        this.loadTripButton.setText(".....");
        this.loadTripButton.setEnabled(false);
        this.loadTripButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RefrigControlPanel.this.loadTripButtonActionPerformed(evt);
            }
        });
        this.limitsButton.setText("Save Limits");
        this.limitsButton.setActionCommand("Save Limits");
        this.limitsButton.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.powerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.powerStatus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.powerButton).addGap(18, 18, 18).addComponent(this.loadTripLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadTripStatus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadTripButton).addGap(59, 59, 59).addComponent(this.limitsButton).addContainerGap(76, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.limitsButton).addComponent(this.loadTripButton).addComponent(this.loadTripLabel).addComponent(this.powerLabel).addComponent(this.powerButton).addComponent(this.powerStatus).addComponent(this.loadTripStatus)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void loadTripButtonActionPerformed(ActionEvent evt) {
    }

    public void updateControlPanel(RefrigTrendingStatus s) {
        SwingUtilities.invokeLater(new UpdateRefrigStatus(s));
    }

    JButton getLimitsButton() {
        return this.limitsButton;
    }

    class ControlsActionListener
    implements ActionListener {
        ControlsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("turnPowerOff".equals(e.getActionCommand())) {
                RefrigControlPanel.this.refrigGui.setPowerStatus(false);
                RefrigControlPanel.this.powerButton.setEnabled(false);
            } else if ("turnPowerOn".equals(e.getActionCommand())) {
                RefrigControlPanel.this.refrigGui.setPowerStatus(true);
                RefrigControlPanel.this.powerButton.setEnabled(false);
            } else if ("turnLoadTripOff".equals(e.getActionCommand())) {
                RefrigControlPanel.this.refrigGui.setLoadTripStatus(false);
                RefrigControlPanel.this.loadTripButton.setEnabled(false);
            } else if ("turnLoadTripOn".equals(e.getActionCommand())) {
                RefrigControlPanel.this.refrigGui.setLoadTripStatus(true);
                RefrigControlPanel.this.loadTripButton.setEnabled(false);
            } else if ("saveLimits".equals(e.getActionCommand())) {
                RefrigControlPanel.this.refrigGui.saveConfiguration();
                RefrigControlPanel.this.limitsButton.setEnabled(false);
            }
        }
    }

    class UpdateRefrigStatus
    implements Runnable {
        RefrigTrendingStatus s;

        UpdateRefrigStatus(RefrigTrendingStatus s) {
            this.s = s;
        }

        @Override
        public void run() {
            RefrigControlPanel.this.powerStatus.setText(this.s.isPowerEnabled() ? "ON" : "OFF");
            RefrigControlPanel.this.powerStatus.setForeground(this.s.isPowerEnabled() ? Color.green : Color.black);
            RefrigControlPanel.this.powerButton.setEnabled(true);
            RefrigControlPanel.this.powerButton.setText(this.s.isPowerEnabled() ? "Turn Power OFF" : "Turn Power ON");
            RefrigControlPanel.this.powerButton.setActionCommand(this.s.isPowerEnabled() ? "turnPowerOff" : "turnPowerOn");
            RefrigControlPanel.this.loadTripStatus.setText(this.s.isLoadTripEnabled() ? "ON" : "OFF");
            RefrigControlPanel.this.loadTripStatus.setForeground(this.s.isLoadTripEnabled() ? Color.green : Color.black);
            RefrigControlPanel.this.loadTripButton.setEnabled(true);
            RefrigControlPanel.this.loadTripButton.setText(this.s.isLoadTripEnabled() ? "Turn Load Trip OFF" : "Turn Load Trip ON");
            RefrigControlPanel.this.loadTripButton.setActionCommand(this.s.isLoadTripEnabled() ? "turnLoadTripOff" : "turnLoadTripOn");
        }
    }
}

