/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.refrig;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.refrig.data.RefrigChannel;
import org.lsst.ccs.subsystems.refrig.status.RefrigChannelLimitStatus;
import org.lsst.ccs.subsystems.refrig.status.RefrigConfigurationSavedStatus;
import org.lsst.ccs.subsystems.refrig.status.RefrigTrendingStatus;
import org.lsst.ccs.subsystems.refrig.status.RefrigTrendingSummaryStatus;
import org.lsst.ccs.subsystems.refrig.utils.RefrigUtils;

public abstract class RefrigTest
extends Module {
    static final int N_CHANS = 7;
    static final int CDT_CHAN_ID = 0;
    static final int CDP_CHAN_ID = 1;
    static final int C3T_CHAN_ID = 2;
    static final int C4T_CHAN_ID = 3;
    static final int HLT_CHAN_ID = 4;
    static final int CSP_CHAN_ID = 5;
    static final int HLP_CHAN_ID = 6;
    static final int N_STATE_BITS = 8;
    static final int CDT_STATE_BIT = 0;
    static final int CDP_STATE_BIT = 1;
    static final int C3T_STATE_BIT = 2;
    static final int C4T_STATE_BIT = 3;
    static final int HLT_STATE_BIT = 4;
    static final int CSP_STATE_BIT = 5;
    static final int LOAD_STATE_BIT = 6;
    static final int ENABLE_STATE_BIT = 7;
    static final int CHAN_TYPE_MCC = 0;
    static final int CHAN_TYPE_PWR = 1;
    static final int CDT_HW_CHAN = 0;
    static final int C3T_HW_CHAN = 1;
    static final int C4T_HW_CHAN = 2;
    static final int HLT_HW_CHAN = 3;
    static final int CDP_HW_CHAN = 6;
    static final int CSP_HW_CHAN = 7;
    static final String HI_LIMIT_CHK = "HiLimCheck";
    static final String LO_LIMIT_CHK = "LoLimCheck";
    static final String PROP_FILE = "refrigtest.properties";
    Properties config;
    Channel[] chanData = new Channel[7];
    int loLimCheck;
    int hiLimCheck;
    boolean enabled = false;
    boolean loadTrip = false;
    long powerTS;
    long mccTS = this.powerTS = System.currentTimeMillis();

    public RefrigTest() {
        this.chanData[0] = new Channel("CmpDisTmp", "Compressor discharge temperature", 0, true, 0, 0);
        this.chanData[1] = new Channel("CmpDisPrs", "Compressor discharge pressure", 0, false, 6, 1);
        this.chanData[2] = new Channel("C3LiqdTmp", "C3 liquid cap temperature", 0, true, 1, 2);
        this.chanData[3] = new Channel("PreC4Tmp", "Pre C4 evaporator temperature", 0, true, 2, 3);
        this.chanData[4] = new Channel("LoadTmp", "Heat load temperature", 0, true, 3, 4);
        this.chanData[5] = new Channel("CmpSucPrs", "Compressor suction pressure", 0, false, 7, 5);
        this.chanData[6] = new Channel("LoadPwr", "Heat load power", 1, false, 0, -1);
    }

    public void initModule() {
        this.initConfiguration();
        this.initSensors();
        this.configAlarms();
        this.setLoadLine();
    }

    public void tick() {
        this.readSensors();
        ArrayList<ValueNotification> trendingValues = new ArrayList<ValueNotification>();
        int j = 0;
        while (j < 7) {
            Channel chan = this.chanData[j];
            long ts = chan.type == 0 ? this.mccTS : this.powerTS;
            trendingValues.add(new ValueNotification(chan.name, (Object)Float.valueOf(chan.value), ts));
            ++j;
        }
        trendingValues.add(new ValueNotification("state", (Object)this.getState()));
        this.publishData(trendingValues);
        RefrigTrendingStatus refrigTrendingStatus = new RefrigTrendingStatus(this.isPowerEnable(), this.isLoadTripEnable(), this.getState(), trendingValues);
        this.sendToStatus(refrigTrendingStatus);
        this.setLoadLine();
    }

    public boolean isPowerEnable() {
        return this.enabled;
    }

    public void setPowerEnable(int value) {
        boolean enabled;
        boolean bl = enabled = value != 0;
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.setStateBit(7, enabled ? 1 : 0);
        }
    }

    public boolean isLoadTripEnable() {
        return this.loadTrip;
    }

    public void setLoadTripEnable(int value) {
        boolean loadTrip;
        boolean bl = loadTrip = value != 0;
        if (loadTrip != this.loadTrip) {
            this.loadTrip = loadTrip;
            this.setLoadLine();
        }
    }

    public int getLowLimitCheck() {
        return this.loLimCheck;
    }

    public int getHighLimitCheck() {
        return this.hiLimCheck;
    }

    public int getState() {
        return this.getStateWord();
    }

    public int getNumChans() {
        return 7;
    }

    public String getName(int id) {
        return this.chanData[id].name;
    }

    public String getDescription(int id) {
        return this.chanData[id].description;
    }

    public String getUnits(int id) {
        Channel chan = this.chanData[id];
        if (chan.type == 1) {
            return "Watts";
        }
        if (chan.isTemp) {
            return "C";
        }
        return "Psi";
    }

    public int getStateBitNum(int id) {
        return this.chanData[id].stateBitNum;
    }

    public int getPowerBitNum() {
        return 7;
    }

    public int getLoadBitNum() {
        return 6;
    }

    public float getLowLimit(int id) {
        return this.chanData[id].limitLo;
    }

    public void setLowLimit(int id, double limit) {
        Channel chan = this.chanData[id];
        chan.limitLo = (float)limit;
        this.config.setProperty(chan.limitLoName, Float.valueOf(chan.limitLo).toString());
        this.configAlarm(id);
        this.getSubsystem().publishMetaData(chan.name, "alarmLow", String.valueOf(limit));
        this.sendToStatus(new RefrigChannelLimitStatus(id, limit, 0));
    }

    public float getHighLimit(int id) {
        return this.chanData[id].limitHi;
    }

    public void setHighLimit(int id, double limit) {
        Channel chan = this.chanData[id];
        chan.limitHi = (float)limit;
        this.config.setProperty(chan.limitHiName, Float.valueOf(chan.limitHi).toString());
        this.configAlarm(id);
        this.getSubsystem().publishMetaData(chan.name, "alarmHigh", String.valueOf(limit));
        this.sendToStatus(new RefrigChannelLimitStatus(id, limit, 1));
    }

    public float getValue(int id) {
        return this.chanData[id].value;
    }

    public void saveConfiguration() {
        FileWriter writer = null;
        try {
            writer = new FileWriter(PROP_FILE);
        }
        catch (IOException e) {
            Module.log.info((Object)e);
        }
        if (writer != null) {
            try {
                this.config.store(writer, "Refrigeration long lines test configuration");
            }
            catch (IOException e) {
                Module.log.info((Object)e);
            }
            try {
                writer.close();
            }
            catch (IOException e) {
                Module.log.info((Object)e);
            }
        }
        this.sendToStatus(new RefrigConfigurationSavedStatus());
    }

    private void initConfiguration() {
        Properties dfltConfig = new Properties();
        int j = 0;
        while (j < 7) {
            Channel chan = this.chanData[j];
            dfltConfig.setProperty(chan.limitLoName, "0.0");
            dfltConfig.setProperty(chan.limitHiName, "0.0");
            ++j;
        }
        dfltConfig.setProperty(LO_LIMIT_CHK, "0");
        dfltConfig.setProperty(HI_LIMIT_CHK, "0");
        this.config = new Properties(dfltConfig);
        FileReader reader = null;
        try {
            reader = new FileReader(PROP_FILE);
        }
        catch (FileNotFoundException e) {
            Module.log.info((Object)e);
        }
        if (reader != null) {
            try {
                this.config.load(reader);
            }
            catch (IOException e) {
                Module.log.info((Object)e);
            }
            try {
                reader.close();
            }
            catch (IOException e) {
                Module.log.info((Object)e);
            }
        }
        this.loLimCheck = Integer.decode(this.config.getProperty(LO_LIMIT_CHK));
        this.hiLimCheck = Integer.decode(this.config.getProperty(HI_LIMIT_CHK));
        int j2 = 0;
        while (j2 < 7) {
            Channel chan = this.chanData[j2];
            chan.checkLo = (this.loLimCheck & 1 << j2) != 0;
            chan.checkHi = (this.hiLimCheck & 1 << j2) != 0;
            chan.limitLo = Float.valueOf(this.config.getProperty(chan.limitLoName)).floatValue();
            chan.limitHi = Float.valueOf(this.config.getProperty(chan.limitHiName)).floatValue();
            ++j2;
        }
    }

    private void configAlarms() {
        int j = 0;
        while (j < 7) {
            this.configAlarm(j);
            ++j;
        }
    }

    private void setLoadLine() {
        this.setStateBit(6, this.loadTrip ? this.getStateBit(this.chanData[4].stateBitNum) : 1);
    }

    public RefrigTrendingSummaryStatus publishTrendingSummary() {
        RefrigTrendingSummaryStatus status = new RefrigTrendingSummaryStatus();
        int i = 0;
        while (i < this.getNumChans()) {
            RefrigChannel chan = new RefrigChannel(this.getName(i), this.getDescription(i), this.getUnits(i));
            int channelStateBit = this.getStateBitNum(i);
            chan.setStateBit(channelStateBit);
            chan.setHighLimit(this.getHighLimit(i));
            chan.setLowLimit(this.getLowLimit(i));
            chan.setValue(this.getValue(i));
            chan.setIsWithinLimits(RefrigUtils.isChannelWithinLimits(channelStateBit, this.getState()));
            status.addRefrigChannel(chan);
            ++i;
        }
        RefrigTrendingStatus refrigStatus = new RefrigTrendingStatus(this.isPowerEnable(), this.isLoadTripEnable(), this.getState(), null);
        status.setRefrigStatus(refrigStatus);
        this.sendToStatus(status);
        return status;
    }

    abstract void initSensors();

    abstract void readSensors();

    abstract void configAlarm(int var1);

    abstract void setStateBit(int var1, int var2);

    abstract int getStateBit(int var1);

    abstract int getStateWord();

    static class Channel {
        String name;
        String description;
        int type;
        boolean isTemp;
        int hwChan;
        int stateBitNum;
        boolean checkLo;
        boolean checkHi;
        float limitLo;
        float limitHi;
        String limitLoName;
        String limitHiName;
        float value;

        public Channel(String name, String desc, int type, boolean isTemp, int hwChan, int bitNum) {
            this.name = name;
            this.description = desc;
            this.type = type;
            this.isTemp = isTemp;
            this.hwChan = hwChan;
            this.stateBitNum = bitNum;
            this.limitLoName = String.valueOf(name) + "LoLim";
            this.limitHiName = String.valueOf(name) + "HiLim";
        }
    }

    public static class RefrigException
    extends RuntimeException {
        public RefrigException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

