/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.IFitData;
import hep.aida.dev.IDevFitData;
import hep.aida.ext.IFitMethod;
import hep.aida.ext.IOptimizer;
import hep.aida.ext.IOptimizerFactory;
import hep.aida.ext.IVariableSettings;
import hep.aida.ref.fitter.fitdata.FitDataCreator;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.InternalObjectiveFunction;
import hep.aida.ref.pdf.Parameter;
import java.util.Collection;
import java.util.Iterator;
import org.freehep.util.FreeHEPLookup;
import org.openide.util.Lookup;

public class PdfFitter {
    private String engineType;
    private IOptimizer optimizer = null;
    private String fitMethodType;
    private IFitMethod fitMethod = null;
    private boolean useGradient = true;

    public PdfFitter(String fitMethodType, String engineType) throws IllegalArgumentException {
        this.setFitMethod(fitMethodType);
        this.setEngine(engineType);
    }

    public void setEngine(String engineType) throws IllegalArgumentException {
        if (engineType == null || engineType.length() == 0) {
            engineType = "uncmin";
        }
        String enType = engineType.toLowerCase();
        IOptimizerFactory tmpOptimizerFactory = null;
        Lookup.Template template = new Lookup.Template(IOptimizerFactory.class);
        Lookup.Result result = FreeHEPLookup.instance().lookup(template);
        Collection c = result.allInstances();
        Iterator i = c.iterator();
        block0: while (i.hasNext()) {
            IOptimizerFactory of = (IOptimizerFactory)i.next();
            String[] names = of.optimizerFactoryNames();
            if (names == null || names.length == 0) {
                throw new IllegalArgumentException("IOptimizerFactory with illegal names!");
            }
            for (int j = 0; j < names.length; ++j) {
                if (!enType.equals(names[j].toLowerCase())) continue;
                tmpOptimizerFactory = of;
                continue block0;
            }
        }
        if (tmpOptimizerFactory == null) {
            throw new IllegalArgumentException("Cannot create IOptimizer of type: " + engineType);
        }
        this.engineType = engineType;
        this.optimizer = tmpOptimizerFactory.create(engineType);
    }

    public String engineName() {
        return this.engineType;
    }

    public static IFitMethod getFitMethod(String fitMethodType) throws IllegalArgumentException {
        String fitMet = fitMethodType.toLowerCase();
        IFitMethod tmpFitMethod = null;
        Lookup.Template template = new Lookup.Template(IFitMethod.class);
        Lookup.Result result = FreeHEPLookup.instance().lookup(template);
        Collection c = result.allInstances();
        Iterator i = c.iterator();
        block0: while (i.hasNext()) {
            IFitMethod fm = (IFitMethod)i.next();
            String[] names = fm.fitMethodNames();
            if (names == null || names.length == 0) {
                throw new IllegalArgumentException("IFitMethod with illegal names!");
            }
            for (int j = 0; j < names.length; ++j) {
                if (!fitMet.equals(names[j].toLowerCase())) continue;
                tmpFitMethod = fm;
                continue block0;
            }
        }
        if (tmpFitMethod == null) {
            throw new IllegalArgumentException("Unknown IFitMethod type: " + fitMethodType);
        }
        return tmpFitMethod;
    }

    public void setFitMethod(String fitMethodType) throws IllegalArgumentException {
        if (fitMethodType == null || fitMethodType.length() == 0) {
            fitMethodType = "chi2";
        }
        this.fitMethodType = fitMethodType;
        this.fitMethod = PdfFitter.getFitMethod(fitMethodType);
    }

    public String fitMethodName() {
        return this.fitMethodType;
    }

    public void fit(Object[] objs, Function[] functions) {
        IFitData[] data = new IFitData[objs.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = FitDataCreator.create(objs[i]);
        }
        this.fit(data, functions);
    }

    public void fit(IFitData[] data, Function[] functions) {
        int i;
        int i2;
        int nData = data.length;
        if (nData != functions.length) {
            throw new IllegalArgumentException("Inconsistent number of data sets (" + nData + ") and functions (" + functions.length + ").");
        }
        int fitType = this.fitMethod.fitType();
        for (i2 = 0; i2 < nData; ++i2) {
            if (fitType != ((IDevFitData)data[i2]).fitType()) {
                throw new IllegalArgumentException("This FitData is incompatible with the selected fit method");
            }
            if (data[i2].dimension() == functions[i2].numberOfDependents()) continue;
            throw new IllegalArgumentException("Dimension mismatch!! Function's dimension " + functions[i2].numberOfDependents() + " FitData's dimension " + data[i2].dimension());
        }
        if (nData > 1) {
            for (i2 = 0; i2 < nData; ++i2) {
                functions[i2].getNormalizationParameter().setName("norm_" + i2);
            }
        }
        this.fitMethod.clear();
        this.optimizer.reset();
        this.setErrorDefinition();
        boolean normalizeFunction = fitType == 1;
        for (int i3 = 0; i3 < nData; ++i3) {
            functions[i3].normalize(normalizeFunction);
        }
        InternalObjectiveFunction objectiveFunction = new InternalObjectiveFunction(data, functions, this.fitMethod);
        for (i = 0; i < objectiveFunction.dimension(); ++i) {
            Parameter p = objectiveFunction.getVariable(i);
            IVariableSettings varSet = this.optimizer.variableSettings(p.name());
            varSet.setValue(p.value());
            varSet.setFixed(p.isFixed());
            double stepSize = p.stepSize();
            if (Double.isNaN(stepSize) && (stepSize = 0.1 * Math.abs(p.value())) < 1.0) {
                stepSize = 1.0;
            }
            varSet.setStepSize(stepSize);
            if (!p.useBounds()) continue;
            varSet.setBounds(p.lowerBound(), p.upperBound());
        }
        this.optimizer.setFunction(objectiveFunction);
        this.optimizer.configuration().setUseFunctionGradient(objectiveFunction.providesGradient() && this.useFunctionGradient());
        this.optimizer.configuration().setMaxIterations(500);
        this.optimizer.optimize();
        if (nData > 1) {
            for (i = 0; i < nData; ++i) {
                functions[i].getNormalizationParameter().setName("norm");
            }
        }
    }

    public void fit(Object obj, Function function) {
        IFitData data = FitDataCreator.create(obj);
        this.fit(data, function);
    }

    public void fit(IFitData data, Function function) {
        this.fit(new IFitData[]{data}, new Function[]{function});
    }

    public boolean useFunctionGradient() {
        return this.useGradient;
    }

    public void setUseFunctionGradient(boolean useGradient) {
        this.useGradient = useGradient;
    }

    private void setErrorDefinition() {
        if (this.fitMethod.fitType() == 0) {
            this.optimizer.configuration().setErrorDefinition(1);
        } else {
            this.optimizer.configuration().setErrorDefinition(2);
        }
    }
}

