/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.IBaseHistogram;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.Annotation;
import hep.aida.ref.ManagedObject;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractBaseHistogram
extends ManagedObject
implements IBaseHistogram {
    private int dimension;
    private IAnnotation annotation;
    static String[] styleKeys = new String[]{"xaxislabel", "xaxisscale", "xaxistype", "yaxislabel", "yaxisscale", "yaxistype"};

    protected int mapBinNumber(int index, IAxis axis) {
        int bins = axis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    public AbstractBaseHistogram(String name, String title, int dimension) {
        this(name, title, dimension, null);
    }

    public AbstractBaseHistogram(String name, String title, int dimension, String options) {
        super(name);
        this.dimension = dimension;
        this.annotation = new Annotation();
        this.annotation.addItem(Annotation.titleKey, title, true);
        this.setOptions(options);
    }

    private void setOptions(String options) {
        if (options == null || options.trim().equals("")) {
            return;
        }
        Map optionMap = AidaUtils.parseOptions(options);
        if (optionMap.isEmpty()) {
            return;
        }
        Iterator it = optionMap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.toLowerCase().startsWith("annotation.") && !key.toLowerCase().startsWith("annotation:")) continue;
            String annVal = (String)optionMap.get(key);
            String annKey = key.substring(11);
            if (annVal == null || annVal.trim().equals("") || annKey == null || annKey.trim().equals("")) continue;
            this.annotation.addItem(annKey, annVal, true);
        }
    }

    public String title() {
        String title = this.annotation.value(Annotation.titleKey);
        if (title == null) {
            title = "";
        }
        return title;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.annotation.setValue(Annotation.titleKey, title);
        if (this.isValid) {
            this.fireStateChanged();
        }
    }

    public IAnnotation annotation() {
        return this.annotation;
    }

    public void setAnnotation(IAnnotation annotation) {
        this.annotation = annotation;
    }

    public int dimension() {
        return this.dimension;
    }

    public void reset() {
    }

    public abstract int entries();

    public abstract int nanEntries();
}

