/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IAnnotation;
import hep.aida.IFunction;
import hep.aida.IModelFunction;
import hep.aida.IRangeSet;
import hep.aida.ref.Annotation;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.function.FunctionChangedEvent;
import hep.aida.ref.function.FunctionCore;
import hep.aida.ref.function.FunctionDispatcher;
import hep.aida.ref.function.FunctionIntegrator;
import hep.aida.ref.function.FunctionListener;
import hep.aida.ref.function.IFunctionCoreNotNorm;
import hep.aida.ref.function.RangeSet;
import java.util.ArrayList;

public class BaseModelFunction
extends ManagedObject
implements IModelFunction,
FunctionDispatcher {
    protected String[] varNames;
    protected IAnnotation annotation;
    protected String codeletString;
    protected String title;
    protected FunctionCore function;
    protected FunctionCore functionNotNormalized;
    protected FunctionCore functionNormalized;
    private boolean isNormalized;
    private boolean normalizationValid;
    private double normalizationAmplitude;
    private RangeSet[] rangeSet;
    private ArrayList listeners = new ArrayList();

    protected BaseModelFunction() {
        super(null);
    }

    public BaseModelFunction(String name, String tit, IFunction func) {
        super(name);
        IFunctionCoreNotNorm notNorm = new IFunctionCoreNotNorm(func);
        this.init(tit, notNorm, null);
        this.annotation = func.annotation();
        this.setCodeletString(func.codeletString());
        String[] funcVarNames = func.variableNames();
        for (int i = 0; i < this.function.dimension(); ++i) {
            this.varNames[i] = funcVarNames[i];
        }
    }

    public BaseModelFunction(String name, String title, FunctionCore notNorm, FunctionCore norm) {
        super(name);
        this.init(title, notNorm, norm);
    }

    protected void init(String tit, FunctionCore notNorm, FunctionCore norm) {
        if (notNorm == null && norm == null) {
            throw new IllegalArgumentException("Normalized and NotNormalized FunctionCores can not both be null");
        }
        this.annotation = new Annotation();
        this.annotation.addItem(Annotation.titleKey, "Title", true);
        if (tit != null) {
            this.setTitle(tit);
        }
        this.codeletString = this.title;
        this.functionNotNormalized = notNorm;
        this.functionNormalized = norm;
        if (notNorm != null) {
            this.isNormalized = false;
            this.function = this.functionNotNormalized;
            this.normalizationValid = true;
            this.normalizationAmplitude = 1.0;
        } else {
            this.isNormalized = true;
            this.function = this.functionNormalized;
            this.normalizationValid = false;
            this.normalizationAmplitude = 1.0;
        }
        this.rangeSet = new RangeSet[this.function.dimension()];
        this.varNames = new String[this.function.dimension()];
        for (int i = 0; i < this.function.dimension(); ++i) {
            this.varNames[i] = "x" + i;
            this.rangeSet[i] = new RangeSet();
        }
    }

    public FunctionCore core() {
        return this.function;
    }

    public int dimension() {
        return this.function.dimension();
    }

    public int numberOfParameters() {
        return this.function.numberOfParameters();
    }

    public double functionValue(double[] var) {
        return this.function.functionValue(var);
    }

    public final double value(double[] var) {
        if (!this.normalizationValid) {
            this.calculateNormalizationAmplitude();
        }
        double fVal = this.function.functionValue(var);
        double val = this.normalizationAmplitude * fVal;
        if (this.isNormalized && val < 0.0) {
            val = 0.0;
        }
        return val;
    }

    public IAnnotation annotation() {
        return this.annotation;
    }

    public String variableName(int i) {
        return this.varNames[i];
    }

    public String[] variableNames() {
        return this.varNames;
    }

    public String[] parameterNames() {
        return this.function.parameterNames();
    }

    public int indexOfParameter(String name) {
        return this.function.indexOfParameter(name);
    }

    public void setParameters(double[] params) {
        if (this.isNormalized) {
            this.normalizationValid = false;
        }
        this.function.setParameters(params);
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.PARAMETER_VALUE_CHANGED));
    }

    public void setParameter(String name, double x) throws IllegalArgumentException {
        if (this.isNormalized) {
            this.normalizationValid = false;
        }
        this.function.setParameter(name, x);
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.PARAMETER_VALUE_CHANGED));
    }

    public double[] parameters() {
        return this.function.parameters();
    }

    public double parameter(String name) {
        return this.function.parameter(name);
    }

    public boolean isEqual(IFunction f) {
        throw new UnsupportedOperationException("This method is not implemented yet");
    }

    public boolean providesGradient() {
        return this.function.providesGradient();
    }

    public double[] gradient(double[] x) {
        double[] val = new double[this.dimension()];
        if (this.function.providesGradient()) {
            if (!this.normalizationValid) {
                this.calculateNormalizationAmplitude();
            }
            val = this.function.gradient(x);
            for (int i = 0; i < val.length; ++i) {
                val[i] = this.normalizationAmplitude * val[i];
            }
        } else {
            throw new UnsupportedOperationException("This function does not provide gradient");
        }
        return val;
    }

    public String codeletString() {
        return this.codeletString;
    }

    public void setCodeletString(String codelet) {
        this.codeletString = codelet;
    }

    public String normalizationParameter() {
        throw new UnsupportedOperationException("This has not been implemented yet");
    }

    public boolean providesNormalization() {
        return this.function.providesNormalization();
    }

    public void normalize(boolean on) {
        boolean notify;
        boolean bl = notify = on != this.isNormalized;
        if (on) {
            if (this.functionNormalized == null) {
                throw new IllegalArgumentException("This function can not be converted into Normalized form!");
            }
            this.function = this.functionNormalized;
            this.isNormalized = true;
            this.normalizationValid = false;
            this.normalizationAmplitude = 1.0;
        } else {
            if (this.functionNotNormalized == null) {
                throw new IllegalArgumentException("This function can not be converted into Not-Normalized form!");
            }
            this.function = this.functionNotNormalized;
            this.isNormalized = false;
            this.normalizationValid = true;
            this.normalizationAmplitude = 1.0;
        }
        if (notify) {
            this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.RANGE_CHANGED));
        }
    }

    public boolean isNormalized() {
        return this.isNormalized;
    }

    public double[] parameterGradient(double[] x) {
        double[] val = new double[this.numberOfParameters()];
        if (this.function.providesParameterGradient()) {
            if (!this.normalizationValid) {
                this.calculateNormalizationAmplitude();
            }
            val = this.function.parameterGradient(x);
            for (int i = 0; i < val.length; ++i) {
                val[i] = this.normalizationAmplitude * val[i];
            }
        } else {
            throw new UnsupportedOperationException("This function does not provide parameter gradient");
        }
        return val;
    }

    public boolean providesParameterGradient() {
        return this.function.providesParameterGradient();
    }

    public IRangeSet normalizationRange(int iAxis) {
        return this.rangeSet[iAxis];
    }

    public void includeNormalizationAll() {
        if (this.isNormalized) {
            this.normalizationValid = false;
        }
        for (int i = 0; i < this.dimension(); ++i) {
            this.rangeSet[i].includeAll();
        }
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.RANGE_CHANGED));
    }

    public void excludeNormalizationAll() {
        if (this.isNormalized) {
            this.normalizationValid = false;
        }
        for (int i = 0; i < this.dimension(); ++i) {
            this.rangeSet[i].excludeAll();
        }
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.RANGE_CHANGED));
    }

    public double getNormalizationAmplitude() {
        return this.normalizationAmplitude;
    }

    public void calculateNormalizationAmplitude() {
        this.normalizationValid = true;
        double val = 0.0;
        this.normalizationAmplitude = 1.0;
        if (!this.function.providesNormalization()) {
            val = this.dimension() == 1 ? FunctionIntegrator.integralTrapezoid(this) : FunctionIntegrator.integralMC(this);
        } else if (this.dimension() == 1) {
            double[] xMax = this.rangeSet[0].upperBounds();
            double[] xMin = this.rangeSet[0].lowerBounds();
            for (int k = 0; k < this.rangeSet[0].size(); ++k) {
                val += this.function.normalizationAmplitude(xMin, xMax);
            }
        } else if (this.dimension() == 2) {
            double[] xMax = new double[2];
            double[] xMin = new double[2];
            double[] xMax0 = this.rangeSet[0].upperBounds();
            double[] xMin0 = this.rangeSet[0].lowerBounds();
            double[] xMax1 = this.rangeSet[1].upperBounds();
            double[] xMin1 = this.rangeSet[1].lowerBounds();
            for (int k = 0; k < this.rangeSet[0].size(); ++k) {
                xMin[0] = xMin0[k];
                xMax[0] = xMax0[k];
                for (int j = 0; j < this.rangeSet[1].size(); ++j) {
                    xMin[1] = xMin1[j];
                    xMax[1] = xMax1[j];
                    val += this.function.normalizationAmplitude(xMin, xMax);
                }
            }
        } else if (this.dimension() == 3) {
            double[] xMax = new double[3];
            double[] xMin = new double[3];
            double[] xMax0 = this.rangeSet[0].upperBounds();
            double[] xMin0 = this.rangeSet[0].lowerBounds();
            double[] xMax1 = this.rangeSet[1].upperBounds();
            double[] xMin1 = this.rangeSet[1].lowerBounds();
            double[] xMax2 = this.rangeSet[2].upperBounds();
            double[] xMin2 = this.rangeSet[2].lowerBounds();
            for (int k = 0; k < this.rangeSet[0].size(); ++k) {
                xMin[0] = xMin0[k];
                xMax[0] = xMax0[k];
                for (int j = 0; j < this.rangeSet[1].size(); ++j) {
                    xMin[1] = xMin0[j];
                    xMax[1] = xMax0[j];
                    val += this.function.normalizationAmplitude(xMin, xMax);
                    for (int i = 0; i < this.rangeSet[2].size(); ++i) {
                        xMin[2] = xMin0[i];
                        xMax[2] = xMax0[i];
                        val += this.function.normalizationAmplitude(xMin, xMax);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Temporary support only up to 3 dimensions");
        }
        this.normalizationAmplitude = 1.0 / val;
    }

    public String title() {
        String t = this.annotation != null ? this.annotation.value(Annotation.titleKey) : this.title;
        return t;
    }

    public void setTitle(String t) {
        this.title = t;
        if (this.annotation != null) {
            this.annotation.setValue(Annotation.titleKey, this.title);
        }
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.TITLE_CHANGED));
    }

    public boolean setParameterNames(String[] params) {
        boolean result = this.function.setParameterNames(params);
        this.notifyFunctionChanged(new FunctionChangedEvent(FunctionChangedEvent.PARAMETER_NAME_CHANGED));
        return result;
    }

    public double[] numericGradient(double[] x) {
        throw new UnsupportedOperationException("Numeric Gradient is not implemented yet");
    }

    public double[] numericParameterGradient(double[] x) {
        throw new UnsupportedOperationException("Numeric Parameter Gradient is not implemented yet");
    }

    public RangeSet[] getRangeSet() {
        return this.rangeSet;
    }

    public String toString() {
        String str = "BaseModelFunction:  Title=" + this.title() + ", name=" + this.name();
        str = str + "\n\tDimension: " + this.dimension() + ", number of parameters: " + this.numberOfParameters() + ", Codelet String: " + this.codeletString();
        str = str + "\n\tVariable Names: ";
        String[] varNames = this.variableNames();
        for (int i = 0; i < this.dimension(); ++i) {
            str = str + varNames[i] + ", ";
        }
        str = str + "\t Parameters: ";
        String[] parNames = this.parameterNames();
        double[] parValues = this.parameters();
        for (int i = 0; i < this.numberOfParameters(); ++i) {
            str = str + parNames[i] + "=" + parValues[i] + ", ";
        }
        str = str + "\n\tProvides Gradient: " + this.providesGradient();
        str = str + ",  Provides Parameter Gradient: " + this.providesParameterGradient();
        str = str + ",  Provides Normalization: " + this.providesNormalization();
        return str;
    }

    public void addFunctionListener(FunctionListener listener) {
        this.listeners.add(listener);
    }

    public void removeFunctionListener(FunctionListener listener) {
        this.listeners.remove(listener);
    }

    void notifyFunctionChanged(FunctionChangedEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((FunctionListener)this.listeners.get(i)).functionChanged(event);
        }
    }
}

