/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;
import org.freehep.application.Application;
import org.freehep.application.mdi.MDIApplication;
import org.freehep.application.mdi.ManagedPage;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.util.commanddispatcher.CommandTargetManager;

public abstract class PageManager {
    private String pageManagerType = null;
    private CommandProcessor commandProcessor;
    protected EventListenerList listenerList;
    private List pages = new ArrayList();
    private PageContext selected;

    public PageContext openPage(Component c, String title, Icon icon) {
        return this.openPage(c, title, icon, null);
    }

    public PageContext openPage(Component c, String title, Icon icon, String type) {
        PageContext context = new PageContext(c, title, icon, type);
        context.setPageManager(this);
        this.pages.add(context);
        return context;
    }

    protected void setActive(boolean active) {
    }

    protected void firePageOpened(PageContext context) {
        ManagedPage mp = this.getManagedPage(context.getPage());
        if (mp != null) {
            mp.setPageContext(context);
        }
        this.firePageEvent(context, 4004);
        this.getCommandProcessor().setChanged();
    }

    ManagedPage getManagedPage(Component c) {
        Component cc;
        if (c instanceof ManagedPage) {
            return (ManagedPage)((Object)c);
        }
        if (c instanceof JScrollPane && (cc = ((JScrollPane)c).getViewport().getView()) instanceof ManagedPage) {
            return (ManagedPage)((Object)cc);
        }
        return null;
    }

    public boolean closeAll() {
        return this.closeAll(null);
    }

    private boolean closeAll(String type) {
        for (PageContext tmpPage : new ArrayList(this.pages)) {
            if (type != null && !tmpPage.type().equals(type) || this.close(tmpPage)) continue;
            return false;
        }
        return true;
    }

    private boolean closeOther(PageContext page) {
        return this.closeOther(page, false);
    }

    private boolean closeOther(PageContext page, boolean byType) {
        for (PageContext tmpPage : new ArrayList(this.pages)) {
            if (tmpPage == page || byType && !tmpPage.type().equals(page.type()) || this.close(tmpPage)) continue;
            return false;
        }
        return true;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    private int getPageCount(String type) {
        if (type == null) {
            return this.getPageCount();
        }
        int count = 0;
        for (PageContext tmpPage : new ArrayList(this.pages)) {
            if (!tmpPage.type().equals(type)) continue;
            ++count;
        }
        return count;
    }

    public PageContext getSelectedPage() {
        return this.selected;
    }

    protected abstract void show(PageContext var1);

    protected boolean close(PageContext page) {
        ManagedPage mp = this.getManagedPage(page.getPage());
        if (mp != null && !mp.close()) {
            return false;
        }
        this.pages.remove(page);
        if (page == this.selected) {
            this.fireSelectionChanged(null);
        }
        if (mp != null) {
            mp.pageClosed();
        }
        this.firePageEvent(page, 4001);
        this.getCommandProcessor().setChanged();
        return true;
    }

    protected abstract void titleChanged(PageContext var1);

    protected abstract void iconChanged(PageContext var1);

    protected abstract Component getEmbodiment();

    protected CommandProcessor createCommandProcessor() {
        return new PageManagerCommandProcessor();
    }

    protected CommandProcessor getCommandProcessor() {
        if (this.commandProcessor == null) {
            this.commandProcessor = this.createCommandProcessor();
        }
        return this.commandProcessor;
    }

    public List pages() {
        return this.pages;
    }

    protected void init(List pages, PageContext selected) {
        this.pages = pages;
        this.selected = selected;
        for (PageContext page : pages) {
            page.setPageManager(this);
        }
    }

    protected void fireSelectionChanged(PageContext context) {
        if (this.selected != context) {
            ManagedPage mp;
            if (this.selected != null) {
                mp = this.getManagedPage(this.selected.getPage());
                if (mp != null) {
                    mp.pageDeselected();
                }
                this.firePageEvent(this.selected, 4000);
            }
            this.selected = context;
            if (context != null) {
                mp = this.getManagedPage(this.selected.getPage());
                if (mp != null) {
                    mp.pageSelected();
                }
                this.firePageEvent(this.selected, 3999);
            }
            this.getCommandProcessor().setChanged();
        }
    }

    protected void firePageEvent(PageContext context, int id) {
        PageEvent event = new PageEvent(context, id);
        if (this.listenerList != null) {
            PageListener[] listeners = (PageListener[])this.listenerList.getListeners(PageListener.class);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].pageChanged(event);
            }
        }
        context.firePageEvent(event, id);
    }

    public void addPageListener(PageListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(PageListener.class, listener);
    }

    public void removePageListener(PageListener listener) {
        this.listenerList.remove(PageListener.class, listener);
    }

    List getPageListenerList() {
        if (this.listenerList == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(this.listenerList.getListeners(PageListener.class));
    }

    void removeAllPageListeners() {
        this.listenerList = null;
    }

    protected JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        CommandTargetManager cm = Application.getApplication().getCommandTargetManager();
        ((MDIApplication)Application.getApplication()).setSelectedPageManager(this);
        String pageType = this.getSelectedPage() != null ? this.getSelectedPage().type() : null;
        boolean hasType = pageType != null;
        JComponent closeMenu = new JMenu("Close");
        if (menu.getComponentCount() > 0) {
            menu.addSeparator();
        } else {
            closeMenu = menu;
        }
        JMenuItem close = new JMenuItem(this.makeTitle("Close", false));
        close.setActionCommand("closePage");
        cm.add((CommandSource)new CommandSourceAdapter((AbstractButton)close));
        closeMenu.add(close);
        JMenuItem closeAll = new JMenuItem(this.makeTitle("Close All", true));
        closeAll.setActionCommand("closeAllPages");
        cm.add((CommandSource)new CommandSourceAdapter((AbstractButton)closeAll));
        closeMenu.add(closeAll);
        if (hasType) {
            JMenuItem closeAllByType = new JMenuItem(this.makeTitle("Close All " + pageType, true));
            closeAllByType.setActionCommand("closeAllPagesByType");
            cm.add((CommandSource)new CommandSourceAdapter((AbstractButton)closeAllByType));
            closeMenu.add(closeAllByType);
        }
        JMenuItem closeOther = new JMenuItem(this.makeTitle("Close Other", true));
        closeOther.setActionCommand("closeOtherPages");
        cm.add((CommandSource)new CommandSourceAdapter((AbstractButton)closeOther));
        closeMenu.add(closeOther);
        if (hasType) {
            JMenuItem closeOtherByType = new JMenuItem(this.makeTitle("Close Other " + pageType, true));
            closeOtherByType.setActionCommand("closeOtherPagesByType");
            cm.add((CommandSource)new CommandSourceAdapter((AbstractButton)closeOtherByType));
            closeMenu.add(closeOtherByType);
        }
        if (menu != closeMenu) {
            menu.add(closeMenu);
        }
        return menu;
    }

    private String makeTitle(String title, boolean plural) {
        if (this.pageManagerType() == null) {
            return title;
        }
        title = title + " " + this.pageManagerType();
        if (plural) {
            title = title + "s";
        }
        return title;
    }

    protected String pageManagerType() {
        return this.pageManagerType;
    }

    public void setPageManagerType(String type) {
        this.pageManagerType = type;
    }

    public class PageManagerCommandProcessor
    extends CommandProcessor {
        public void onCloseAllPages() {
            PageManager.this.closeAll();
        }

        public void enableCloseAllPages(CommandState state) {
            state.setEnabled(PageManager.this.getPageCount() > 1);
        }

        public void onClosePage() {
            PageManager.this.close(PageManager.this.getSelectedPage());
        }

        public void enableClosePage(CommandState state) {
            state.setEnabled(PageManager.this.getSelectedPage() != null);
        }

        public void onCloseOtherPages() {
            PageManager.this.closeOther(PageManager.this.getSelectedPage());
        }

        public void enableCloseOtherPages(CommandState state) {
            state.setEnabled(PageManager.this.getPageCount() > 1);
        }

        public void onCloseAllPagesByType() {
            PageManager.this.closeAll(PageManager.this.getSelectedPage().type());
        }

        public void enableCloseAllPagesByType(CommandState state) {
            state.setEnabled(PageManager.this.getPageCount(PageManager.this.getSelectedPage().type()) > 1);
        }

        public void onCloseOtherPagesByType() {
            PageManager.this.closeOther(PageManager.this.getSelectedPage(), true);
        }

        public void enableCloseOtherPagesByType(CommandState state) {
            state.setEnabled(PageManager.this.getPageCount(PageManager.this.getSelectedPage().type()) > 1);
        }
    }
}

