/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.state;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.Command;

public enum State {
    Offline{

        @Override
        public State nextState(Command arg0, Subsystem arg1) {
            return this;
        }
    }
    ,
    Ready{

        @Override
        public State nextState(Command arg0, Subsystem arg1) {
            return Active;
        }

        @Override
        public boolean canProcess(Command c, Subsystem sys) {
            return true;
        }
    }
    ,
    Active{

        @Override
        public boolean canProcess(Command c, Subsystem sys) {
            return sys.isMultithreaded() && c.canRunInActiveMode() || c.canWaitForReady();
        }
    }
    ,
    InError{}
    ,
    Recovering{};


    private State() {
    }

    public boolean canProcess(Command c, Subsystem sys) {
        return false;
    }

    public State nextState(Command c, Subsystem sys) {
        return this;
    }

    /* synthetic */ State(String string, int n, State state) {
        this();
    }
}

