/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;

public class TestJMS {
    Topic statusTopic;
    Topic commandTopic;
    Topic logTopic;

    public static void main(String[] args) throws Exception {
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
        props.setProperty("java.naming.factory.url.pkgs", "com.sun.enterprise.naming");
        props.setProperty("java.naming.factory.state", "com.sun.corba.ee.impl.presentation.rmi.JNDIStateFactoryImpl");
        props.setProperty("org.omg.CORBA.ORBInitialHost", "localhost");
        props.setProperty("org.omg.CORBA.ORBInitialPort", "3700");
        InitialContext context = new InitialContext(props);
        ConnectionFactory tcf = (ConnectionFactory)context.lookup("ConnectionFactory");
        Connection conn = tcf.createConnection();
        conn.start();
        Topic myTopic = (Topic)context.lookup("topic/control/status");
        Session session = conn.createSession(false, 1);
        MessageConsumer subscriber = session.createConsumer((Destination)myTopic);
        subscriber.setMessageListener(new MessageListener(){

            public void onMessage(Message msg) {
                try {
                    TextMessage txt = (TextMessage)msg;
                    System.out.println("Received message : " + txt.getText());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        MessageProducer producer = session.createProducer((Destination)myTopic);
        TextMessage transactionMessage = session.createTextMessage();
        transactionMessage.setText("This is a text message");
        producer.send((Message)transactionMessage);
        producer.close();
        session.close();
        conn.close();
        System.exit(0);
    }
}

