/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.framework.Context;
import org.lsst.ccs.framework.ModuleRegistry;
import org.lsst.ccs.state.State;
import org.springframework.beans.factory.annotation.Required;

public class Module
extends Observable
implements Observer,
Serializable {
    public static ModuleRegistry registry;
    private static final long serialVersionUID = 2086404413177085779L;
    protected static Logger log;
    protected String name;
    private List<Observable> observables = new ArrayList<Observable>();
    protected int tickMillis = -1;
    protected int nObserverThreads = 1;
    Context context;
    TimerTask timerTask;
    ExecutorService exec;
    Timer timer;

    static {
        log = Logger.getLogger((String)"lsst.ccs.framework");
    }

    public String getName() {
        return this.name;
    }

    @Required
    public void setName(String name) {
        this.name = name;
    }

    public void setObservables(List<Observable> l) {
        this.observables.addAll(l);
    }

    public void listens(Observable ... observs) {
        Observable[] observableArray = observs;
        int n = observs.length;
        int n2 = 0;
        while (n2 < n) {
            Observable observable = observableArray[n2];
            this.observables.add(observable);
            ++n2;
        }
    }

    public List<Observable> getObservables() {
        return this.observables;
    }

    public void setTickMillis(int tickMillis) {
        int old = this.tickMillis;
        this.tickMillis = tickMillis;
        if (this.timerTask != null && this.timer != null && tickMillis != old) {
            this.timerTask.cancel();
            if (tickMillis > 0) {
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        Module.this.tick();
                    }
                };
                this.timer.scheduleAtFixedRate(this.timerTask, tickMillis, (long)tickMillis);
            }
        }
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setNObserverThreads(int observerThreads) {
        this.nObserverThreads = observerThreads;
    }

    public int getNObserverThreads() {
        return this.nObserverThreads;
    }

    @PostConstruct
    public final void init() {
        this.initModule();
        for (Observable o : this.observables) {
            o.addObserver(this);
        }
        this.exec = Executors.newFixedThreadPool(this.nObserverThreads);
    }

    public void initModule() {
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Subsystem getSubsystem() {
        return this.getContext().getSubsystem();
    }

    public Module getModule(String moduleName) {
        if (registry != null) {
            return registry.getModule(moduleName);
        }
        return null;
    }

    public void start() {
        this.timer = new Timer("timer_" + this.name);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                Module.this.tick();
            }
        };
        if (this.tickMillis > 0) {
            this.timer.scheduleAtFixedRate(this.timerTask, this.tickMillis, (long)this.tickMillis);
        }
    }

    @Override
    public void update(final Observable o, final Object arg) {
        if (!(arg instanceof ValueUpdate)) {
            log.error((Object)("update called with arg not a ValueUpdate: " + arg));
            return;
        }
        this.exec.execute(new Runnable(){

            @Override
            public void run() {
                Module.this.processUpdate(o, (ValueUpdate)arg);
            }
        });
    }

    public void processUpdate(Observable source, ValueUpdate update) {
    }

    public void tick() {
    }

    public void setBeanName(String n) {
        this.name = n;
    }

    public void setStateModularSubsystem(State newState) {
        this.setStateModularSubsystem(newState, "");
    }

    public void setStateModularSubsystem(State newState, String extraInfo) {
        this.getSubsystem().updateState(newState, extraInfo);
    }

    public void publishData(String name, Object value, long tStamp) {
        this.getSubsystem().publishData(name, value, tStamp);
    }

    public void publishData(String name, Object value) {
        this.getSubsystem().publishData(name, value);
    }

    public void publishData(List<ValueNotification> tdl) {
        this.getSubsystem().publishData(tdl);
    }

    public void publishData(ValueNotification td) {
        this.getSubsystem().publishData(td);
    }

    public void sendToStatus(Status status) {
        this.getSubsystem().broadcastStatus(status);
    }

    @Deprecated
    public void sendToReply(CommandReply myReply) {
        this.getSubsystem().publishReply(myReply);
    }

    public void shutdownNow() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.exec != null) {
            this.exec.shutdownNow();
        }
    }

    public class ValueUpdate {
        String name;
        Object value;
        long timeStamp = System.currentTimeMillis();

        public ValueUpdate(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public ValueUpdate(String name, Object value, long tStamp) {
            this.name = name;
            this.value = value;
            this.timeStamp = tStamp;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }
    }
}

