/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.framework.Context;
import org.lsst.ccs.framework.FrameworkUtils;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.ModuleRegistry;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class ModularSubsystem
extends Subsystem
implements ModuleRegistry {
    protected static Logger log = Logger.getLogger((String)"lsst.ccs.framework");
    private ArrayList<Module> listModules = new ArrayList();
    GenericApplicationContext appCtx;
    String xmlConfigFile;

    public ModularSubsystem(String configFile) {
        this.initFromXML(configFile);
    }

    public String getXmlConfigFile() {
        return this.xmlConfigFile;
    }

    protected void initFromXML(String configFile) {
        log.info((Object)"*------------------------------- Start init");
        this.xmlConfigFile = configFile;
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            InputStream xsl2spring = this.getClass().getResourceAsStream("/org/lsst/ccs/framework/xsl/desc2spring.xsl");
            final Transformer transformer = tFactory.newTransformer(new StreamSource(xsl2spring));
            final PipedOutputStream pipeOut = new PipedOutputStream();
            PipedInputStream pipeIn = new PipedInputStream(pipeOut);
            InputStreamResource resource = new InputStreamResource((InputStream)pipeIn);
            this.appCtx = new GenericApplicationContext();
            Module.registry = new ModuleRegistry(){

                @Override
                public Module getModule(String moduleName) {
                    return (Module)ModularSubsystem.this.appCtx.getBean(moduleName);
                }
            };
            XmlBeanDefinitionReader rdr = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.appCtx);
            rdr.setValidationMode(3);
            new Thread(){

                @Override
                public void run() {
                    try {
                        StreamSource ss = new StreamSource(FrameworkUtils.getConfigFileInputStream(ModularSubsystem.this.xmlConfigFile));
                        transformer.transform(ss, new StreamResult(pipeOut));
                        pipeOut.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            log.info((Object)"*------------------------------ Start bean definitions");
            rdr.loadBeanDefinitions((Resource)resource);
            Context ctx = (Context)this.appCtx.getBean("context");
            this.setName(ctx.getSubsystemName());
            ctx.setSubsystem(this);
            log.info((Object)"Start bean instanciation");
            String[] stringArray = this.appCtx.getBeanDefinitionNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                log.info((Object)("instanciate bean " + s));
                this.appCtx.getBean(s);
                ++n2;
            }
            log.info((Object)"end modular subsystem creation");
        }
        catch (BeanDefinitionStoreException e) {
            log.error((Object)"error instanciating ModularSubsystem", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)"error instanciating ModularSubsystem", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            log.error((Object)"error instanciating ModularSubsystem", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            log.error((Object)"error instanciating ModularSubsystem", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void doStart() {
        String[] stringArray = this.appCtx.getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Object x = this.appCtx.getBean(s);
            if (x instanceof Module) {
                log.debug((Object)("starting module " + s));
                ((Module)x).setName(s);
                ((Module)x).start();
                this.listModules.add((Module)x);
            }
            ++n2;
        }
    }

    @Override
    public Module getModule(String name) {
        return (Module)this.appCtx.getBean(name);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        for (Module module : this.listModules) {
            module.shutdownNow();
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("MAIN SUBSYSTEM");
        ModularSubsystem sys = new ModularSubsystem(args[0]);
        sys.start();
        Thread.sleep(Long.MAX_VALUE);
    }
}

