/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.framework.Context;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.ModuleRegistry;

public class BasicModularSubSystem
extends Subsystem
implements ModuleRegistry {
    private Map<String, Module> moduleMap = new HashMap<String, Module>();
    private ModuleRegistry registry = new ModuleRegistry(){

        @Override
        public Module getModule(String moduleName) {
            return (Module)BasicModularSubSystem.this.moduleMap.get(moduleName);
        }
    };
    private Context context;
    protected static Logger log = Logger.getLogger((String)"lsst.ccs.framework");

    public BasicModularSubSystem(String name) {
        this.setName(name);
        Module.registry = this.registry;
        this.context = new Context();
        this.context.setSubsystem(this);
        this.context.setSubsystemName(name);
    }

    public void addModule(Module rawModule) {
        String key = rawModule.getName();
        if (key == null) {
            log.error((Object)("module " + rawModule + "with no name!"));
        } else {
            this.moduleMap.put(key, rawModule);
            rawModule.setContext(this.context);
            rawModule.init();
        }
    }

    protected void registerModule(Module rawModule) {
        String key = rawModule.getName();
        if (key == null) {
            log.error((Object)("module " + rawModule + "with no name!"));
        } else {
            this.moduleMap.put(key, rawModule);
        }
    }

    protected void rawInitModule(Module rawModule) {
        rawModule.setContext(this.context);
        rawModule.init();
    }

    public void addModules(Module ... list) {
        Module[] moduleArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Module module = moduleArray[n2];
            this.addModule(module);
            ++n2;
        }
    }

    @Override
    public void doStart() {
        for (Module module : this.moduleMap.values()) {
            module.start();
        }
    }

    @Override
    public Module getModule(String name) {
        return this.registry.getModule(name);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        for (Module module : this.moduleMap.values()) {
            module.shutdownNow();
        }
    }
}

