/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.MethodUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.ModuleRegistry;

public class ModuleInvokerCommand
extends Command {
    private static final long serialVersionUID = 968478338587037799L;
    String method;
    Object[] params;

    public ModuleInvokerCommand(String method, Object ... params) {
        this.method = method;
        this.params = params;
    }

    public String getMethod() {
        return this.method;
    }

    public Object[] getParams() {
        return this.params;
    }

    @Override
    public Object execute(Subsystem s) {
        Command.log.trace((Object)("executing command " + this));
        if (!(s instanceof ModuleRegistry)) {
            String err = "Subsystem " + s + " is not a ModularSubsystem, cannot execute " + this;
            Command.log.error((Object)err);
            throw new RuntimeException(err);
        }
        Module module = null;
        if (!this.destination.contains("/")) {
            module = ((ModuleRegistry)((Object)s)).getModule("main");
        } else {
            String moduleName = this.destination.substring(this.destination.indexOf("/") + 1);
            module = ((ModuleRegistry)((Object)s)).getModule(moduleName);
        }
        try {
            Command.log.trace((Object)("executing now " + this.method + " for Module " + module));
            return MethodUtils.invokeMethod((Object)module, this.method, this.params);
        }
        catch (NoSuchMethodException e) {
            Command.log.error((Object)e);
            RuntimeException ex = new RuntimeException("bad command " + this.method + " parameters or parameter types.", e);
            throw ex;
        }
        catch (IllegalAccessException e) {
            Command.log.error((Object)e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Command.log.error((Object)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }
}

