/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus;

import java.util.UUID;
import org.apache.log4j.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAckOrReply;
import org.lsst.ccs.bus.LogEvent;
import org.lsst.ccs.bus.Status;

public class MessagingApplicationLayer {
    Logger logger = Logger.getLogger((String)"org.lsst.ccs.core");
    ThreadLocal<String> localOrigin = new ThreadLocal();
    ThreadLocal<Command> localCommand = new ThreadLocal();
    String token = UUID.randomUUID().toString();
    volatile boolean replyRequested = true;

    public String getToken() {
        return this.token;
    }

    public boolean isReplyRequested() {
        return this.replyRequested;
    }

    public void noAutoReply() {
    }

    public Command commandForSending(Command cmd) {
        cmd.setKey(this.token);
        cmd.setOrigin(Subsystem.getCurrentSubsystemName());
        if (cmd.getCorrelId() == null) {
            cmd.setCorrelId(UUID.randomUUID().toString());
        }
        return cmd;
    }

    public CommandAckOrReply receivingReply(CommandAckOrReply reply) {
        String local = Subsystem.getCurrentSubsystemName();
        if (local == null) {
            this.logger.warn((Object)"TODO: modify subsystem name knowledge (BUG)");
            return reply;
        }
        Command command = reply.getOriginalCommand();
        if (command == null) {
            this.logger.warn((Object)"null command in reply");
            return reply;
        }
        if (local.equals(command.getOrigin())) {
            return reply;
        }
        this.logger.warn((Object)"!!!!!! LOST REPLY!");
        return reply;
    }

    public Command receivingCommand(Command command) {
        this.localOrigin.set(command.getOrigin());
        this.localCommand.set(command);
        return command;
    }

    public CommandAckOrReply replyForSending(CommandAckOrReply reply) {
        String destSystem = this.localOrigin.get();
        this.logger.info((Object)("REPLY destination:" + destSystem));
        reply.setOriginalCommand(this.localCommand.get());
        if (reply.getCorrelId() == null) {
            Command originalCommand = reply.getOriginalCommand();
            if (originalCommand != null) {
                reply.setCorrelId(reply.getOriginalCommand().getCorrelId());
            } else {
                reply.setCorrelId("no command correlation");
            }
        }
        reply.setOrigin(Subsystem.getCurrentSubsystemName());
        return reply;
    }

    public Status statusForSending(Status status) {
        return status;
    }

    public LogEvent logForSending(LogEvent log) {
        return log;
    }

    public Status receivingStatus(Status status) {
        return status;
    }

    public LogEvent receivingLog(LogEvent log) {
        return log;
    }
}

