/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.lsst.ccs.bus.Alarm;
import org.lsst.ccs.bus.AlarmClear;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandAckOrReply;
import org.lsst.ccs.bus.CommandListener;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.bus.locking.LockArbitrator;
import org.lsst.ccs.bus.locking.RegisterBusMasterCommand;
import org.lsst.ccs.state.State;

public class Subsystem
implements CommandListener,
StatusListener {
    protected volatile State state = State.Offline;
    protected String stateExtraInfo;
    int activeThreads = 0;
    volatile boolean shuttingDown = false;
    volatile int statusBroadcastPeriod = 5;
    protected static Logger log = Logger.getLogger((String)"lsst.ccs.subsystem");
    protected MessagingFactory fac = MessagingFactory.getInstance();
    static String revision = "$Rev: 25902 $";
    protected String commandBusSelector = null;
    protected String statusBusSelector = null;
    String name;
    boolean listeningToStatus = false;
    boolean multithreaded = true;
    protected volatile Thread statusBroadcasterThread = null;
    protected Object statusBroadcasterLock = new Object();
    protected Map<String, LockArbitrator.LockOwnerInfo> locks = new HashMap<String, LockArbitrator.LockOwnerInfo>();
    protected static ThreadLocal<Subsystem> currentSubsystem = new ThreadLocal();

    public static String getSoftwareRevision() {
        return revision;
    }

    public static String getEthHardAddress() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface itf = e.nextElement();
                if (!itf.isUp() || itf.isLoopback()) continue;
                byte[] z = itf.getHardwareAddress();
                return String.format("%02x:%02x:%02x:%02x:%02x:%02x", z[0], z[1], z[2], z[3], z[4], z[5]);
            }
        }
        catch (SocketException e1) {
            log.error((Object)"cannot get hardware address", (Throwable)e1);
        }
        return null;
    }

    public Logger getLogger() {
        return log;
    }

    public void setListenToStatus(boolean listenToStatus) {
        this.listeningToStatus = listenToStatus;
    }

    public boolean isListenToStatus() {
        return this.listeningToStatus;
    }

    public void setName(String name) {
        this.name = name;
        this.fac = MessagingFactory.getInstance().forSubsystem(name);
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultSelector() {
        return "destination = '" + this.name + "' OR destination = '*' or destination like '" + this.name + "/%'";
    }

    public String getStatusBusSelector() {
        return this.statusBusSelector == null ? this.getDefaultSelector() : this.statusBusSelector;
    }

    public void setStatusBusSelector(String selector) {
        this.statusBusSelector = selector;
    }

    public String getCommandBusSelector() {
        return this.commandBusSelector == null ? this.getDefaultSelector() : this.commandBusSelector;
    }

    public void setCommandBusSelector(String selector) {
        this.commandBusSelector = selector;
    }

    public void start() {
        log.info((Object)("Subsystem " + this.name + " starting with revision " + Subsystem.getSoftwareRevision()));
        log.info((Object)("running on MAC " + Subsystem.getEthHardAddress()));
        this.updateCurrentSubsystem();
        this.state = State.Ready;
        this.stateExtraInfo = "";
        this.doStart();
        this.fac.addCommandListener(this, this.getCommandBusSelector());
        if (this.listeningToStatus) {
            this.fac.addStatusListener(this, this.getStatusBusSelector());
        }
        this.startStatusBroadcasting();
        log.info((Object)("Subsystem " + this.name + " started"));
    }

    public void doStart() {
    }

    public Status getStatus() {
        Status s = new Status();
        return this.fillStatus(s);
    }

    protected synchronized Status fillStatus(Status s) {
        s.setOrigin(this.getName());
        s.setState(this.state);
        s.setSummary(this.stateExtraInfo);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusBroadcastPeriod(int statusBroadcastPeriod) {
        Object object = this.statusBroadcasterLock;
        synchronized (object) {
            this.statusBroadcastPeriod = statusBroadcastPeriod;
            if (this.state != State.Offline) {
                if (statusBroadcastPeriod == 0) {
                    this.stopStatusBroadcasting();
                } else {
                    this.startStatusBroadcasting();
                }
            }
        }
    }

    public int getStatusBroadcastPeriod() {
        return this.statusBroadcastPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stopStatusBroadcasting() {
        Object object = this.statusBroadcasterLock;
        synchronized (object) {
            while (true) {
                if (this.statusBroadcasterThread == null) {
                    return;
                }
                if (this.statusBroadcastPeriod > 0) {
                    this.statusBroadcastPeriod = -this.statusBroadcastPeriod;
                }
                if (this.statusBroadcasterThread != null) {
                    this.statusBroadcasterThread.interrupt();
                }
                try {
                    this.statusBroadcasterLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startStatusBroadcasting() {
        Object object = this.statusBroadcasterLock;
        synchronized (object) {
            if (this.statusBroadcastPeriod == 0) {
                return;
            }
            if (this.statusBroadcastPeriod < 0) {
                this.statusBroadcastPeriod = -this.statusBroadcastPeriod;
            }
            if (this.statusBroadcasterThread != null) {
                this.stopStatusBroadcasting();
            }
            StatusBroadcaster run = new StatusBroadcaster();
            this.statusBroadcasterThread = new Thread((Runnable)run, String.valueOf(this.getName()) + "-broadcast");
            this.statusBroadcasterThread.start();
        }
    }

    public void broadcastStatus() {
        this.updateCurrentSubsystem();
        Status s = this.getStatus();
        log.debug((Object)("sending status " + s));
        this.fac.sendStatus(s);
    }

    public void broadcastStatus(Status s) {
        this.updateCurrentSubsystem();
        s = this.fillStatus(s);
        log.debug((Object)("sending status " + s));
        this.fac.sendStatus(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        log.info((Object)("Subsystem " + this.name + " shutdown starting"));
        this.shuttingDown = true;
        this.stopStatusBroadcasting();
        Subsystem subsystem = this;
        synchronized (subsystem) {
            while (true) {
                if (this.state != State.Active) {
                    this.updateState(State.Offline);
                    break;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    log.warn((Object)"wait interrupted", (Throwable)e);
                }
            }
        }
        this.broadcastStatus();
        log.info((Object)("Subsystem " + this.name + " shutdown completed"));
        this.fac.shutdownBusAccess();
    }

    public synchronized State updateState(State newState, String extraInfo) {
        this.stateExtraInfo = extraInfo;
        State oldState = this.state;
        this.state = newState;
        if (oldState != newState) {
            if (newState == State.InError) {
                this.broadcastAlarm();
            } else {
                this.broadcastStatus();
            }
        }
        return oldState;
    }

    public State updateState(State newState) {
        return this.updateState(newState, "");
    }

    public boolean isMultithreaded() {
        return this.multithreaded;
    }

    public synchronized void setMultithreaded(boolean multithreaded) {
        this.multithreaded = multithreaded;
    }

    public static String getCurrentSubsystemName() {
        Subsystem sys = currentSubsystem.get();
        if (sys == null) {
            return null;
        }
        return sys.getName();
    }

    protected void updateCurrentSubsystem() {
        currentSubsystem.set(this);
    }

    public void addLock(String target, LockArbitrator.LockOwnerInfo info) {
        log.info((Object)("lock requested by " + info.ownerSubsystem));
        LockArbitrator.LockOwnerInfo old = this.locks.put(target, info);
        if (old != null) {
            log.warn((Object)("lock on " + target + "(" + info.ownerSubsystem + ") was alread held by " + old.ownerSubsystem + " overriden by " + info.ownerSubsystem));
        }
    }

    public void removeLock(String target) {
        LockArbitrator.LockOwnerInfo old = this.locks.remove(target);
        if (old == null) {
            log.warn((Object)("removal of nonexistent lock on " + target));
        } else {
            log.debug((Object)("lock on " + target + "(" + old.ownerSubsystem + ") held by token " + old.token + " removed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCommand(Command cmd) {
        block39: {
            Object reply;
            log.debug((Object)("subsytem got command " + cmd));
            Object result = null;
            CommandReply.CommandStatus status = CommandReply.CommandStatus.OK;
            if (this.shuttingDown) {
                log.warn((Object)"Command rejected, shutting down");
                status = CommandReply.CommandStatus.ERROR;
            }
            if (status == CommandReply.CommandStatus.OK) {
                Subsystem subsystem = this;
                synchronized (subsystem) {
                    if (cmd.isWrite()) {
                        String sys = cmd.getDestination();
                        while (sys != null) {
                            LockArbitrator.LockOwnerInfo lockInfo = this.locks.get(sys);
                            if (lockInfo != null && !lockInfo.token.equals(cmd.getKey())) {
                                log.warn((Object)("Command rejected, invalid lock key " + cmd.getKey() + " subsystem " + sys + " locked by " + lockInfo.ownerSubsystem));
                                status = CommandReply.CommandStatus.INVALID_LOCK;
                            }
                            if (sys.contains("/")) {
                                if (lockInfo == null) {
                                    sys = sys.substring(0, sys.lastIndexOf(47));
                                    continue;
                                }
                                log.warn((Object)("Command rejected, no lock, no access to subsystem " + sys));
                                status = CommandReply.CommandStatus.INVALID_LOCK;
                                continue;
                            }
                            sys = null;
                        }
                    }
                    if (!this.state.canProcess(cmd, this)) {
                        log.warn((Object)("Command rejected, invalid state" + (Object)((Object)this.state)));
                        status = CommandReply.CommandStatus.ERROR;
                    }
                    this.updateCurrentSubsystem();
                    if (status == CommandReply.CommandStatus.OK) {
                        while (this.state == State.Active && !cmd.canRunInActiveMode()) {
                            try {
                                log.warn((Object)"command not in active mode");
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                log.warn((Object)"wait interrupted", (Throwable)e);
                            }
                        }
                    }
                    this.updateState(State.Active, cmd.getCorrelId());
                    ++this.activeThreads;
                }
            }
            try {
                try {
                    if (status == CommandReply.CommandStatus.OK) {
                        CommandAck ack = new CommandAck(cmd);
                        this.fac.reply(ack);
                        result = this.multithreaded ? cmd.execute(this) : this.executeCommandSingleThread(cmd);
                    }
                }
                catch (Exception e) {
                    log.debug((Object)e);
                    status = CommandReply.CommandStatus.ERROR;
                    result = e;
                    if (this.fac.isReplyRequested()) {
                        reply = new CommandReply(cmd, result, status);
                        log.trace((Object)("  reply will be sent  " + reply));
                        this.fac.reply((CommandAckOrReply)reply);
                    } else {
                        log.trace((Object)(" no reply will be sent for " + cmd));
                    }
                    reply = this;
                    synchronized (reply) {
                        --this.activeThreads;
                        if (this.activeThreads == 0 && this.state == State.Active) {
                            this.updateState(State.Ready);
                        }
                        this.notify();
                        break block39;
                    }
                }
            }
            catch (Throwable throwable) {
                if (this.fac.isReplyRequested()) {
                    reply = new CommandReply(cmd, result, status);
                    log.trace((Object)("  reply will be sent  " + reply));
                    this.fac.reply((CommandAckOrReply)reply);
                } else {
                    log.trace((Object)(" no reply will be sent for " + cmd));
                }
                reply = this;
                synchronized (reply) {
                    --this.activeThreads;
                    if (this.activeThreads == 0 && this.state == State.Active) {
                        this.updateState(State.Ready);
                    }
                    this.notify();
                }
                throw throwable;
            }
            if (this.fac.isReplyRequested()) {
                reply = new CommandReply(cmd, result, status);
                log.trace((Object)("  reply will be sent  " + reply));
                this.fac.reply((CommandAckOrReply)reply);
            } else {
                log.trace((Object)(" no reply will be sent for " + cmd));
            }
            Subsystem subsystem = this;
            synchronized (subsystem) {
                --this.activeThreads;
                if (this.activeThreads == 0 && this.state == State.Active) {
                    this.updateState(State.Ready);
                }
                this.notify();
            }
        }
    }

    protected synchronized Object executeCommandSingleThread(Command cmd) {
        return cmd.execute(this);
    }

    @Override
    public void onStatus(BusMessage s) {
    }

    @Override
    public void onReply(CommandReply r) {
    }

    @Override
    public void onAck(CommandAck a) {
    }

    public void registerAsBusMaster() {
        RegisterBusMasterCommand cmd = new RegisterBusMasterCommand();
        MessagingFactory mfac = MessagingFactory.getInstance().forSubsystem(this.getName());
        mfac.sendCommand(cmd);
    }

    public void publishData(String name, Object value, long tStamp) {
        ValueNotification td = new ValueNotification(name, value, tStamp);
        this.publishData(td);
    }

    public void publishData(String name, Object value) {
        ValueNotification td = new ValueNotification(name, value);
        this.publishData(td);
    }

    public void publishData(List<ValueNotification> tdl) {
        TrendingStatus ts = new TrendingStatus(tdl);
        this.publishTrendingStatus(ts);
    }

    public void publishData(ValueNotification td) {
        TrendingStatus ts = new TrendingStatus(td);
        this.publishTrendingStatus(ts);
    }

    protected void publishTrendingStatus(TrendingStatus ts) {
        ts = (TrendingStatus)this.fillStatus(ts);
        this.updateCurrentSubsystem();
        this.fac.sendStatus(ts);
    }

    public void publishMetaData(String dataname, String metadataname, String value) {
        MetadataStatus mst = new MetadataStatus(dataname, metadataname, value);
        this.updateCurrentSubsystem();
        this.fac.sendStatus(mst);
    }

    public void broadcastAlarm() {
        this.broadcastAlarm(null);
    }

    public void broadcastAlarm(String message) {
        Alarm alrm = new Alarm();
        alrm = (Alarm)this.fillStatus(alrm);
        alrm.setSummary(message);
        this.updateCurrentSubsystem();
        this.fac.sendStatus(alrm);
    }

    public void broadcastAlarmClear(String message) {
        AlarmClear alrm = new AlarmClear();
        alrm.setSummary(message);
        this.updateCurrentSubsystem();
        this.fac.sendStatus(alrm);
    }

    @Deprecated
    public void publishReply(CommandReply myReply) {
        this.fac.reply(myReply);
    }

    protected class StatusBroadcaster
    implements Runnable {
        protected StatusBroadcaster() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                Subsystem.this.updateCurrentSubsystem();
                while (true) {
                    Subsystem.this.broadcastStatus();
                    try {
                        Thread.sleep(1000L * (long)Subsystem.this.statusBroadcastPeriod);
                    }
                    catch (InterruptedException interruptedException) {}
                    Object object = Subsystem.this.statusBroadcasterLock;
                    // MONITORENTER : object
                    if (Subsystem.this.statusBroadcastPeriod > 0) break block16;
                    Subsystem.this.statusBroadcasterThread = null;
                    Subsystem.this.statusBroadcasterLock.notifyAll();
                    // MONITOREXIT : object
                    Object object2 = Subsystem.this.statusBroadcasterLock;
                    break;
                }
                {
                    catch (Throwable throwable) {
                        // MONITOREXIT : object
                        throw throwable;
                    }
                }
                {
                    block16: {
                        // MONITORENTER : object2
                        Subsystem.this.statusBroadcasterThread = null;
                        Subsystem.this.statusBroadcasterLock.notifyAll();
                        // MONITOREXIT : object2
                        return;
                    }
                    // MONITOREXIT : object
                    continue;
                }
            }
            catch (Throwable throwable) {
                Object object = Subsystem.this.statusBroadcasterLock;
                // MONITORENTER : object
                Subsystem.this.statusBroadcasterThread = null;
                Subsystem.this.statusBroadcasterLock.notifyAll();
                // MONITOREXIT : object
                throw throwable;
            }
        }
    }
}

