/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.xml.converters;

import de.schlichtherle.io.FileOutputStream;
import hep.aida.ref.xml.ascii.AidaAsciiXMLWriter;
import hep.aida.ref.xml.binary.AidaWBXML;
import hep.aida.ref.xml.binary.AidaWBXMLLookup;
import hep.aida.ref.xml.converters.EndTag;
import hep.aida.ref.xml.converters.Tag;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.freehep.wbxml.Attributes;
import org.freehep.wbxml.WBXMLTagWriter;
import org.freehep.wbxml.WBXMLWriter;
import org.xml.sax.SAXException;

public class ToZipHandler {
    protected de.schlichtherle.io.File zip;
    protected String dtdName;
    protected String dtdSystemId;
    protected WBXMLTagWriter writer;
    protected boolean binary;
    protected int writerID;
    protected List prefixes;
    protected int closeTags;

    protected ToZipHandler() {
    }

    protected void convert(String out, boolean binary) {
        this.zip = new de.schlichtherle.io.File(out);
        this.binary = binary;
        this.prefixes = new ArrayList();
        this.closeTags = 0;
    }

    public void characters(char[] chars, int start, int len) throws SAXException {
        try {
            String content = new String(chars);
            this.writer.print(content.substring(start, start + len));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(int tagID) throws SAXException {
        if (this.writer == null) {
            this.prefixes.add(new EndTag(tagID));
            --this.closeTags;
            return;
        }
        try {
            this.writer.closeTag();
            if (tagID == this.writerID) {
                for (int i = 0; i < this.closeTags; ++i) {
                    this.writer.closeTag();
                }
                this.writer.closeDoc();
                this.writer.close();
                this.writer = null;
                this.writerID = -1;
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(int tag, Attributes attr, boolean empty) throws SAXException {
        try {
            if (this.writer == null) {
                String path = attr.getStringValue(16, null);
                String name = attr.getStringValue(14, null);
                if (path == null || name == null) {
                    this.prefixes.add(new Tag(tag, attr, empty));
                    if (!empty) {
                        ++this.closeTags;
                    }
                    return;
                }
                de.schlichtherle.io.File dir = new de.schlichtherle.io.File((File)this.zip, path);
                dir.mkdirs();
                this.writer = this.binary ? new WBXMLWriter((OutputStream)new FileOutputStream((File)new de.schlichtherle.io.File((File)dir, this.escape(name))), AidaWBXML.attributes.length - 1) : new AidaAsciiXMLWriter(new BufferedWriter(new FileWriter((File)new de.schlichtherle.io.File((File)dir, this.escape(name)))));
                System.err.println(new de.schlichtherle.io.File((File)dir, this.escape(name)));
                this.writerID = tag;
                this.writer.openDoc();
                this.writer.referToDTD(this.dtdName, this.dtdSystemId);
                Iterator i = this.prefixes.iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    if (o instanceof EndTag) {
                        this.endElement(-2);
                        continue;
                    }
                    Tag t = (Tag)o;
                    this.startElement(t.getTagID(), t.getAttributes(), t.isEmpty());
                }
            }
            int[] atts = attr.getTags();
            block14: for (int i = 0; i < atts.length; ++i) {
                int att = atts[i];
                int type = attr.getType(att);
                switch (type) {
                    case 0: {
                        boolean value = attr.getBooleanValue(att);
                        this.writer.setAttribute(att, value);
                        continue block14;
                    }
                    case 1: {
                        byte value = attr.getByteValue(att);
                        this.writer.setAttribute(att, value);
                        continue block14;
                    }
                    case 2: {
                        char value = attr.getCharValue(att);
                        this.writer.setAttribute(att, value);
                        continue block14;
                    }
                    case 3: {
                        double value = attr.getDoubleValue(att);
                        this.writer.setAttribute(att, value);
                        continue block14;
                    }
                    case 4: {
                        float value = attr.getFloatValue(att);
                        this.writer.setAttribute(att, value);
                        continue block14;
                    }
                    case 5: {
                        int value = attr.getIntValue(att);
                        this.writer.setAttribute(att, value);
                        continue block14;
                    }
                    case 6: {
                        long value = attr.getLongValue(att);
                        this.writer.setAttribute(att, value);
                        continue block14;
                    }
                    case 7: {
                        short value = attr.getShortValue(att);
                        this.writer.setAttribute(att, value);
                        continue block14;
                    }
                    case 8: {
                        String value = attr.getStringValue(att);
                        this.writer.setAttribute(att, value);
                        continue block14;
                    }
                    default: {
                        throw new SAXException("Type '" + type + "' not handled for attribute '" + AidaWBXMLLookup.getAttributeName(att) + "' in tag '" + AidaWBXMLLookup.getTagName(tag) + "'");
                    }
                }
            }
            if (empty) {
                this.writer.printTag(tag);
            } else {
                this.writer.openTag(tag);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    protected String escape(String name) {
        StringBuffer s = new StringBuffer();
        block4: for (int i = 0; i < name.length(); ++i) {
            switch (name.charAt(i)) {
                case '/': {
                    s.append("&47;");
                    continue block4;
                }
                case '\\': {
                    s.append("&92;");
                    continue block4;
                }
                default: {
                    s.append(name.charAt(i));
                }
            }
        }
        return s.toString();
    }

    protected String unescape(String name) {
        StringBuffer s = new StringBuffer();
        block3: for (int i = 0; i < name.length(); ++i) {
            switch (name.charAt(i)) {
                case '&': {
                    if (i + 3 < name.length()) {
                        String entity = name.substring(i + 1, 3);
                        if (entity.equals("47;")) {
                            s.append('/');
                            i += 3;
                            continue block3;
                        }
                        if (entity.equals("92;")) {
                            s.append('\\');
                            i += 3;
                            continue block3;
                        }
                        s.append("&");
                        continue block3;
                    }
                    s.append('&');
                    continue block3;
                }
                default: {
                    s.append(name.charAt(i));
                }
            }
        }
        return s.toString();
    }
}

