/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.freehep.application.ProgressMeter;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeNodeAdapter;
import org.freehep.jas.plugin.tree.FTreeNodeAddedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeRemovedNotification;
import org.freehep.jas.plugin.tree.FTreeNotification;
import org.freehep.jas.plugin.tree.FTreeProvider;
import org.freehep.jas.services.ProgressMeterProvider;
import org.freehep.util.FreeHEPLookup;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.lsst.ccs.bus.jms.TopicSessionFactory;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.plugin.jas3.LsstSubsystemPlugin;
import org.lsst.ccs.plugin.jas3.adapters.DataChannelTreeAdapter;
import org.lsst.ccs.plugin.jas3.preferences.JmsPreferences;
import org.lsst.ccs.plugin.jas3.preferences.RestPreferences;
import org.lsst.ccs.plugin.jas3.preferences.ServersPreferencesTopic;
import org.lsst.ccs.plugin.jas3.preferences.TimeSelectionPreferencesTopic;
import org.lsst.ccs.plugin.jas3.timeselection.TimeSelection;
import org.lsst.ccs.plugin.jas3.timeselection.TimeSelectionComboBoxModel;
import org.openide.util.Lookup;
import org.xml.sax.SAXException;

public class LsstPlugin
extends Plugin {
    private static final Logger logger = Logger.getLogger(LsstPlugin.class.getName());
    private FTree tree;
    private static Studio studio;
    ClientConfig config = new DefaultClientConfig();
    Client client = Client.create((ClientConfig)this.config);
    WebResource service;
    private ProgressMeterProvider progressMeterProvider;
    private ProgressMeter progressMeter;
    private String defaultTracerName = "LSST Tracer";
    private String defaultConsoleName = "LSST Console";
    private ServersPreferencesTopic serversPreferencesTopic = null;
    private TimeSelectionPreferencesTopic timeSelectionPreferencesTopic = null;
    private TimeSelectionComboBoxModel comboBoxModel;

    protected void init() throws SAXException, IOException {
        logger.finest("LSST plugin created");
        studio = (Studio)Studio.getApplication();
        FreeHEPLookup lookup = studio.getLookup();
        lookup.add((Object)this);
        JmsPreferences jmsPrefs = new JmsPreferences();
        this.setBusesSystemProperties(jmsPrefs);
        FTreeProvider treeProvider = (FTreeProvider)lookup.lookup(FTreeProvider.class);
        if (treeProvider != null) {
            treeProvider.treeNodeAdapterRegistry().registerNodeAdapter((FTreeNodeAdapter)new DataChannelTreeAdapter(this), DataChannel.class);
            this.tree = treeProvider.tree();
        }
        this.progressMeterProvider = (ProgressMeterProvider)lookup.lookup(ProgressMeterProvider.class);
        this.serversPreferencesTopic = new ServersPreferencesTopic(this);
        lookup.add((Object)this.serversPreferencesTopic);
        this.timeSelectionPreferencesTopic = new TimeSelectionPreferencesTopic(this);
        lookup.add((Object)this.timeSelectionPreferencesTopic);
        XMLMenuBuilder builder = studio.getXMLMenuBuilder();
        URL xml = ((Object)((Object)this)).getClass().getResource("LsstPlugin.menus");
        builder.build(xml);
        JToolBar toolbar = builder.getToolBar("lsstPlugin");
        this.comboBoxModel = new TimeSelectionComboBoxModel();
        JComboBox box = new JComboBox();
        box.setModel(this.comboBoxModel);
        box.setEnabled(box.getItemCount() > 0);
        JLabel boxLabel = new JLabel("Trending Period: ");
        toolbar.add((Component)boxLabel, 0);
        toolbar.add((Component)box, 1);
        studio.addToolBar(toolbar, "Time Selection");
    }

    public TimeSelection getCurrentTimeSelection() {
        return (TimeSelection)this.comboBoxModel.getSelectedItem();
    }

    protected void postInit() {
        this.initializeBuses();
        RestPreferences restPrefs = this.serversPreferencesTopic.getServersPareferencesPanel() != null ? this.serversPreferencesTopic.getServersPareferencesPanel().getRestPreferences() : new RestPreferences();
        this.initializeRestServices(restPrefs);
    }

    public void initializeBuses() {
        SwingUtilities.invokeLater(new InitializeCommunicationBuses());
    }

    public void resetBuses() {
        LsstSubsystemPlugin.closeTracerConsole(this.defaultTracerName);
        LsstSubsystemPlugin.closeCommandConsole(this.defaultConsoleName);
        Lookup.Result result = FreeHEPLookup.instance().lookup(new Lookup.Template(Plugin.class));
        Collection plugins = result.allInstances();
        for (Plugin p : plugins) {
            if (!(p instanceof LsstSubsystemPlugin)) continue;
            ((LsstSubsystemPlugin)p).disconnectFromMessagingFactory();
        }
    }

    void continueAfterBusesInitialized() {
        this.progressMeterProvider.freeProgressMeter(this.progressMeter);
        LsstSubsystemPlugin.createTracerConsole(this.defaultTracerName, null);
        LsstSubsystemPlugin.createCommandConsole(this.defaultConsoleName);
        Lookup.Result result = FreeHEPLookup.instance().lookup(new Lookup.Template(LsstSubsystemPlugin.class));
        Collection plugins = result.allInstances();
        for (LsstSubsystemPlugin p : plugins) {
            p.connectToMessagingFactory();
        }
    }

    public void setBusesSystemProperties(JmsPreferences jmsPrefs) {
        System.setProperty("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "com.sun.enterprise.naming");
        System.setProperty("java.naming.factory.state", "com.sun.corba.ee.impl.presentation.rmi.JNDIStateFactoryImpl");
        System.setProperty("org.omg.CORBA.ORBInitialHost", jmsPrefs.getJmsServer());
        System.setProperty("org.omg.CORBA.ORBInitialPort", jmsPrefs.getJmsPort());
    }

    public void initializeRestServices(RestPreferences restPrefs) {
        SwingUtilities.invokeLater(new InitializeRestServices(restPrefs));
    }

    public void resetRestServices() {
        Lookup.Result result = FreeHEPLookup.instance().lookup(new Lookup.Template(LsstSubsystemPlugin.class));
        Collection plugins = result.allInstances();
        for (LsstSubsystemPlugin p : plugins) {
            p.resetRestServices();
        }
    }

    protected void registerChannelsForSubsystem(String subsystem) {
        DataChannel.DataChannelList channelList = (DataChannel.DataChannelList)this.service.path("dataserver").path("listchannels").accept(new String[]{"text/xml"}).get(DataChannel.DataChannelList.class);
        for (DataChannel chan : channelList.list) {
            String chanSubsystem = chan.getPath()[0];
            if (!subsystem.equals(chanSubsystem)) continue;
            this.tree.treeChanged((FTreeNotification)new FTreeNodeAddedNotification((Object)studio, chan.getPathAsString(), (Object)chan));
        }
    }

    protected void removeChannelsForSubsystem(String subsystem) {
        DataChannel.DataChannelList channelList = (DataChannel.DataChannelList)this.service.path("dataserver").path("listchannels").accept(new String[]{"text/xml"}).get(DataChannel.DataChannelList.class);
        for (DataChannel chan : channelList.list) {
            String chanSubsystem = chan.getPath()[0];
            if (subsystem.equals(chanSubsystem)) {
                this.tree.treeChanged((FTreeNotification)new FTreeNodeRemovedNotification((Object)studio, chan.getPathAsString()));
            }
            this.tree.treeChanged((FTreeNotification)new FTreeNodeRemovedNotification((Object)studio, subsystem));
        }
    }

    public Data getDataChannelData(int id, long t1, long t2) {
        WebResource resource = this.service.path("dataserver").path("data").path(String.valueOf(id));
        resource = resource.queryParam("t1", String.valueOf(t1)).queryParam("t2", String.valueOf(t2)).queryParam("flavor", "raw");
        return (Data)resource.accept(new String[]{"text/xml"}).get(Data.class);
    }

    class InitializeCommunicationBuses
    implements Runnable {
        InitializeCommunicationBuses() {
        }

        @Override
        public void run() {
            LsstPlugin.this.progressMeter = LsstPlugin.this.progressMeterProvider.getProgressMeter();
            LsstPlugin.this.progressMeter.setIndeterminate(true);
            LsstPlugin.this.progressMeter.setToolTipText("Initializing Buses");
            LsstPlugin.this.progressMeter.setShowStopButton(false);
            LsstPlugin.this.progressMeter.setVisible(true);
            LsstPlugin.this.progressMeter.setName("Connecting to Buses....");
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        try {
                            TopicSessionFactory.getSessionFactory().reset();
                            TopicSessionFactory.getSessionFactory().getTopicSession();
                            LsstPlugin.this.continueAfterBusesInitialized();
                        }
                        catch (Exception ioe) {
                            studio.error("Failed to initialize the Buses", (Throwable)ioe);
                            LsstPlugin.this.progressMeterProvider.freeProgressMeter(LsstPlugin.this.progressMeter);
                            if (LsstPlugin.this.serversPreferencesTopic.getServersPareferencesPanel() != null) {
                                LsstPlugin.this.serversPreferencesTopic.getServersPareferencesPanel().enableJmsPreferences(true);
                            }
                        }
                    }
                    finally {
                        if (LsstPlugin.this.serversPreferencesTopic.getServersPareferencesPanel() != null) {
                            LsstPlugin.this.serversPreferencesTopic.getServersPareferencesPanel().enableJmsPreferences(true);
                        }
                    }
                }
            };
            t.start();
        }
    }

    class InitializeRestServices
    implements Runnable {
        RestPreferences restPrefs;

        InitializeRestServices(RestPreferences restPrefs) {
            this.restPrefs = restPrefs;
        }

        @Override
        public void run() {
            String restFullUrl = "http://" + this.restPrefs.getRestServer();
            if (!"".equals(this.restPrefs.getRestPort())) {
                restFullUrl = String.valueOf(restFullUrl) + ":" + this.restPrefs.getRestPort();
            }
            restFullUrl = String.valueOf(restFullUrl) + "/rest/data";
            LsstPlugin.this.service = LsstPlugin.this.client.resource(restFullUrl);
            try {
                try {
                    DataChannel.DataChannelList cfr_ignored_0 = (DataChannel.DataChannelList)LsstPlugin.this.service.path("dataserver").path("listchannels").accept(new String[]{"text/xml"}).get(DataChannel.DataChannelList.class);
                    Lookup.Result result = FreeHEPLookup.instance().lookup(new Lookup.Template(LsstSubsystemPlugin.class));
                    Collection plugins = result.allInstances();
                    for (LsstSubsystemPlugin p : plugins) {
                        p.initializeRestServices();
                    }
                }
                catch (Exception e) {
                    studio.error("Failed to start Rest Services", (Throwable)e);
                    if (LsstPlugin.this.serversPreferencesTopic.getServersPareferencesPanel() != null) {
                        LsstPlugin.this.serversPreferencesTopic.getServersPareferencesPanel().enableRestPreferences(true);
                    }
                }
            }
            finally {
                if (LsstPlugin.this.serversPreferencesTopic.getServersPareferencesPanel() != null) {
                    LsstPlugin.this.serversPreferencesTopic.getServersPareferencesPanel().enableRestPreferences(true);
                }
            }
        }
    }
}

