/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.plugin.jas3;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandAck;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleConfigCommand;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.plugin.jas3.DummySubsystem;

public class CommandConsole
extends BusMaster {
    private BufferedReader rdr;
    private PrintWriter pw;

    CommandConsole(BufferedReader rdr, PrintWriter pw, String name) {
        this.rdr = rdr;
        this.pw = pw;
        this.setName(name);
        this.setStatusBroadcastPeriod(0);
    }

    public void doStart() {
        this.pw.println("Console ready, locking key = " + this.fac.getToken());
        while (true) {
            try {
                while (true) {
                    String line;
                    if ((line = this.rdr.readLine()) == null) {
                        continue;
                    }
                    this.execute(line);
                }
            }
            catch (IOException e) {
                this.pw.println(e);
                continue;
            }
            break;
        }
    }

    public void execute(String line) {
        String[] words = line.split(" +");
        if (words.length < 1) {
            return;
        }
        if (words[0].equals("lock")) {
            this.executeLock(words);
        } else if (words[0].equals("unlock")) {
            this.executeUnlock(words);
        } else if (words[0].equals("send")) {
            this.executeSend(words);
        } else if (words[0].equals("config")) {
            this.executeConfig(words);
        } else if (words[0].equals("invoke")) {
            this.executeInvoke(words);
        } else {
            this.pw.println("unknown command " + words[0]);
            return;
        }
    }

    private void executeSend(String[] words) {
        if (words.length < 3) {
            this.pw.println("missing arguments to send (target, data)");
        } else {
            String dest = words[1];
            String data = words[2];
            DummySubsystem.DummyCommand cmd = new DummySubsystem.DummyCommand(data);
            cmd.setDestination(dest);
            this.fac.sendCommand((Command)cmd);
        }
    }

    private Object parse(String s) {
        if (s.matches("-?[0-9]+")) {
            return Integer.parseInt(s);
        }
        if (s.matches("-?[0-9]*.[0-9]*|-?[0-9]*.[0-9]*e-?[0-9]+")) {
            return Double.parseDouble(s);
        }
        return s;
    }

    private void executeConfig(String[] words) {
        if (words.length < 4) {
            this.pw.println("missing arguments to config (target, name, value)");
        } else {
            String dest = words[1];
            String name = words[2];
            Object value = this.parse(words[3]);
            ModuleConfigCommand cmd = new ModuleConfigCommand();
            cmd.put(name, value);
            cmd.setDestination(dest);
            this.fac.sendCommand((Command)cmd);
        }
    }

    private void executeInvoke(String[] words) {
        if (words.length < 3) {
            this.pw.println("missing arguments to config (target, name, [params...])");
        } else {
            String dest = words[1];
            String name = words[2];
            int n = words.length - 3;
            Object[] p = new Object[n];
            int i = 0;
            while (i < n) {
                p[i] = this.parse(words[3 + i]);
                ++i;
            }
            ModuleInvokerCommand cmd = new ModuleInvokerCommand(name, p);
            cmd.setDestination(dest);
            this.fac.sendCommand((Command)cmd);
        }
    }

    private void executeLock(String[] words) {
        if (words.length < 2) {
            this.pw.println("missing argument to lock");
        } else {
            this.lockSubsystem(words[1]);
        }
    }

    private void executeUnlock(String[] words) {
        if (words.length < 2) {
            this.pw.println("missing argument to unlock");
        } else {
            this.unlockSubsystem(words[1]);
        }
    }

    public void onReply(CommandReply cmd) {
        String rep = "\nReply message from " + cmd.getOrigin();
        rep = String.valueOf(rep) + "\nOriginalCommand: " + cmd.getOriginalCommand();
        rep = String.valueOf(rep) + "\nStatus         : " + cmd.getStatus();
        rep = String.valueOf(rep) + "\nReply          : " + cmd.getReply();
        this.pw.println(rep);
    }

    public void onAck(CommandAck cmd) {
        String rep = "\nAck message from " + cmd.getOrigin();
        rep = String.valueOf(rep) + "\nOriginalCommand: " + cmd.getOriginalCommand();
        this.pw.println(rep);
    }
}

