/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.mcc;

import java.io.IOException;
import java.util.Scanner;
import javax.usb.UsbException;
import jline.ConsoleReader;
import org.lsst.ccs.drivers.mcc.MccUsb;
import org.lsst.ccs.utilities.sa.CmndProc;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestMccUsb
implements CmndProc.Dispatch {
    private static final int CMD_OPEN = 0;
    private static final int CMD_CLOSE = 1;
    private static final int CMD_DIOCFG = 2;
    private static final int CMD_DIOCFGBIT = 3;
    private static final int CMD_DIOIN = 4;
    private static final int CMD_DIOINBIT = 5;
    private static final int CMD_DIOOUT = 6;
    private static final int CMD_DIOOUTBIT = 7;
    private static final int CMD_ADIN = 8;
    private static final int CMD_ADSCAN = 9;
    private static final int CMD_CNTRINIT = 10;
    private static final int CMD_CNTRREAD = 11;
    private static final int CMD_BLINK = 12;
    private static final int CMD_RESET = 13;
    private static final int CMD_STATUS = 14;
    private static final int CMD_ITEMSET = 15;
    private static final int CMD_ITEMGET = 16;
    private static final int CMD_ALARMSET = 17;
    private static final int CMD_ALARMGET = 18;
    private static final int CMD_SHOWCHAN = 19;
    private static final int CMD_SHOWBURN = 20;
    private static final int CMD_SHOWCAL = 21;
    private static final int CMD_CALCFG = 22;
    private static final int CMD_CALIBRATE = 23;
    private static final int CMD_SHOWDEV = 24;
    private static final int NUM_CMDS = 25;
    private static final String[] helpOpen = new String[]{"Open device connection", "open [<device>] [<force>] [<serial>]", "device  The name of the MCC device to connect to", "force   If present and non-zero, force the interface claim", "serial  The serial number of the MCC device (default any)"};
    private static final String[] helpClose = new String[]{"Close device connection", "close"};
    private static final String[] helpDiocfg = new String[]{"Configure the DIO port", "diocfg <value>", "value  The mask of lines to set as input"};
    private static final String[] helpDiocfgbit = new String[]{"Configure a DIO line", "diocfgbit <line> <value>", "line   The line to configure", "value  The value to set (0 = out, 1 = in)"};
    private static final String[] helpDioin = new String[]{"Read the DIO port and display the value", "dioin"};
    private static final String[] helpDioinbit = new String[]{"Read a DIO line and display its value", "dioinbit <line>", "line  The line to read"};
    private static final String[] helpDioout = new String[]{"Write to the DIO port", "dioout <value>", "value  The value to write"};
    private static final String[] helpDiooutbit = new String[]{"Write to a DIO line", "diooutbit <line> <value>", "line   The line to write to", "value  The value to write"};
    private static final String[] helpAdin = new String[]{"Read an ADC channel and display its value", "adin <chan> <units>", "chan   The ADC channel to read", "units  The units to use (0 = temperature, 1 = voltage"};
    private static final String[] helpAdscan = new String[]{"Scan ADC channels and display their values", "adscan <first> <last> <units>", "first  The first ADC channel to read", "last   The last ADC channel to read", "units  The units to use (0 = temperature, 1 = voltage"};
    private static final String[] helpCntrinit = new String[]{"Initialize the counter", "cntrinit"};
    private static final String[] helpCntrread = new String[]{"Read and display the counter value", "cntrread"};
    private static final String[] helpBlink = new String[]{"Blink the LED", "blink"};
    private static final String[] helpReset = new String[]{"Reset the device", "reset"};
    private static final String[] helpStatus = new String[]{"Read and display the status byte", "status"};
    private static final String[] helpItemset = new String[]{"Set a configuration item", "itemset <item> <subitem> <value>", "item     The name or number of the item to be configured", "subitem  The name or number of the subitem", "value    The value to set"};
    private static final String[] helpItemget = new String[]{"Get and display a configuration item", "itemget <item> <subitem>", "item     The name or number of the configured item", "subitem  The name or number of the subitem"};
    private static final String[] helpAlarmset = new String[]{"Set the configuration for an alarm", "alarmset <alarm> <ioptns> <ooptns> <value1> <value2>", "alarm   The alarm number", "ioptns  The input options", "ooptns  The output options", "value1  The first alarm value", "value2  The second alarm value"};
    private static final String[] helpAlarmget = new String[]{"Get and display an alarm configuration", "alarmget <alarm>", "alarm  The alarm number"};
    private static final String[] helpShowchan = new String[]{"Get and display channel configuration", "showchan [<chan>] [<all>]", "chan  The channel number (0 - 7), or * for all channels", "all   If present and non-zero, display all configuration data"};
    private static final String[] helpShowdev = new String[]{"Display open device name", "showdev"};
    private static final String[] helpShowburn = new String[]{"Get, display and reset the burnout status", "showburn <mask>", "mask  The mask of channels to not reset (default 0x0f)"};
    private static final String[] helpShowcal = new String[]{"Get and display the number of calibration steps", "showcal"};
    private static final String[] helpCalcfg = new String[]{"Configure a calibration", "calcfg <gain> <polar> <path>", "gain   The gain selector", "polar  The polarity:  0 = positive, 1 = negative", "path   The path to use:  0 = channel high, 1 = channel low"};
    private static final String[] helpCalibrate = new String[]{"Perform a calibration", "calibrate <type>", "type  The type of calibration:  0 = temp, 1 = voltage, 2 = abort"};
    private static final CmndProc.Command cmnd = new CmndProc.Command(25);
    private static final CmndProc.Lookup devNames;
    private static final CmndProc.Lookup itemNames;
    private static final CmndProc.Lookup subiNames;
    private static final CmndProc.Lookup stypNames;
    private static final CmndProc.Lookup frateNames;
    private static final CmndProc.Lookup excitNames;
    private static final CmndProc.Lookup tctypNames;
    private static final CmndProc.Lookup gainNames;
    private static final CmndProc.Lookup rangeNames;
    private static final CmndProc.Lookup vconnNames;
    private static final CmndProc.Lookup stypsNames;
    private static final CmndProc.Lookup vconsNames;
    private static final CmndProc.Lookup tconnNames;
    private static final CmndProc.Lookup tconsNames;
    private final Output out = new ConsOut();
    private final ConsoleReader reader = new ConsoleReader();
    private final CmndProc proc = new CmndProc();
    private final MccUsb mcc = new MccUsb();
    private final boolean debug;
    private static final String[] caption;
    private static final boolean[] isValue;
    private static final boolean[] isExtra;
    private static final int[] loSubitem;
    private static final int[] hiSubitem;

    static {
        cmnd.add("open", 0, helpOpen);
        cmnd.add("close", 1, helpClose);
        cmnd.add("diocfg", 2, helpDiocfg);
        cmnd.add("diocfgbit", 3, helpDiocfgbit);
        cmnd.add("dioin", 4, helpDioin);
        cmnd.add("dioinbit", 5, helpDioinbit);
        cmnd.add("dioout", 6, helpDioout);
        cmnd.add("diooutbit", 7, helpDiooutbit);
        cmnd.add("adin", 8, helpAdin);
        cmnd.add("adscan", 9, helpAdscan);
        cmnd.add("cntrinit", 10, helpCntrinit);
        cmnd.add("cntrread", 11, helpCntrread);
        cmnd.add("blink", 12, helpBlink);
        cmnd.add("reset", 13, helpReset);
        cmnd.add("itemset", 15, helpItemset);
        cmnd.add("itemget", 16, helpItemget);
        cmnd.add("status", 14, helpStatus);
        cmnd.add("alarmset", 17, helpAlarmset);
        cmnd.add("alarmget", 18, helpAlarmget);
        cmnd.add("showdev", 24, helpShowdev);
        cmnd.add("showchan", 19, helpShowchan);
        cmnd.add("showburn", 20, helpShowburn);
        cmnd.add("showcal", 21, helpShowcal);
        cmnd.add("calcfg", 22, helpCalcfg);
        cmnd.add("calibrate", 23, helpCalibrate);
        devNames = new CmndProc.Lookup(2);
        devNames.add("tc-ai", 0);
        devNames.add("tc", 1);
        itemNames = new CmndProc.Lookup(4);
        itemNames.add("adc0", 0);
        itemNames.add("adc1", 1);
        itemNames.add("adc2", 2);
        itemNames.add("adc3", 3);
        subiNames = new CmndProc.Lookup(25);
        subiNames.add("senstype", 0);
        subiNames.add("conntype", 1);
        subiNames.add("filtrate", 2);
        subiNames.add("excitation", 3);
        subiNames.add("vref", 4);
        subiNames.add("ival0", 5);
        subiNames.add("ival1", 6);
        subiNames.add("ival2", 7);
        subiNames.add("vval0", 8);
        subiNames.add("vval1", 9);
        subiNames.add("vval2", 10);
        subiNames.add("tc0", 16);
        subiNames.add("tc1", 17);
        subiNames.add("gain0", 18);
        subiNames.add("gain1", 19);
        subiNames.add("coef00", 20);
        subiNames.add("coef01", 21);
        subiNames.add("coef10", 22);
        subiNames.add("coef11", 23);
        subiNames.add("coef20", 24);
        subiNames.add("coef21", 25);
        subiNames.add("coef30", 26);
        subiNames.add("coef31", 27);
        subiNames.add("vconn0", 28);
        subiNames.add("vconn1", 29);
        stypNames = new CmndProc.Lookup(6);
        stypNames.add("rtd", 0);
        stypNames.add("thermistor", 1);
        stypNames.add("thermocouple", 2);
        stypNames.add("semiconductor", 3);
        stypNames.add("disabled", 4);
        stypNames.add("voltage", 5);
        stypsNames = new CmndProc.Lookup(6);
        stypsNames.add("rtd", 0);
        stypsNames.add("thermis", 1);
        stypsNames.add("thermoc", 2);
        stypsNames.add("semicon", 3);
        stypsNames.add("disabld", 4);
        stypsNames.add("voltage", 5);
        frateNames = new CmndProc.Lookup(14);
        frateNames.add("500 Hz", 1);
        frateNames.add("250 Hz", 2);
        frateNames.add("125 Hz", 3);
        frateNames.add("62.5 Hz", 4);
        frateNames.add("50 Hz", 5);
        frateNames.add("39.2 Hz", 6);
        frateNames.add("33.3 Hz", 7);
        frateNames.add("19.6 Hz", 8);
        frateNames.add("16.7 Hz", 9);
        frateNames.add("12.5 Hz", 11);
        frateNames.add("10 Hz", 12);
        frateNames.add("8.33 Hz", 13);
        frateNames.add("6.25 Hz", 14);
        frateNames.add("4.17 Hz", 15);
        tctypNames = new CmndProc.Lookup(8);
        tctypNames.add("J", 0);
        tctypNames.add("K", 1);
        tctypNames.add("T", 2);
        tctypNames.add("E", 3);
        tctypNames.add("R", 4);
        tctypNames.add("S", 5);
        tctypNames.add("B", 6);
        tctypNames.add("N", 7);
        gainNames = new CmndProc.Lookup(8);
        gainNames.add("1X", 0);
        gainNames.add("2X", 1);
        gainNames.add("4X", 2);
        gainNames.add("8X", 3);
        gainNames.add("16X", 4);
        gainNames.add("32X", 5);
        gainNames.add("64X", 6);
        gainNames.add("128X", 7);
        rangeNames = new CmndProc.Lookup(4);
        rangeNames.add("10V", 2);
        rangeNames.add("5V", 3);
        rangeNames.add("2.5V", 4);
        rangeNames.add("1.25V", 5);
        vconnNames = new CmndProc.Lookup(4);
        vconnNames.add("differential", 0);
        vconnNames.add("single-ended", 1);
        vconnNames.add("grounded", 2);
        vconnNames.add("calibration", 3);
        vconsNames = new CmndProc.Lookup(4);
        vconsNames.add("differ", 0);
        vconsNames.add("snglend", 1);
        vconsNames.add("ground", 2);
        vconsNames.add("calib", 3);
        excitNames = new CmndProc.Lookup(3);
        excitNames.add("off", 0);
        excitNames.add("10 uA", 1);
        excitNames.add("210 uA", 2);
        tconnNames = new CmndProc.Lookup(4);
        tconnNames.add("2-wire, 1-sensor", 0);
        tconnNames.add("2-wire, 2-sensor", 1);
        tconnNames.add("3-wire", 2);
        tconnNames.add("4-wire", 3);
        tconsNames = new CmndProc.Lookup(4);
        tconsNames.add("2-wire1", 0);
        tconsNames.add("2-wire2", 1);
        tconsNames.add("3-wire", 2);
        tconsNames.add("4-wire", 3);
        caption = new String[]{"Sensor type", "Therm conn", "Excitation", "Filter rate", "TC type", "Gain", "Voltage conn", "Refc voltage", "I value 0", "I value 1", "I value 2", "V value 0", "V value 1", "V value 2", "Coeff 0", "Coeff 1", "Coeff 2", "Coeff 3"};
        boolean[] blArray = new boolean[18];
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[10] = true;
        blArray[11] = true;
        blArray[12] = true;
        blArray[13] = true;
        blArray[14] = true;
        blArray[15] = true;
        blArray[16] = true;
        blArray[17] = true;
        isValue = blArray;
        boolean[] blArray2 = new boolean[18];
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[8] = true;
        blArray2[9] = true;
        blArray2[10] = true;
        blArray2[11] = true;
        blArray2[12] = true;
        blArray2[13] = true;
        blArray2[14] = true;
        blArray2[15] = true;
        blArray2[16] = true;
        blArray2[17] = true;
        isExtra = blArray2;
        int[] nArray = new int[18];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 2;
        nArray[4] = 16;
        nArray[5] = 18;
        nArray[6] = 28;
        nArray[7] = 4;
        nArray[8] = 5;
        nArray[9] = 6;
        nArray[10] = 7;
        nArray[11] = 8;
        nArray[12] = 9;
        nArray[13] = 10;
        nArray[14] = 20;
        nArray[15] = 22;
        nArray[16] = 24;
        nArray[17] = 26;
        loSubitem = nArray;
        int[] nArray2 = new int[18];
        nArray2[1] = 1;
        nArray2[2] = 3;
        nArray2[3] = 2;
        nArray2[4] = 17;
        nArray2[5] = 19;
        nArray2[6] = 29;
        nArray2[7] = 4;
        nArray2[8] = 5;
        nArray2[9] = 6;
        nArray2[10] = 7;
        nArray2[11] = 8;
        nArray2[12] = 9;
        nArray2[13] = 10;
        nArray2[14] = 21;
        nArray2[15] = 23;
        nArray2[16] = 25;
        nArray2[17] = 27;
        hiSubitem = nArray2;
    }

    public TestMccUsb(boolean dbg) throws UsbException, IOException {
        this.debug = dbg;
        this.proc.add((CmndProc.Dispatch)this, cmnd);
    }

    public static void main(String[] args) {
        TestMccUsb tmcc = null;
        try {
            tmcc = new TestMccUsb(args.length > 0);
            tmcc.run();
        }
        catch (UsbException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        System.exit(0);
    }

    public void run() throws IOException {
        String line;
        while ((line = this.reader.readLine(">> ")) != null) {
            try {
                if (this.proc.process(line)) continue;
                break;
            }
            catch (RuntimeException e) {
                if (this.debug) {
                    e.printStackTrace(System.out);
                    continue;
                }
                this.out.println((Object)e);
            }
        }
    }

    public boolean dispatch(int code, Scanner scan) {
        try {
            return this.dispatchCmnd(code, scan);
        }
        catch (UsbException e) {
            this.out.println((Object)e.toString());
            return true;
        }
    }

    private boolean dispatchCmnd(int code, Scanner scan) throws UsbException {
        Object[] args = new Object[16];
        switch (code) {
            case 0: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"sis", (Object[])args);
                if (found < 0) break;
                int devId = 0;
                if ((found & 1) == 0) {
                    this.showNames("device", devNames);
                    break;
                }
                devId = devNames.encode((String)args[0], true);
                if (devId < 0) break;
                String serialNo = null;
                if ((found & 4) != 0) {
                    serialNo = (String)args[2];
                }
                this.mcc.open(devId, serialNo, ((found & 2) != 0 ? (Integer)args[1] : 0) != 0);
                break;
            }
            case 1: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.mcc.close();
                break;
            }
            case 2: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"I", (Object[])args);
                if (found < 0) break;
                this.mcc.dioConfig((Integer)args[0]);
                break;
            }
            case 3: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"II", (Object[])args);
                if (found < 0) break;
                this.mcc.dioConfigBit((Integer)args[0], (Integer)args[1]);
                break;
            }
            case 4: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.out.format("Value = 0x%02x\n", new Object[]{this.mcc.dioIn()});
                break;
            }
            case 5: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"I", (Object[])args);
                if (found < 0) break;
                this.out.println((Object)("Value = " + this.mcc.dioInBit((Integer)args[0])));
                break;
            }
            case 6: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"I", (Object[])args);
                if (found < 0) break;
                this.mcc.dioOut((Integer)args[0]);
                break;
            }
            case 7: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"II", (Object[])args);
                if (found < 0) break;
                this.mcc.dioOutBit((Integer)args[0], (Integer)args[1]);
                break;
            }
            case 8: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Ii", (Object[])args);
                if (found < 0) break;
                int chan = (Integer)args[0];
                int units = (found & 2) != 0 ? (Integer)args[1] : 0;
                this.out.println((Object)("Value = " + this.mcc.adcIn(chan, units)));
                break;
            }
            case 9: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"IIi", (Object[])args);
                if (found < 0) break;
                float[] value = new float[8];
                int units = (found & 4) != 0 ? (Integer)args[2] : 0;
                int fChan = (Integer)args[0];
                int count = this.mcc.adcScan(fChan, (Integer)args[1], units, value);
                if (count <= 0) break;
                this.out.print((Object)"Values =");
                int posn = 8;
                int j = 0;
                while (j < count) {
                    String sValue = " " + value[j];
                    if ((posn += sValue.length()) > 80) {
                        this.out.print((Object)"\n        ");
                        posn = 8;
                    }
                    this.out.print((Object)sValue);
                    ++j;
                }
                this.out.println();
                break;
            }
            case 10: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.mcc.cntrInit();
                break;
            }
            case 11: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.out.println((Object)("Value = " + this.mcc.cntrRead()));
                break;
            }
            case 12: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.mcc.blink();
                break;
            }
            case 13: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.mcc.reset();
                break;
            }
            case 14: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.out.format("Value = 0x%02x\n", new Object[]{this.mcc.getStatus()});
                break;
            }
            case 15: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ssf", (Object[])args);
                if (found < 0) break;
                if ((found & 1) == 0) {
                    this.showNames("item", itemNames);
                    break;
                }
                int item = this.encode(itemNames, (String)args[0]);
                if (item < 0) break;
                if ((found & 2) == 0) {
                    this.showNames("subitem", subiNames);
                    break;
                }
                int subItem = this.encode(subiNames, (String)args[1]);
                if (subItem < 0) break;
                if ((found & 4) == 0) {
                    if (subItem == 2) {
                        this.showNames("filter rate", frateNames);
                        break;
                    }
                    if (subItem == 16 || subItem == 17) {
                        this.showNames("thermocouple type", tctypNames);
                        break;
                    }
                    if (subItem == 18 || subItem == 19) {
                        this.showNames("gain", gainNames);
                        break;
                    }
                    if (subItem == 28 || subItem == 29) {
                        this.showNames("connection type", vconnNames);
                        break;
                    }
                    this.out.println((Object)"Missing value argument");
                    break;
                }
                this.mcc.setItem(item, subItem, ((Float)args[2]).floatValue());
                break;
            }
            case 16: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ss", (Object[])args);
                if (found < 0) break;
                if ((found & 1) == 0) {
                    this.showNames("item", itemNames);
                    break;
                }
                if ((found & 2) == 0) {
                    this.showNames("subitem", subiNames);
                    break;
                }
                int item = this.encode(itemNames, (String)args[0]);
                int subItem = this.encode(subiNames, (String)args[1]);
                if (item < 0 || subItem < 0) break;
                float value = this.mcc.getItem(item, subItem);
                if (subItem >= 4 && subItem <= 10 || subItem >= 20 && subItem <= 27) {
                    this.out.println((Object)("Value = " + value));
                    break;
                }
                int iValue = (int)value;
                if (subItem == 0) {
                    this.out.format("Value = %s (%s)\n", new Object[]{iValue, stypNames.decode(iValue)});
                    break;
                }
                if (subItem == 2) {
                    this.out.format("Value = %s (%s)\n", new Object[]{iValue, frateNames.decode(iValue)});
                    break;
                }
                if (subItem == 3) {
                    this.out.format("Value = %s (%s)\n", new Object[]{iValue, excitNames.decode(iValue)});
                    break;
                }
                if (subItem == 16 || subItem == 17) {
                    this.out.format("Value = %s (%s)\n", new Object[]{iValue, tctypNames.decode(iValue)});
                    break;
                }
                if (subItem == 18 || subItem == 19) {
                    this.out.format("Value = %s (%s)\n", new Object[]{iValue, gainNames.decode(iValue)});
                    break;
                }
                if (subItem == 28 || subItem == 29) {
                    this.out.format("Value = %s (%s)\n", new Object[]{iValue, vconnNames.decode(iValue)});
                    break;
                }
                this.out.println((Object)("Value = " + iValue));
                break;
            }
            case 17: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"IIIFF", (Object[])args);
                if (found < 0) break;
                this.mcc.configAlarm((Integer)args[0], (Integer)args[1], (Integer)args[2], ((Float)args[3]).floatValue(), ((Float)args[4]).floatValue());
                break;
            }
            case 18: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"I", (Object[])args);
                if (found < 0) break;
                int[] optns = new int[2];
                float[] values = new float[]{0.0f, 0.0f};
                this.mcc.getAlarmConfig((Integer)args[0], optns, values);
                this.out.format("InOptns = 0x%02x, OutOptns = 0x%02x, Value1 = %s, Value2 = %s\n", new Object[]{optns[0], optns[1], Float.valueOf(values[0]), Float.valueOf(values[1])});
                break;
            }
            case 24: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                int devId = this.mcc.getDevId();
                if (devId < 0) {
                    this.out.println((Object)"No device open");
                    break;
                }
                this.out.format("Device = %s\n", new Object[]{devNames.decode(devId)});
                break;
            }
            case 19: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ii", (Object[])args);
                if (found < 0) break;
                this.showChannel((found & 1) != 0 ? (Integer)args[0] : -1, (found & 2) != 0 && (Integer)args[1] != 0);
                break;
            }
            case 20: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"i", (Object[])args);
                if (found < 0) break;
                int mask = (found & 1) != 0 ? (Integer)args[0] : 255;
                this.out.format("Value = 0x%02x\n", new Object[]{this.mcc.getBurnout(mask)});
                break;
            }
            case 21: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                int[] steps = new int[2];
                this.mcc.calSteps(steps);
                this.out.format("Calibration steps: temp = %s, voltage = %s\n", new Object[]{steps[0], steps[1]});
                break;
            }
            case 22: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"III", (Object[])args);
                if (found < 0) break;
                this.mcc.calConfig((Integer)args[0], (Integer)args[1], (Integer)args[2]);
                break;
            }
            case 23: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"I", (Object[])args);
                if (found < 0) break;
                this.mcc.calibrate((Integer)args[0]);
                break;
            }
            default: {
                this.out.println((Object)"Command not fully implemented");
            }
        }
        return true;
    }

    private void showChannel(int chan, boolean all) throws UsbException {
        int first = chan < 0 ? 0 : chan & 7;
        int last = chan < 0 ? 7 : chan & 7;
        this.out.print((Object)"              ");
        int j = first;
        while (j <= last) {
            this.out.format("   Ch %s ", new Object[]{j});
            ++j;
        }
        this.out.println();
        this.out.print((Object)"              ");
        j = first;
        while (j <= last) {
            this.out.print((Object)" -------");
            ++j;
        }
        this.out.println();
        int k = 0;
        while (k < caption.length) {
            if (!isExtra[k] || all) {
                this.out.format("%-12s: ", new Object[]{caption[k]});
                int highSub = hiSubitem[k];
                int lowSub = loSubitem[k];
                boolean isVal = isValue[k];
                int j2 = first;
                while (j2 <= last) {
                    float value = this.mcc.getItem(j2 >> 1, (j2 & 1) != 0 ? highSub : lowSub);
                    if (isVal) {
                        this.out.format(" %7.7s", new Object[]{Float.valueOf(value)});
                    } else {
                        String desc = "huh?";
                        if (lowSub == 0) {
                            desc = stypsNames.decode((int)value);
                        } else if (lowSub == 1) {
                            desc = tconsNames.decode((int)value);
                        } else if (lowSub == 3) {
                            desc = excitNames.decode((int)value);
                        } else if (lowSub == 2) {
                            desc = frateNames.decode((int)value);
                        } else if (lowSub == 16) {
                            desc = tctypNames.decode((int)value);
                        } else if (lowSub == 18) {
                            desc = gainNames.decode((int)value);
                        } else if (lowSub == 28) {
                            desc = vconsNames.decode((int)value);
                        }
                        this.out.format(" %7s", new Object[]{desc});
                    }
                    ++j2;
                }
                this.out.println();
            }
            ++k;
        }
    }

    private void showNames(String desc, CmndProc.Lookup lookup) {
        this.out.println((Object)("Possible " + desc + " names:"));
        int j = 0;
        while (j < lookup.count()) {
            this.out.format("  %s (%s)\n", new Object[]{lookup.name(j), lookup.code(j)});
            ++j;
        }
    }

    private int encode(CmndProc.Lookup lookup, String token) {
        int value;
        try {
            value = Integer.valueOf(token);
        }
        catch (NumberFormatException numberFormatException) {
            value = lookup.encode(token, true);
        }
        return value;
    }
}

