/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.mcc;

import javax.usb.UsbException;
import org.lsst.ccs.drivers.mcc.MccUsbException;
import org.lsst.ccs.drivers.usb.UsbComm;
import org.lsst.ccs.utilities.conv.Convert;

public class MccUsb {
    public static final int USB_TC_AI_DID = 0;
    public static final int USB_TC_DID = 1;
    private static final int N_DIDS = 2;
    public static final int CIT_ADC_0 = 0;
    public static final int CIT_ADC_1 = 1;
    public static final int CIT_ADC_2 = 2;
    public static final int CIT_ADC_3 = 3;
    public static final int CSI_SENSOR_TYPE = 0;
    public static final int CSI_CONN_TYPE = 1;
    public static final int CSI_FILTER_RATE = 2;
    public static final int CSI_EXCITATION = 3;
    public static final int CSI_VREF = 4;
    public static final int CSI_I_VALUE_0 = 5;
    public static final int CSI_I_VALUE_1 = 6;
    public static final int CSI_I_VALUE_2 = 7;
    public static final int CSI_V_VALUE_0 = 8;
    public static final int CSI_V_VALUE_1 = 9;
    public static final int CSI_V_VALUE_2 = 10;
    public static final int CSI_CH_0_TC = 16;
    public static final int CSI_CH_1_TC = 17;
    public static final int CSI_CH_0_GAIN = 18;
    public static final int CSI_CH_1_GAIN = 19;
    public static final int CSI_CH_0_COEF_0 = 20;
    public static final int CSI_CH_1_COEF_0 = 21;
    public static final int CSI_CH_0_COEF_1 = 22;
    public static final int CSI_CH_1_COEF_1 = 23;
    public static final int CSI_CH_0_COEF_2 = 24;
    public static final int CSI_CH_1_COEF_2 = 25;
    public static final int CSI_CH_0_COEF_3 = 26;
    public static final int CSI_CH_1_COEF_3 = 27;
    public static final int CSI_CH_0_VCONN = 28;
    public static final int CSI_CH_1_VCONN = 29;
    public static final int STP_RTD = 0;
    public static final int STP_THERMISTOR = 1;
    public static final int STP_THERMOCOUPLE = 2;
    public static final int STP_SEMICONDUCTOR = 3;
    public static final int STP_DISABLED = 4;
    public static final int STP_VOLTAGE = 5;
    public static final int FREQ_500_HZ = 1;
    public static final int FREQ_250_HZ = 2;
    public static final int FREQ_125_HZ = 3;
    public static final int FREQ_62_5_HZ = 4;
    public static final int FREQ_50_HZ = 5;
    public static final int FREQ_39_2_HZ = 6;
    public static final int FREQ_33_3_HZ = 7;
    public static final int FREQ_19_6_HZ = 8;
    public static final int FREQ_16_7_HZ = 9;
    public static final int FREQ_12_5_HZ = 11;
    public static final int FREQ_10_HZ = 12;
    public static final int FREQ_8_33_HZ = 13;
    public static final int FREQ_6_25_HZ = 14;
    public static final int FREQ_4_17_HZ = 15;
    public static final int TC_TYPE_J = 0;
    public static final int TC_TYPE_K = 1;
    public static final int TC_TYPE_T = 2;
    public static final int TC_TYPE_E = 3;
    public static final int TC_TYPE_R = 4;
    public static final int TC_TYPE_S = 5;
    public static final int TC_TYPE_B = 6;
    public static final int TC_TYPE_N = 7;
    public static final int GAIN_1X = 0;
    public static final int GAIN_2X = 1;
    public static final int GAIN_4X = 2;
    public static final int GAIN_8X = 3;
    public static final int GAIN_16X = 4;
    public static final int GAIN_32X = 5;
    public static final int GAIN_64X = 6;
    public static final int GAIN_128X = 7;
    public static final int RANGE_10V = 2;
    public static final int RANGE_5V = 3;
    public static final int RANGE_2_5V = 4;
    public static final int RANGE_1_25V = 5;
    public static final int VCT_DIFFERENTIAL = 0;
    public static final int VCT_SINGLE_ENDED = 1;
    public static final int VCT_GROUNDED = 2;
    public static final int VCT_CALIBRATION = 3;
    public static final int TCT_2WIRE_1SENSOR = 0;
    public static final int TCT_2WIRE_2SENSOR = 1;
    public static final int TCT_3WIRE = 2;
    public static final int TCT_4WIRE = 3;
    public static final int CEX_OFF = 0;
    public static final int CEX_10UA = 1;
    public static final int CEX_210UA = 2;
    private static final int MCC_VID = 2523;
    private static final int USB_TC_PID = 144;
    private static final int USB_TC_AI_PID = 187;
    private static final int OP_DIO_CFG = 0;
    private static final int OP_DIO_CFG_BIT = 1;
    private static final int OP_DIO_IN = 2;
    private static final int OP_DIO_OUT = 3;
    private static final int OP_DIO_IN_BIT = 4;
    private static final int OP_DIO_OUT_BIT = 5;
    private static final int OP_ADC_IN = 6;
    private static final int OP_ADC_SCAN = 7;
    private static final int OP_CNTR_INIT = 8;
    private static final int OP_CNTR_READ = 9;
    private static final int OP_MEM_READ = 10;
    private static final int OP_MEM_WRITE = 11;
    private static final int OP_LED_BLINK = 12;
    private static final int OP_RESET = 13;
    private static final int OP_GET_STATUS = 14;
    private static final int OP_SET_ITEM = 15;
    private static final int OP_GET_ITEM = 16;
    private static final int OP_CALIBRATE = 17;
    private static final int OP_GET_BURN_STS = 18;
    private static final int OP_CAL_CONFIG = 19;
    private static final int OP_CAL_STEPS = 20;
    private static final int OP_PREP_DWNLD = 21;
    private static final int OP_CODE_WRITE = 22;
    private static final int OP_SET_SERIAL = 23;
    private static final int OP_CODE_READ = 24;
    private static final int OP_ALARM_CONFIG = 25;
    private static final int OP_ALARM_GET = 26;
    private static final int N_OPS = 27;
    private static final byte CMND_DIO_CFG = 1;
    private static final byte CMND_DIO_CFG_BIT = 2;
    private static final byte CMND_DIO_IN = 3;
    private static final byte CMND_DIO_OUT = 4;
    private static final byte CMND_DIO_IN_BIT = 5;
    private static final byte CMND_DIO_OUT_BIT = 6;
    private static final byte CMND_ADC_IN = 24;
    private static final byte CMND_ADC_SCAN = 25;
    private static final byte CMND_CNTR_INIT = 32;
    private static final byte CMND_CNTR_READ = 33;
    private static final byte CMND_MEM_READ = 48;
    private static final byte CMND_MEM_WRITE = 49;
    private static final byte CMND_LED_BLINK = 64;
    private static final byte CMND_RESET = 65;
    private static final byte CMND_GET_STATUS = 68;
    private static final byte CMND_SET_ITEM = 73;
    private static final byte CMND_GET_ITEM = 74;
    private static final byte CMND_CALIBRATE = 75;
    private static final byte CMND_GET_BURN_STS = 76;
    private static final byte CMND_CAL_CONFIG = 77;
    private static final byte CMND_CAL_STEPS = 78;
    private static final byte CMND_PREP_DWNLD = 80;
    private static final byte CMND_CODE_WRITE = 81;
    private static final byte CMND_SET_SERIAL = 83;
    private static final byte CMND_CODE_READ = 85;
    private static final byte CMND_ALARM_CONFIG = 107;
    private static final byte CMND_ALARM_GET = 108;
    private static final byte CHAN_HI_PATH = 0;
    private static final byte CHAN_LO_PATH = 1;
    private static final int RCVE_TMO = 500;
    private static final int[] pids = new int[2];
    private static final Operation[] opern = new Operation[27];
    private final UsbComm usb = new UsbComm();
    private int devId = -1;

    static {
        MccUsb.pids[0] = 187;
        MccUsb.pids[1] = 144;
        MccUsb.opern[0] = new Operation(1, 0, 1);
        MccUsb.opern[1] = new Operation(2, 0, 1);
        MccUsb.opern[2] = new Operation(3, 0, 1);
        MccUsb.opern[3] = new Operation(4, 0, 1);
        MccUsb.opern[4] = new Operation(5, 0, 1);
        MccUsb.opern[5] = new Operation(6, 0, 1);
        MccUsb.opern[6] = new Operation(24, 0, 1);
        MccUsb.opern[7] = new Operation(25, 0, 1);
        MccUsb.opern[8] = new Operation(32, 0);
        MccUsb.opern[9] = new Operation(33, 0);
        MccUsb.opern[10] = new Operation(48, 0, 1);
        MccUsb.opern[11] = new Operation(49, 0, 1);
        MccUsb.opern[12] = new Operation(64, 0, 1);
        MccUsb.opern[13] = new Operation(65, 0, 1);
        MccUsb.opern[14] = new Operation(68, 0, 1);
        MccUsb.opern[15] = new Operation(73, 0, 1);
        MccUsb.opern[16] = new Operation(74, 0, 1);
        MccUsb.opern[17] = new Operation(75, 0, 1);
        MccUsb.opern[18] = new Operation(76, 0, 1);
        MccUsb.opern[19] = new Operation(77, 0);
        MccUsb.opern[20] = new Operation(78, 0);
        MccUsb.opern[21] = new Operation(80, 0, 1);
        MccUsb.opern[22] = new Operation(81, 0, 1);
        MccUsb.opern[23] = new Operation(83, 0, 1);
        MccUsb.opern[24] = new Operation(85, 0, 1);
        MccUsb.opern[25] = new Operation(107, 0);
        MccUsb.opern[26] = new Operation(108, 0);
    }

    public int getDevId() {
        return this.devId;
    }

    public UsbComm getUsbComm() {
        return this.usb;
    }

    public void open(int did, String serial, boolean force) throws MccUsbException, UsbException {
        if (this.devId >= 0) {
            throw new MccUsbException("Device connection already open");
        }
        if (did < 0 || did >= pids.length) {
            throw new MccUsbException("Invalid device identifier");
        }
        if (this.usb.findDevice(2523, pids[did], serial) == null) {
            throw new MccUsbException("Device not found");
        }
        this.usb.open(0, 0, force);
        this.devId = did;
    }

    public void close() throws MccUsbException, UsbException {
        if (this.devId < 0) {
            throw new MccUsbException("No device connection open");
        }
        this.devId = -1;
        this.usb.close();
    }

    public synchronized void dioConfig(int direction) throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(0), (byte)direction};
        this.usb.write(cmnd);
    }

    public synchronized void dioConfigBit(int bitno, int direction) throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(1), (byte)bitno, (byte)direction};
        this.usb.write(cmnd);
    }

    public synchronized int dioIn() throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(2)};
        byte[] resp = new byte[2];
        this.usb.write(cmnd);
        int leng = this.usb.read(resp, 500);
        return leng == resp.length ? resp[1] & 0xFF : -1;
    }

    public synchronized int dioInBit(int bitno) throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(4), (byte)bitno};
        byte[] resp = new byte[2];
        this.usb.write(cmnd);
        int leng = this.usb.read(resp, 500);
        return leng == resp.length ? resp[1] & 0xFF : -1;
    }

    public synchronized void dioOut(int value) throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(3), (byte)value};
        this.usb.write(cmnd);
    }

    public synchronized void dioOutBit(int bitno, int value) throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(5), (byte)bitno, (byte)value};
        this.usb.write(cmnd);
    }

    public synchronized void cntrInit() throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(8)};
        this.usb.write(cmnd);
    }

    public synchronized int cntrRead() throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(9)};
        byte[] resp = new byte[5];
        this.usb.write(cmnd);
        int leng = this.usb.read(resp, 500);
        return leng == resp.length ? Convert.bytesToInt((byte[])resp, (int)1) : 0;
    }

    public synchronized float adcIn(int chan, int units) throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(6), (byte)chan, (byte)units};
        byte[] resp = new byte[5];
        this.usb.write(cmnd);
        int leng = this.usb.read(resp, 500);
        if (leng != resp.length) {
            return 0.0f;
        }
        if (units == 1 && this.devId != 1 && chan >= 4 && chan < 128) {
            return Convert.bytesToInt((byte[])resp, (int)1);
        }
        return Convert.bytesToFloat((byte[])resp, (int)1);
    }

    public synchronized int adcScan(int start, int end, int units, float[] value) throws MccUsbException, UsbException {
        int nChan;
        byte code = this.getCmnd(7);
        if (end > 7) {
            end = 7;
        }
        if (start < 0) {
            start = 0;
        }
        if ((nChan = end - start + 1) <= 0) {
            return 0;
        }
        byte[] cmnd = new byte[]{code, (byte)start, (byte)end, (byte)units};
        byte[] resp = new byte[33];
        this.usb.write(cmnd);
        int leng = this.usb.read(resp, 500);
        if (leng >= 4 * nChan + 1) {
            int j = 0;
            while (j < nChan) {
                value[j] = units == 1 && j + start >= 4 ? (float)Convert.bytesToInt((byte[])resp, (int)(4 * j + 1)) : Convert.bytesToFloat((byte[])resp, (int)(4 * j + 1));
                ++j;
            }
        } else {
            nChan = 0;
        }
        return nChan;
    }

    public synchronized void blink() throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(12)};
        this.usb.write(cmnd);
    }

    public synchronized void reset() throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(13)};
        this.usb.write(cmnd);
    }

    public synchronized float getItem(int item, int subItem) throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(16), (byte)item, (byte)subItem};
        byte[] resp = new byte[5];
        this.usb.write(cmnd);
        int leng = this.usb.read(resp, 500);
        if (leng == resp.length) {
            if (subItem >= 4 && subItem <= 10 || subItem >= 20 && subItem <= 27) {
                return Convert.bytesToFloat((byte[])resp, (int)1);
            }
            return resp[1] & 0xFF;
        }
        return 0.0f;
    }

    public int getSensorType(int chan) throws MccUsbException, UsbException {
        return (int)this.getItem(chan >> 1, 0);
    }

    public int getThermConnType(int chan) throws MccUsbException, UsbException {
        return (int)this.getItem(chan >> 1, 1);
    }

    public int getFilterRate(int chan) throws MccUsbException, UsbException {
        return (int)this.getItem(chan >> 1, 2);
    }

    public float getReferenceVoltage(int chan) throws MccUsbException, UsbException {
        return this.getItem(chan >> 1, 4);
    }

    public int getGain(int chan) throws MccUsbException, UsbException {
        return (int)this.getItem(chan >> 1, (chan & 1) == 0 ? 18 : 19);
    }

    public int getTCType(int chan) throws MccUsbException, UsbException {
        return (int)this.getItem(chan >> 1, (chan & 1) == 0 ? 16 : 17);
    }

    public int getVoltageConnType(int chan) throws MccUsbException, UsbException {
        return (int)this.getItem(chan >> 1, (chan & 1) == 0 ? 28 : 29);
    }

    public synchronized void setItem(int item, int subItem, float value) throws MccUsbException, UsbException {
        byte[] byArray = new byte[7];
        byArray[0] = this.getCmnd(15);
        byArray[1] = (byte)item;
        byArray[2] = (byte)subItem;
        byte[] cmnd = byArray;
        if (subItem == 4) {
            Convert.floatToBytes((float)value, (byte[])cmnd, (int)3);
            this.usb.write(cmnd);
        } else {
            cmnd[3] = (byte)value;
            this.usb.write(cmnd, 0, 4);
        }
    }

    public void setGain(int chan, int gain) throws MccUsbException, UsbException {
        this.setItem(chan >> 1, (chan & 1) == 0 ? 18 : 19, gain);
    }

    public void setTCType(int chan, int type) throws MccUsbException, UsbException {
        this.setItem(chan >> 1, (chan & 1) == 0 ? 16 : 17, type);
    }

    public void setVoltageConnType(int chan, int type) throws MccUsbException, UsbException {
        this.setItem(chan >> 1, (chan & 1) == 0 ? 28 : 29, type);
    }

    public synchronized void configAlarm(int alarm, int iOptns, int oOptns, float value1, float value2) throws MccUsbException, UsbException {
        byte[] cmnd = new byte[12];
        cmnd[0] = this.getCmnd(25);
        cmnd[1] = (byte)alarm;
        cmnd[2] = (byte)iOptns;
        cmnd[3] = (byte)oOptns;
        Convert.floatToBytes((float)value1, (byte[])cmnd, (int)4);
        Convert.floatToBytes((float)value2, (byte[])cmnd, (int)8);
        this.usb.write(cmnd);
    }

    public synchronized void getAlarmConfig(int alarm, int[] optns, float[] values) throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(26), (byte)alarm};
        byte[] resp = new byte[11];
        this.usb.write(cmnd);
        int leng = this.usb.read(resp, 500);
        if (leng == resp.length) {
            optns[0] = resp[1] & 0xFF;
            optns[1] = resp[2] & 0xFF;
            values[0] = Convert.bytesToFloat((byte[])resp, (int)3);
            values[1] = Convert.bytesToFloat((byte[])resp, (int)7);
        }
    }

    public synchronized void calSteps(int[] steps) throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(20)};
        byte[] resp = new byte[3];
        this.usb.write(cmnd);
        int leng = this.usb.read(resp, 500);
        if (leng == resp.length) {
            steps[0] = resp[1] & 0xFF;
            steps[1] = resp[2] & 0xFF;
        } else {
            steps[1] = 0;
            steps[0] = 0;
        }
    }

    public synchronized void calConfig(int gain, int polarity, int path) throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(19), (byte)gain, (byte)polarity, (byte)path};
        this.usb.write(cmnd);
    }

    public synchronized void calibrate(int type) throws MccUsbException, UsbException {
        byte[] byArray = new byte[3];
        byArray[0] = this.getCmnd(17);
        byArray[1] = (byte)type;
        byte[] cmnd = byArray;
        this.usb.write(cmnd);
    }

    public synchronized int getStatus() throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(14)};
        byte[] resp = new byte[2];
        this.usb.write(cmnd);
        int leng = this.usb.read(resp, 500);
        return leng == resp.length ? resp[1] & 0xFF : -1;
    }

    public synchronized int getBurnout(int mask) throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(18), (byte)mask};
        byte[] resp = new byte[2];
        this.usb.write(cmnd, 0, 1);
        int leng = this.usb.read(resp, 500);
        if (leng == resp.length) {
            this.usb.write(cmnd);
            return resp[1] & 0xFF;
        }
        return 0;
    }

    public synchronized int readMemory(int addr, int type, int count, byte[] data) throws MccUsbException, UsbException {
        if (count > 62 && type == 0) {
            count = 62;
        } else if (count > 60 && type != 0) {
            count = 60;
        }
        byte[] byArray = new byte[5];
        byArray[0] = this.getCmnd(10);
        byArray[3] = (byte)type;
        byArray[4] = (byte)count;
        byte[] cmnd = byArray;
        byte[] resp = new byte[count + 1];
        Convert.shortToBytes((short)((short)addr), (byte[])cmnd, (int)1);
        this.usb.write(cmnd);
        int leng = this.usb.read(resp, 500) - 1;
        System.arraycopy(resp, 1, data, 0, leng);
        return leng;
    }

    public synchronized int writeMemory(int addr, int type, int count, byte[] data) throws MccUsbException, UsbException {
        byte code = this.getCmnd(10);
        if (count > 59) {
            count = 59;
        }
        if (addr + count > 255) {
            return 0;
        }
        byte[] cmnd = new byte[count + 5];
        cmnd[0] = code;
        Convert.shortToBytes((short)((short)addr), (byte[])cmnd, (int)1);
        cmnd[3] = (byte)type;
        cmnd[4] = (byte)count;
        System.arraycopy(data, 0, cmnd, 5, count);
        return this.usb.write(cmnd) - 5;
    }

    public synchronized void writeSerial(String serial) throws MccUsbException, UsbException {
        byte[] cmnd = new byte[9];
        cmnd[0] = this.getCmnd(23);
        byte[] bSerial = serial.getBytes();
        int j = 1;
        while (j < cmnd.length) {
            cmnd[j] = j <= bSerial.length ? bSerial[j - 1] : 32;
            ++j;
        }
        this.usb.write(cmnd);
    }

    public synchronized void prepareDownload(int code, int micro) throws MccUsbException, UsbException {
        byte[] cmnd = new byte[]{this.getCmnd(21), (byte)code, (byte)micro};
        this.usb.write(cmnd);
    }

    public synchronized void writeCode(int addr, int count, byte[] data) throws MccUsbException, UsbException {
        byte[] cmnd = new byte[37];
        cmnd[0] = this.getCmnd(22);
        Convert.intToBytes((int)addr, (byte[])cmnd, (int)1);
        if ((count &= 0xFF) > 32) {
            count = 32;
        }
        cmnd[4] = (byte)count;
        System.arraycopy(data, 0, cmnd, 5, count);
        this.usb.write(cmnd, 0, count + 5);
    }

    public synchronized int readCode(int addr, int count, byte[] data) throws MccUsbException, UsbException {
        byte[] byArray = new byte[5];
        byArray[0] = this.getCmnd(24);
        byte[] cmnd = byArray;
        byte[] resp = new byte[63];
        Convert.intToBytes((int)addr, (byte[])cmnd, (int)1);
        if ((count &= 0xFF) > 62) {
            count = 62;
        }
        cmnd[4] = (byte)count;
        this.usb.write(cmnd);
        int leng = this.usb.read(resp, 500) - 1;
        System.arraycopy(resp, 1, data, 0, count);
        return leng;
    }

    private byte getCmnd(int opcode) throws MccUsbException {
        if (this.devId < 0) {
            throw new MccUsbException("No device connection open");
        }
        Operation oper = opern[opcode];
        if ((oper.mask >> this.devId & 1) == 0) {
            throw new UnsupportedOperationException();
        }
        return oper.cmnd;
    }

    private static class Operation {
        byte cmnd;
        int mask;

        Operation(byte cmnd, int ... devs) {
            this.cmnd = cmnd;
            this.mask = 0;
            int j = 0;
            while (j < devs.length) {
                this.mask |= 1 << devs[j];
                ++j;
            }
        }
    }
}

