/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.refrig.ColdCompressor;
import org.lsst.ccs.subsystem.refrig.CryoCompressor;
import org.lsst.ccs.subsystem.refrig.data.RefrigAction;

public class RefrigActionManager
implements HasLifecycle,
AlertListener {
    private static final Logger LOG = Logger.getLogger(RefrigActionManager.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, ColdCompressor> coldComps = new HashMap<String, ColdCompressor>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private final Map<String, CryoCompressor> cryoComps = new HashMap<String, CryoCompressor>();
    private final Map<String, Set<String>>[] active = new Map[RefrigAction.Action.values().length];

    public RefrigActionManager() {
        for (int j = 0; j < this.active.length; ++j) {
            this.active[j] = new HashMap<String, Set<String>>();
        }
    }

    public void build() {
        this.active[RefrigAction.Action.STOP_ALL_COLD_COMPS.ordinal()].put("", new ConcurrentSkipListSet());
        for (String name : this.coldComps.keySet()) {
            this.active[RefrigAction.Action.STOP_COLD_COMP.ordinal()].put(name, new ConcurrentSkipListSet());
        }
        this.active[RefrigAction.Action.STOP_ALL_CRYO_COMPS.ordinal()].put("", new ConcurrentSkipListSet());
        for (String name : this.cryoComps.keySet()) {
            this.active[RefrigAction.Action.STOP_CRYO_COMP.ordinal()].put(name, new ConcurrentSkipListSet());
        }
    }

    public void init() {
        this.propertiesService.setAgentProperty(RefrigAction.getManagerName(), "");
        this.alertService.startStatusAlertListening(info -> info.hasAgentProperty(RefrigAction.getClientName()));
    }

    public void start() {
        this.alertService.addListener((AlertListener)this);
    }

    public void shutdown() {
        this.alertService.removeListener((AlertListener)this);
    }

    public void onAlert(AlertEvent event) {
        String origin = event.getSource();
        switch (event.getType()) {
            case AGENT_CONNECTION: {
                LOG.log(Level.INFO, "Connected to agent {0}, a source of alerts with payload {1}", new Object[]{origin, RefrigAction.getName()});
                for (RaisedAlertHistory alertHistory : event.getSummary().getAllRaisedAlertHistories()) {
                    this.processAlert(origin, alertHistory.getLatestAlert(), alertHistory.getLatestAlertState());
                }
                break;
            }
            case AGENT_DISCONNECTION: {
                LOG.log(Level.INFO, "Disconnected from agent {0}, a source of alerts with payload {1}", new Object[]{origin, RefrigAction.getName()});
                for (RefrigAction.Action action : RefrigAction.Action.values()) {
                    for (Map.Entry<String, Set<String>> entry : this.active[action.ordinal()].entrySet()) {
                        if (!entry.getValue().remove(origin) || !entry.getValue().isEmpty()) continue;
                        this.performAction(action, entry.getKey(), false);
                    }
                }
                break;
            }
            case ALERT_RAISED: {
                this.processAlert(origin, event.getAlert(), event.getLevel());
            }
        }
    }

    private synchronized void processAlert(String origin, Alert alert, AlertState state) {
        RefrigAction action = RefrigAction.getData((Alert)alert);
        if (action != null) {
            boolean on;
            LOG.log(Level.INFO, "Received {0} level alert from {1}: action = ({2}, {3})", new Object[]{state, origin, action.action, action.compName});
            Set<String> orgSet = this.active[action.action.ordinal()].get(action.compName);
            if (orgSet == null) {
                return;
            }
            boolean bl = on = state == AlertState.ALARM;
            if (on) {
                orgSet.add(origin);
            } else {
                orgSet.remove(origin);
                if (!orgSet.isEmpty()) {
                    return;
                }
            }
            this.performAction(action.action, action.compName, on);
        }
    }

    private void performAction(RefrigAction.Action action, String compName, boolean on) {
        switch (action) {
            case STOP_ALL_COLD_COMPS: {
                for (String name : this.coldComps.keySet()) {
                    if (!on && !this.active[RefrigAction.Action.STOP_COLD_COMP.ordinal()].get(name).isEmpty()) continue;
                    this.coldComps.get(name).setPlateTempLow(on);
                }
                break;
            }
            case STOP_COLD_COMP: {
                if (!on && !this.active[RefrigAction.Action.STOP_ALL_COLD_COMPS.ordinal()].get("").isEmpty()) break;
                this.coldComps.get(compName).setPlateTempLow(on);
                break;
            }
            case STOP_ALL_CRYO_COMPS: {
                for (String name : this.cryoComps.keySet()) {
                    if (!on && !this.active[RefrigAction.Action.STOP_CRYO_COMP.ordinal()].get(name).isEmpty()) continue;
                    this.cryoComps.get(name).setPlateTempLow(on);
                }
                break;
            }
            case STOP_CRYO_COMP: {
                if (!on && !this.active[RefrigAction.Action.STOP_ALL_CRYO_COMPS.ordinal()].get("").isEmpty()) break;
                this.cryoComps.get(compName).setPlateTempLow(on);
            }
        }
    }
}

