import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.bootstrap.BootstrapResourceUtils
import org.lsst.ccs.subsystem.refrig.HexMain
import org.lsst.ccs.subsystem.refrig.RefrigActionClient
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device
import org.lsst.ccs.subsystem.refrig.SimMaq20Device
import org.lsst.ccs.monitor.Channel
import org.lsst.ccs.services.AgentStatusAggregatorService;

Properties props = BootstrapResourceUtils.getBootstrapSystemProperties()

runMode = props.getProperty("org.lsst.ccs.run.mode", "normal")
if (runMode.equals("simulation")) {
    maq20Device = SimMaq20Device
    thermalSubsys = "thermal-sim"
}
else {
    maq20Device = Maq20Device
    thermalSubsys = "thermal"
} 

maq20 = "Maq20"
pOffset500 = -125.0;
pScale500 = 31250.0
pOffset750 = -187.5
pScale750 = 46875.0

CCSBuilder builder = ["hex"]

builder.main (HexMain, coldTempChans: ["Cold1/EvapExitTmp", "Cold2/EvapExitTmp"],
                       cryoTempChans: ["Cryo1/EvapExitTmp", "Cryo2/EvapExitTmp", "Cryo3/EvapExitTmp",
                                       "Cryo4/EvapExitTmp", "Cryo5/EvapExitTmp", "Cryo6/EvapExitTmp"]) {

    ActionClient (RefrigActionClient)

    statusAggregator (AgentStatusAggregatorService)    
    
    "$maq20"  (maq20Device, modules: ["RTD", "RTD", "RTD", "RTD", "RTD", "RTD", "RTD", "IS", "IS", "RTD"])

    "Cold1/PreExpnTmp"  (Channel, description: "Pre Expn Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "6", subtype: "R200")

    "Cold1/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "6", subtype: "R200")

    "Cold2/PreExpnTmp"  (Channel, description: "Pre Expn Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "6", subtype: "R200")

    "Cold2/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "6", subtype: "R200")

    "Cryo5/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "4", subtype: "R200")

    "Cryo5/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "4", subtype: "R200")

    "Cryo5/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "4", subtype: "R200")

    "Cryo5/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "4", subtype: "R200")

    "Cryo5/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "4", subtype: "R200")

    "Cryo5/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "4", subtype: "R200")

    "Cryo5/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 12, type: "7", subtype: "MA4_20", offset: pOffset750, scale: pScale750)

    "Cryo5/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 13, type: "7", subtype: "MA4_20", offset: pOffset750, scale: pScale750)

    "Cryo5/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 14, type: "7", subtype: "MA4_20", offset: pOffset500, scale: pScale500)

    "Cryo6/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "5", subtype: "R200")

    "Cryo6/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "5", subtype: "R200")

    "Cryo6/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "5", subtype: "R200")

    "Cryo6/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "5", subtype: "R200")

    "Cryo6/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "5", subtype: "R200")

    "Cryo6/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "5", subtype: "R200")

    "Cryo6/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 15, type: "7", subtype: "MA4_20", offset: pOffset750, scale: pScale750)

    "Cryo6/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "8", subtype: "MA4_20", offset: pOffset750, scale: pScale750)

    "Cryo6/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "8", subtype: "MA4_20", offset: pOffset500, scale: pScale500)

    "Cryo4/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "3", subtype: "R200")

    "Cryo4/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "3", subtype: "R200")

    "Cryo4/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "3", subtype: "R200")

    "Cryo4/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "3", subtype: "R200")

    "Cryo4/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "3", subtype: "R200")

    "Cryo4/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "3", subtype: "R200")

    "Cryo4/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 9, type: "7", subtype: "MA4_20", offset: pOffset750, scale: pScale750)

    "Cryo4/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 10, type: "7", subtype: "MA4_20", offset: pOffset750, scale: pScale750)

    "Cryo4/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 11, type: "7", subtype: "MA4_20", offset: pOffset500, scale: pScale500)

    "Cryo3/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "2", subtype: "R200")

    "Cryo3/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "2", subtype: "R200")

    "Cryo3/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "2", subtype: "R200")

    "Cryo3/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "2", subtype: "R200")

    "Cryo3/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "2", subtype: "R200")

    "Cryo3/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "2", subtype: "R200")

    "Cryo3/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 6, type: "7", subtype: "MA4_20", offset: pOffset750, scale: pScale750)

    "Cryo3/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 7, type: "7", subtype: "MA4_20", offset: pOffset750, scale: pScale750)

    "Cryo3/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 8, type: "7", subtype: "MA4_20", offset: pOffset500, scale: pScale500)

    "Cryo2/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "1", subtype: "R200")

    "Cryo2/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "1", subtype: "R200")

    "Cryo2/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "1", subtype: "R200")

    "Cryo2/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "1", subtype: "R200")

    "Cryo2/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "1", subtype: "R200")

    "Cryo2/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "1", subtype: "R200")

    "Cryo2/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "7", subtype: "MA4_20", offset: pOffset750, scale: pScale750)

    "Cryo2/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "7", subtype: "MA4_20", offset: pOffset750, scale: pScale750)

    "Cryo2/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "7", subtype: "MA4_20", offset: pOffset500, scale: pScale500)

    "Cryo1/C3ExitTmp"   (Channel, description: "C3 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "0", subtype: "R200")

    "Cryo1/PreC3Tmp"    (Channel, description: "Pre C3 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "0", subtype: "R200")

    "Cryo1/PreC4Tmp"    (Channel, description: "Pre C4 Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "0", subtype: "R200")

    "Cryo1/C4ExitTmp"   (Channel, description: "C4 Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 3, type: "0", subtype: "R200")

    "Cryo1/EvapExitTmp" (Channel, description: "Evap Exit Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 4, type: "0", subtype: "R200")

    "Cryo1/HexRtrnTmp"  (Channel, description: "HX Return Temperature", units: "\u00b0C", format: ".1f",
                         devcName: maq20, hwChan: 5, type: "0", subtype: "R200")

    "Cryo1/VaporPrs"    (Channel, description: "Vapor Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 0, type: "7", subtype: "MA4_20", offset: pOffset750, scale: pScale750)

    "Cryo1/LiquidPrs"   (Channel, description: "Liquid Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 1, type: "7", subtype: "MA4_20", offset: pOffset750, scale: pScale750)

    "Cryo1/ReturnPrs"   (Channel, description: "Return Pressure", units: "psia", format: ".1f",
                         devcName: maq20, hwChan: 2, type: "7", subtype: "MA4_20", offset: pOffset500, scale: pScale500)

}
