package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.drivers.commons.DriverException;

/**
 *  Simulates the PCP power device.
 *
 *  @author saxton
 */
public class SimPcpPowerDevice extends PcpPowerDevice {

    /**
     *  Start phase - set heater voltages to zero.
     */
    @Override
    public void start()
    {
        for (int chan = 0; chan < NUM_CHANS; chan++) {
            try {
                setOutput(chan, false);
                setVoltage(chan, 0.0);
                setCurrent(chan, 0.0);
            }
            catch (DriverException e) {}
        }
    }

    /**
     *  Sets the output state.
     *
     *  @param  chan   The hardware channel
     *  @param  value  The output state to set, true or false
     *  @throws  DriverException
     */
    @Override
    public void setOutput(int chan, boolean value) throws DriverException
    {
        super.setOutput(chan, value);
        ((SimPcpPowerControl)controls[chan]).setOutput(value);
    }

}
