package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20DiscControl;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

/**
 *  Handles chiller Maq20 DIOL control of chiller cabinet lights
 *
 *  @author the CCS team
 */
public class ChillerMaq20Device extends Maq20Device {

    public enum LightNumber {
        LIGHT1 (0, "DIOL channel for light 1"),
        LIGHT2 (1, "DIOL channel for light 2");

        private int channel;
        private String descr;

        LightNumber (int channel, String descr) {
            this.channel = channel;
            this.descr = descr;
        }

	public int getChannel() {return channel;}
        public String getDescr() {return descr;}
    }

    /**
     *  Constants.
     */

    //  public static final int 

    /**
     *  Data fields.
     */
    @LookupField(strategy = LookupField.Strategy.CHILDREN)
    private Maq20DiscControl discCtrl;
    
    private static final Logger LOG = Logger.getLogger(ChillerMaq20Device.class.getName());

   /**
    *  Performs basic initialization.
    */
    @Override
    protected void initDevice() {
        super.initDevice();
        if (discCtrl == null) {
            ErrorUtils.reportConfigError(LOG, name, "MAQ20 discrete control", "not defined");
        }
    }

    /**
     *  Sets a light on or off.
     *
     *  @param  LightNumber light   The enumerated light number.
     *  @param  boolean on          The on state to set: true or false
     *  @throws  RefrigException
     */
    public void setLightOn(LightNumber light, boolean on) throws DriverException
    {
        discCtrl.setLineOn(light.getChannel(), on);
    }

    /**
     *  Gets the on state of a light.
     *
     *  @param  LightNumber light   The enumerated light number.
     *  @return Boolean             Whether the light is on
     */
    public Boolean isLightOn(LightNumber light)
    {
        return discCtrl.isLineOn(light.getChannel());
    }

}
