/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ccs;

import org.jgroups.Address;
import org.jgroups.PhysicalAddress;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.NameCache;
import org.jgroups.util.UUID;

public class CCSUtil {
    public static String toString(Address address) {
        if (address == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(address.getClass().getSimpleName());
        if (address instanceof PhysicalAddress) {
            sb.append(" ip=").append(((PhysicalAddress)address).printIpAddress());
        } else if (address instanceof UUID) {
            String name = NameCache.get(address);
            if (name != null) {
                sb.append(" ").append(name);
            }
            sb.append(" uuid=").append(((UUID)address).toStringLong());
        }
        return sb.toString();
    }

    public static boolean isValid(PhysicalAddress address) {
        if (address instanceof IpAddress) {
            IpAddress a = (IpAddress)address;
            return a.getIpAddress() != null && a.getPort() > 0;
        }
        return false;
    }
}

