/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.agilent;

import java.util.Arrays;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class E3631
extends Ascii {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private final String terminator = "\r\n";
    private int timeout = 1000;
    private Boolean verbose = true;
    private Boolean fakeout = false;

    public void open(String serialname, int port) throws DriverException {
        int asciiParam = E3631.makeDataCharacteristics((Ascii.DataBits)Ascii.DataBits.EIGHT, (Ascii.StopBits)Ascii.StopBits.TWO, (Ascii.Parity)Ascii.Parity.NONE, (Ascii.FlowCtrl)Ascii.FlowCtrl.NONE);
        this.open(DriverConstants.ConnType.SERIAL, serialname, port, asciiParam);
        this.init();
        this.writeE3631("SYST:REM");
    }

    public void openftdi(String serialname, int baud) throws DriverException {
        System.out.println("opening connection to the Agilent E3631 Power Supply");
        int asciiParam = E3631.makeDataCharacteristics((Ascii.DataBits)Ascii.DataBits.EIGHT, (Ascii.StopBits)Ascii.StopBits.TWO, (Ascii.Parity)Ascii.Parity.NONE, (Ascii.FlowCtrl)Ascii.FlowCtrl.NONE);
        this.open(DriverConstants.ConnType.FTDI, serialname, baud, asciiParam);
        this.writeE3631("SYST:REM");
    }

    public void init() throws DriverException {
    }

    public void close() throws DriverException {
    }

    public void setFakeout(Boolean f) throws DriverException {
        this.fakeout = f;
    }

    public void setVerbose(Boolean v) throws DriverException {
        this.verbose = v;
    }

    public void selectOutput(String outname) throws DriverException {
        if (!Arrays.asList("P6V", "P25V", "N25V").contains(outname)) {
            String errstr = "E3631 selectOutput: Invalid output specified:" + outname;
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        try {
            this.sendCommand("INST:SEL " + outname);
        }
        catch (DriverException e) {
            String errstr = "E3631 selectOutput: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public String getOutput() throws DriverException {
        try {
            String outstr = this.getReply("INST:SEL?");
            return outstr;
        }
        catch (DriverException e) {
            String errstr = "E3631 gettOutput:" + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void outputOn(String outname) throws DriverException {
        try {
            this.selectOutput(outname);
            this.sendCommand("OUTPUT:STATE ON ");
        }
        catch (DriverException e) {
            String errstr = "E3631 outputOn: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void outputOff(String outname) throws DriverException {
        try {
            this.selectOutput(outname);
            this.sendCommand("OUTPUT:STATE OFF ");
        }
        catch (DriverException e) {
            String errstr = "E3631 outputOn: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public double getVoltage() throws DriverException {
        try {
            String voltstr = this.readE3631("MEAS:VOLT:DC?");
            return Double.valueOf(voltstr);
        }
        catch (DriverException e) {
            String errstr = "E3631 getVoltage: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public double getVoltage(String outname) throws DriverException {
        try {
            this.selectOutput(outname);
            Thread.sleep(800L);
            String voltstr = this.getReply("MEAS:VOLT:DC? " + outname);
            return Double.valueOf(voltstr);
        }
        catch (DriverException e) {
            String errstr = "E3631 getVoltage: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        catch (InterruptedException e) {
            throw new DriverException();
        }
    }

    public double getCurrent() throws DriverException {
        try {
            String ampstr = this.readE3631("MEAS:CURR:DC?");
            return Double.valueOf(ampstr);
        }
        catch (DriverException e) {
            String errstr = "E3631 getCurrent: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public double getCurrent(String outname) throws DriverException {
        try {
            this.selectOutput(outname);
            Thread.sleep(800L);
            String ampstr = this.getReply("MEAS:CURR:DC? " + outname);
            return Double.valueOf(ampstr);
        }
        catch (DriverException e) {
            String errstr = "E3631 getCurrent: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        catch (InterruptedException e) {
            throw new DriverException();
        }
    }

    public void setVoltage(String outname, double volts) throws DriverException {
        if (this.fakeout.booleanValue()) {
            System.out.println("E3631 setVoltage: outname = " + outname);
            System.out.println("E3631 setVoltage: volts   = " + volts);
            return;
        }
        Boolean voltageError = false;
        switch (outname) {
            case "P6V": {
                if (!(volts < 0.0) && !(volts > 6.0)) break;
                voltageError = true;
                break;
            }
            case "P25V": {
                if (!(volts < 0.0) && !(volts > 25.0)) break;
                voltageError = true;
                break;
            }
            case "N25V": {
                if (!(volts > 0.0) && !(volts < -25.0)) break;
                voltageError = true;
                break;
            }
            default: {
                String errstr = "E3631 setVoltage: output name error";
                System.out.println(errstr);
                throw new DriverException(errstr);
            }
        }
        if (voltageError.booleanValue()) {
            String errstr = "E3631 setVoltage: voltage error";
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        try {
            this.selectOutput(outname);
            Thread.sleep(800L);
            this.sendCommand("VOLT:DC " + volts);
        }
        catch (DriverException e) {
            String errstr = "E3631 setVoltage: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        catch (InterruptedException e) {
            throw new DriverException();
        }
    }

    public void setCurrent(String outname, double amps) throws DriverException {
        if (this.fakeout.booleanValue()) {
            System.out.println("E3631 setCurrent: outname = " + outname + "amps =" + amps);
            return;
        }
        Boolean currentError = false;
        switch (outname) {
            case "P6V": {
                if (!(amps < 0.0) && !(amps > 6.0)) break;
                currentError = true;
                break;
            }
            case "P25V": {
                if (!(amps < 0.0) && !(amps > 1.0)) break;
                currentError = true;
                break;
            }
            case "N25V": {
                if (!(amps < 0.0) && !(amps > 1.0)) break;
                currentError = true;
                break;
            }
            default: {
                String errstr = "E3631 setCurrent: output name error";
                System.out.println(errstr);
                throw new DriverException(errstr);
            }
        }
        if (!currentError.booleanValue()) {
            String errstr = "E3631 setCurrent: current error";
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        try {
            this.selectOutput(outname);
            Thread.sleep(800L);
            this.sendCommand("CURR:DC " + amps);
        }
        catch (DriverException e) {
            String errstr = "E3631 setCurrent: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        catch (InterruptedException e) {
            throw new DriverException();
        }
    }

    public String getID() throws DriverException {
        try {
            String idString = this.readE3631("*IDN?");
            if (this.verbose.booleanValue()) {
                System.out.println("E3631 ID: " + idString);
            }
            return idString;
        }
        catch (DriverException e) {
            String errstr = "E3631 getID: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public String getError() throws DriverException {
        try {
            String errString = this.readE3631("ERR");
            if (this.verbose.booleanValue()) {
                System.out.println("E3631 ID: " + errString);
            }
            return errString;
        }
        catch (DriverException e) {
            String errstr = "E3631 getError: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void reset() throws DriverException {
        try {
            this.writeE3631("*RST");
        }
        catch (DriverException e) {
            String errstr = "E3631 reset: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public synchronized void sendCommand(String command) throws DriverException {
        if (this.verbose.booleanValue()) {
            System.out.println("E3631Command: " + command);
        }
        this.writeE3631(command);
    }

    public synchronized String getReply(String command) throws DriverException {
        if (this.verbose.booleanValue()) {
            System.out.println("E3631 getReply: " + command);
        }
        this.writeE3631(command);
        String reply = this.readE3631();
        return reply;
    }

    public void setTimeout(int timeout) throws DriverException {
        this.timeout = timeout;
    }

    public synchronized void writeE3631(String command) throws DriverException {
        this.write(command);
    }

    public synchronized String readE3631() throws DriverException {
        return this.read();
    }

    public synchronized String readE3631(String command) throws DriverException {
        this.writeE3631(command);
        return this.readE3631();
    }

    public static enum OutputName {
        P6V("P6V"),
        P25V("P25V"),
        N25V("N25V");

        String value;

        private OutputName(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

