/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorUpdateTask;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.refrig.InTESTChillerDevice;
import org.lsst.ccs.subsystem.refrig.constants.ChillerAlerts;
import org.lsst.ccs.subsystem.refrig.constants.ChillerState;
import org.lsst.ccs.subsystem.refrig.data.ChillerControlState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class ChillerSubsystem
extends Subsystem
implements HasLifecycle,
StatusMessageListener,
AgentPresenceListener {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private InTESTChillerDevice devChiller;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Monitor mon;
    @LookupName
    private String name;
    @ConfigurationParameter(isFinal=true, description="Require listening to thermal subsystem or equivalent for Normal mode", units="unitless")
    protected volatile boolean requireListening;
    @ConfigurationParameter(isFinal=true, description="Which refrig subsystem to listen to (RefrigAgentProperties)", units="unitless")
    protected volatile String listenTo;
    @ConfigurationParameter(isFinal=true, description="path of coldplate temperature Channel to listen for", units="unitless")
    protected volatile String coldplateChannelPath;
    @ConfigurationParameter(description="Factor on temperature-setting timeout", range="1.0..1.4", units="unitless")
    protected volatile double temperatureTimeoutFactor;
    private static final Logger LOG = Logger.getLogger(ChillerSubsystem.class.getName());
    private static final double rampCorrection = -0.04;
    private final Object listeningLock = new Object();
    private volatile boolean isListeningToThermal = false;
    private volatile String thermalName = null;
    private volatile boolean setTempInProgress = false;
    private volatile boolean setFlowInProgress = false;
    private volatile String refrigAgentProperty;
    private boolean listenAlarm = false;
    private Channel chanFlow;
    private MonitorUpdateTask taskFlow;
    private Channel chanFlowSet;
    private Channel chanTempSet;
    private Channel chanTankSet;
    private volatile CCSTimeStamp timeLastData;
    private volatile AlertState lastDataAlert = AlertState.NOMINAL;
    private Thread checkTemp;
    private Thread checkFlow;
    private static final Duration intervalCheckTemp = Duration.ofSeconds(30L);
    private static final Duration intervalCheckFlow = Duration.ofSeconds(5L);
    private static final Duration setFlowTimeout = Duration.ofSeconds(45L);
    private static final double flowTolerance = 0.1;
    private AgentPeriodicTask checkDataArrival;
    private static final Duration periodCheckData = Duration.ofMillis(500L);
    private static long timeDataWarning = 3000L;
    private static long timeDataAlarm = 20000L;
    private AgentPeriodicTask updateCtrlState;
    private static final int UPDATE_CONTROL_INTVL = 1000;
    private AgentPeriodicTask sendDUTTemperature;
    private static final Duration periodDUT = Duration.ofMillis(1000L);
    private MonitorTaskControl monitorControl;
    private final ChillerControlState controlState = new ChillerControlState();
    private boolean gotCommand;

    public ChillerSubsystem() {
        super("chiller", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        this.updateCtrlState = new AgentPeriodicTask("updateCtrlState", () -> this.updateControlState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(this.updateCtrlState);
        Runnable checkData = new Runnable(){

            @Override
            public void run() {
                long dt = System.currentTimeMillis() - ChillerSubsystem.this.timeLastData.getUTCInstant().toEpochMilli();
                AlertState dataAlert = dt <= timeDataWarning ? AlertState.NOMINAL : (dt <= timeDataAlarm ? AlertState.WARNING : AlertState.ALARM);
                if (ChillerSubsystem.this.requireListening && dataAlert != ChillerSubsystem.this.lastDataAlert) {
                    ChillerSubsystem.this.alertService.raiseAlert(ChillerAlerts.MISSING_THERMAL.newAlert(), dataAlert, "time since last data = " + Long.toString(dt) + " ms");
                    ChillerSubsystem.this.lastDataAlert = dataAlert;
                }
            }
        };
        this.checkDataArrival = new AgentPeriodicTask("checkDataArrival", checkData).withPeriod(periodCheckData);
        this.periodicTaskService.scheduleAgentPeriodicTask(this.checkDataArrival);
        Runnable sendDUT = new Runnable(){

            @Override
            public void run() {
                if (ChillerSubsystem.this.devChiller.getTempControlMode()) {
                    ChillerSubsystem.this.devChiller.sendDUTData();
                }
            }
        };
        this.sendDUTTemperature = new AgentPeriodicTask("sendDutTemperature", sendDUT).withPeriod(periodDUT);
        this.periodicTaskService.scheduleAgentPeriodicTask(this.sendDUTTemperature);
    }

    public void init() {
        ClearAlertHandler chillerClearAlertHandler = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                String alertId = alert.getAlertId();
                if (alertId.equals(ChillerAlerts.TEMP_TIMEOUT.getId()) || alertId.equals(ChillerAlerts.FLOW_TIMEOUT.getId())) {
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
            }
        };
        this.propertiesService.setAgentProperty("chillerType", ChillerSubsystem.class.getCanonicalName());
        this.alertService.registerAlert(ChillerAlerts.TEMP_TIMEOUT.newAlert(), chillerClearAlertHandler);
        this.alertService.registerAlert(ChillerAlerts.FLOW_TIMEOUT.newAlert(), chillerClearAlertHandler);
        this.alertService.registerAlert(ChillerAlerts.LOST_LISTENED.newAlert());
        this.alertService.registerAlert(ChillerAlerts.MISSING_THERMAL.newAlert());
        this.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        List listTasks = this.mon.getMonitorUpdateTasksForDevice((Device)this.devChiller);
        for (MonitorUpdateTask task : listTasks) {
            List chanList = task.getAllChannels();
            for (Channel ch : chanList) {
                if (this.chanFlow == null && ch.getSubTypeStr().equals("FLOW_RATE")) {
                    this.chanFlow = ch;
                    this.taskFlow = task;
                    continue;
                }
                if (this.chanFlowSet == null && ch.getSubTypeStr().equals("FLOW_SETPT")) {
                    this.chanFlowSet = ch;
                    continue;
                }
                if (this.chanTempSet == null && ch.getSubTypeStr().equals("SET_POINT")) {
                    this.chanTempSet = ch;
                    continue;
                }
                if (this.chanTankSet != null || !ch.getSubTypeStr().equals("TANK_P_SET")) continue;
                this.chanTankSet = ch;
            }
        }
        if (this.taskFlow == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"taskFlow", (String)"no update task found with Channel subtype FLOW_RATE");
        }
        this.timeLastData = CCSTimeStamp.currentTime();
    }

    public void postStart() {
        this.checkTemp = new Thread("dummyT"){};
        this.checkFlow = new Thread("dummyF"){};
    }

    public void shutdown() {
        this.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
    }

    @ConfigurationParameterChanger(propertyName="listenTo")
    public void setListenTo(String value) {
        if (value.toLowerCase().equals("thermal")) {
            this.refrigAgentProperty = "thermalType";
            this.listenTo = value;
        } else if (value.toLowerCase().equals("pcp")) {
            this.refrigAgentProperty = "pcpType";
            this.listenTo = value;
        } else {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"listenTo", (String)"Must specify either Thermal or Pcp subsystem");
        }
    }

    public String vetoTransitionToNormalMode() {
        String reply = "";
        if (this.stateService.getState(ChillerState.class) != ChillerState.SETPOINT) {
            reply = reply + "Chiller not controlling at setpoint  ";
        }
        if (this.requireListening && !this.isListeningToThermal) {
            reply = reply + "Chiller is not listening to Thermal";
        }
        return reply.equals("") ? null : reply;
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="setTemperature", autoAck=false, description="go to temperature setting using default ramp")
    public void setTemperature(@Argument(description="tempeature in degrees") double temperature) throws DriverException {
        this.helper().precondition(this.devChiller.getLastErrorAlert() != AlertState.ALARM, "operation blocked due to Chiller Error", new Object[0]).precondition(!this.setTempInProgress, "Previous set command in progress, quitControllingTemperature must be issued first", new Object[0]).action(() -> {
            this.gotCommand = true;
            double ramp = Double.parseDouble(this.devChiller.readParameter(37));
            this.devChiller.setTemperature(temperature);
            this.setTempInProgress = true;
            this.waitForTemp(temperature, ramp);
        });
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="setTemperatureWithRamp", autoAck=false, description="go to temperature setting using provided ramp")
    public void setTemperatureWithRamp(@Argument(description="tempeature in degrees") double temperature, @Argument(description="ramp in degrees/min") double ramp) throws DriverException {
        this.helper().precondition(this.devChiller.getLastErrorAlert() != AlertState.ALARM, "operation blocked due to Chiller Error", new Object[0]).precondition(!this.setTempInProgress, "Previous set command in progress, quitControllingTemperature must be issued first", new Object[0]).action(() -> {
            this.gotCommand = true;
            this.devChiller.setTemperatureWithRamp(temperature, ramp);
            this.setTempInProgress = true;
            this.waitForTemp(temperature, ramp);
        });
    }

    private void waitForTemp(double temp, double ramp) throws DriverException {
        Double currentTemp = this.mon.getChannelValue("Chiller/FluidTemperature");
        final long timeEst = Math.round(60.0 * Math.abs(currentTemp - temp) / (ramp + -0.04));
        LOG.info("Initiating temperature change to " + Double.toString(temp) + " deg, estimated duration " + Double.toString(timeEst) + " seconds.");
        this.checkTemp = new Thread("checkTemp"){

            @Override
            public void run() {
                block3: {
                    long timeStart = System.currentTimeMillis();
                    long timeout = Math.round(ChillerSubsystem.this.temperatureTimeoutFactor * 1000.0 * (double)timeEst);
                    do {
                        try {
                            Thread.sleep(intervalCheckTemp.toMillis());
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException("Unexpected interrupt while waiting for requested temperature", ex);
                        }
                        if (ChillerSubsystem.this.stateService.getState(ChillerState.class) != ChillerState.SETPOINT) continue;
                        ChillerSubsystem.this.setTempInProgress = false;
                        LOG.info("Chiller temperature is at requested setpoint");
                        break block3;
                    } while (System.currentTimeMillis() - timeStart <= timeout);
                    ChillerSubsystem.this.alertService.raiseAlert(ChillerAlerts.TEMP_TIMEOUT.newAlert(), AlertState.ALARM, "Set temperature timed out at " + Long.toString(timeout / 1000L) + " s");
                    ChillerSubsystem.this.setTempInProgress = false;
                }
            }
        };
        this.checkTemp.setDaemon(true);
        this.checkTemp.start();
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="quitControllingTemperature", description="stop controlling temperature")
    public void quitControllingTemperature() throws DriverException {
        this.devChiller.quitControllingTemperature();
        this.setTempInProgress = false;
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="setFlow", description="set flow rate of chilled fluid")
    public String setFlow(final @Argument(description="flow rate in gpm") double flow) throws DriverException {
        this.gotCommand = true;
        this.devChiller.setFlow(flow);
        ChillerState state = (ChillerState)this.stateService.getState(ChillerState.class);
        if (state != ChillerState.SETPOINT && state != ChillerState.CONTROLLING) {
            return "Chiller pumps are off, but flow setpoint has been set";
        }
        this.setFlowInProgress = true;
        this.checkFlow = new Thread("checkFlow"){

            @Override
            public void run() {
                block3: {
                    long timeStart = System.currentTimeMillis();
                    long timeout = setFlowTimeout.toMillis();
                    ChillerSubsystem.this.taskFlow.forceDataPublicationForDuration(setFlowTimeout);
                    do {
                        try {
                            Thread.sleep(intervalCheckFlow.toMillis());
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException("Unexpected interrupt while waiting for requested flow", ex);
                        }
                        if (!(Math.abs(ChillerSubsystem.this.chanFlow.getValue() - flow) < 0.1)) continue;
                        LOG.info("Chiller flpw is at requested setpoint");
                        ChillerSubsystem.this.taskFlow.resetForcedDataPublication();
                        break block3;
                    } while (System.currentTimeMillis() - timeStart <= timeout);
                    ChillerSubsystem.this.alertService.raiseAlert(ChillerAlerts.FLOW_TIMEOUT.newAlert(), AlertState.ALARM, "Set flow timed out at " + Long.toString(timeout / 1000L) + " s");
                }
                ChillerSubsystem.this.setFlowInProgress = false;
            }
        };
        this.checkFlow.setDaemon(true);
        this.checkFlow.start();
        return "Chilled fluid flow setting initiated";
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="setTankPressure", description="Set tank pressure in psig")
    public void setTankPressure(@Argument(description="Tank pressure set value in psig") double value) throws DriverException {
        this.gotCommand = true;
        this.devChiller.setTankPressure(value);
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData ssd = (StatusSubsystemData)msg;
        KeyValueData kvd = ssd.getSubsystemData();
        if (kvd instanceof KeyValueDataList && ssd.getDataKey().equals("monitorPublication")) {
            KeyValueDataList kvdl = (KeyValueDataList)kvd;
            for (KeyValueData data : kvdl.getListOfKeyValueData()) {
                if (!data.getKey().equals(this.coldplateChannelPath)) continue;
                this.timeLastData = data.getCCSTimeStamp();
                this.devChiller.updateColdplateTemp((Double)data.getValue(), this.timeLastData);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty(this.refrigAgentProperty)) continue;
            Object object = this.listeningLock;
            synchronized (object) {
                if (!this.isListeningToThermal) {
                    this.isListeningToThermal = true;
                    this.thermalName = agent.getName();
                    LOG.log(Level.INFO, "Starting to listen to messages from " + this.listenTo.toUpperCase() + " subsystem {0}.", this.thermalName);
                    Predicate filter = BusMessageFilterFactory.messageOrigin((String)this.thermalName).and(BusMessageFilterFactory.messageClass(StatusSubsystemData.class));
                    this.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, filter);
                    if (this.listenAlarm) {
                        this.alertService.raiseAlert(ChillerAlerts.LOST_LISTENED.newAlert(), AlertState.NOMINAL, "Subsystem " + this.thermalName + " reconnected");
                        this.listenAlarm = false;
                    }
                } else {
                    LOG.log(Level.SEVERE, "More than one thermal subsystem on the buses!!! Currently listening to {0} and just connected {1}!!", new Object[]{this.thermalName, agent.getName()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            Object object = this.listeningLock;
            synchronized (object) {
                if (this.isListeningToThermal && agent.getName().equals(this.thermalName)) {
                    String msg = "Subsystem " + this.thermalName + "disconnected";
                    if (this.requireListening) {
                        this.alertService.raiseAlert(ChillerAlerts.LOST_LISTENED.newAlert(), AlertState.ALARM, msg);
                        this.listenAlarm = true;
                    }
                    LOG.log(Level.INFO, msg + ", no longer listening to its messages");
                    this.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
                    this.isListeningToThermal = false;
                    this.thermalName = null;
                }
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the chiller state", level=0)
    public ChillerControlState getControlState() {
        this.controlState.setFastPeriod(this.monitorControl.getFastPeriod());
        return this.controlState;
    }

    private void updateControlState() {
        String oldMode;
        String mode;
        boolean changed = this.monitorControl.hasPeriodChanged() || this.gotCommand;
        this.gotCommand = false;
        ChillerState state = this.devChiller.getChillerState();
        if (state != this.controlState.getChillerState()) {
            this.controlState.setChillerState(state);
            changed = true;
        }
        double flow = this.chanFlowSet.getValue();
        double oldFlow = this.controlState.getFlowSet();
        if (!(Double.isNaN(flow) && Double.isNaN(oldFlow) || flow == oldFlow)) {
            this.controlState.setFlowSet(flow);
            changed = true;
        }
        double temp = this.chanTempSet.getValue();
        double oldTemp = this.controlState.getSetPoint();
        if (!(Double.isNaN(temp) && Double.isNaN(oldTemp) || temp == oldTemp)) {
            this.controlState.setSetPoint(temp);
            changed = true;
        }
        double tank = this.chanTankSet.getValue();
        double oldTank = this.controlState.getTankSet();
        if (!(Double.isNaN(tank) && Double.isNaN(oldTank) || tank == oldTank)) {
            this.controlState.setTankSet(tank);
            changed = true;
        }
        double ramp = this.devChiller.getDefaultRamp();
        double oldRamp = this.controlState.getDefaultRamp();
        if (!(Double.isNaN(ramp) && Double.isNaN(oldRamp) || ramp == oldRamp)) {
            this.controlState.setDefaultRamp(ramp);
            changed = true;
        }
        if (!(mode = this.devChiller.getTempControlMode() ? "DUT" : "RTD1").equals(oldMode = this.controlState.getTemperatureMode())) {
            this.controlState.setTemperatureMode(mode);
            changed = true;
        }
        if (changed) {
            this.publishControlState();
        }
    }

    private void publishControlState() {
        this.controlState.setFastPeriod(this.monitorControl.getFastPeriod());
        this.publishSubsystemDataOnStatusBus(new KeyValueData("ChillerControlState", (Serializable)this.controlState));
    }
}

