/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote;

import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.config.SingleCategoryTagData;
import org.lsst.ccs.config.remote.RestFileServerRemoteDAO;

public class LocalToRemoteMigrationDAO
implements ConfigurationDAO {
    private final LocalConfigurationDAO localDAO = new LocalConfigurationDAO();
    private final RestFileServerRemoteDAO remoteDAO;

    public LocalToRemoteMigrationDAO(String subsystemName) {
        this.remoteDAO = new RestFileServerRemoteDAO(subsystemName);
    }

    public SingleCategoryTagData loadCategoryTag(SingleCategoryTag singleCategoryTag) throws ConfigurationServiceException {
        SingleCategoryTagData result = this.localDAO.loadCategoryTag(singleCategoryTag);
        this.remoteDAO.saveCategoryTagData(result);
        return result;
    }

    public SingleCategoryTag saveCategoryTagData(SingleCategoryTagData singleCategoryTagData) throws ConfigurationServiceException {
        return this.remoteDAO.saveCategoryTagData(singleCategoryTagData);
    }

    public void close() {
        this.localDAO.close();
        this.remoteDAO.close();
    }
}

