/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystem.refrig.ChillerPlutoDevice;
import org.lsst.ccs.subsystem.refrig.constants.ChillerLatches;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.data.ChillerPlcState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class SimChillerPlutoDevice
extends ChillerPlutoDevice {
    private static final Map<String, Integer> conditionMap = new LinkedHashMap<String, Integer>();
    private static final Logger LOG;
    private final boolean[] switches = new boolean[1];
    private final LatchState[] latches = new LatchState[7];
    private final ConditionState[] conditions = new ConditionState[12];
    private boolean plcActive = true;

    public SimChillerPlutoDevice() {
        Arrays.fill(this.latches, LatchState.CLEAR);
        Arrays.fill(this.conditions, ConditionState.YES);
        this.conditions[7] = ConditionState.NO;
    }

    protected void initDevice() {
    }

    protected void initialize() {
        this.setOnline(true);
        LOG.log(Level.INFO, "Connected to {0} (simulated Pluto gateway)", this.getPath());
    }

    protected void close() {
    }

    @Override
    public void setSwitchOn(int sw, boolean on) {
        this.switches[sw] = on;
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        return this.switches[sw];
    }

    @Override
    public Boolean isLatchActive(int cond) {
        return this.latches[cond] == LatchState.ACTIVE;
    }

    @Override
    public Boolean isLatchLatched(int cond) {
        return this.latches[cond] == LatchState.LATCHED;
    }

    @Override
    public void clearLatch(int cond) {
        if (this.latches[cond] == LatchState.LATCHED) {
            this.latches[cond] = LatchState.CLEAR;
        }
    }

    @Override
    public void clearAllLatches() {
        for (int cond = 0; cond < this.latches.length; ++cond) {
            this.clearLatch(cond);
        }
    }

    @Override
    public Boolean isConditionActive(int cond) {
        return this.conditions[cond] == ConditionState.YES;
    }

    @Override
    public Boolean isPlcActive() {
        return this.plcActive;
    }

    @Override
    public int getErrorCode() {
        return 42;
    }

    @Override
    public boolean updateState(ChillerPlcState plcState) {
        this.conditions[4] = this.switches[0] ? ConditionState.YES : ConditionState.NO;
        this.conditions[6] = this.latches[1] == LatchState.CLEAR && this.latches[2] == LatchState.CLEAR && this.latches[0] == LatchState.CLEAR && this.latches[4] == LatchState.CLEAR && this.latches[3] == LatchState.CLEAR && this.conditions[4] == ConditionState.YES && this.conditions[1] == ConditionState.YES ? ConditionState.YES : ConditionState.NO;
        return super.updateState(plcState);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of latched condition names")
    public List<String> getLatchNames() {
        return ChillerLatches.getNames();
    }

    @Command(type=Command.CommandType.ACTION, description="Make a latched condition active")
    public void setLatchActive(@Argument(description="Latched condition name") String cond) throws RefrigException {
        this.latches[ChillerLatches.getId((String)cond)] = LatchState.ACTIVE;
    }

    @Command(type=Command.CommandType.ACTION, description="Make a latched condition latched")
    public void setLatchLatched(@Argument(description="Latched condition name") String cond) throws RefrigException {
        this.latches[ChillerLatches.getId((String)cond)] = LatchState.LATCHED;
    }

    @Command(type=Command.CommandType.ACTION, description="Put a latched condition into warning state")
    public void setLatchWarning(@Argument(description="Latched condition name") String cond) throws RefrigException {
        this.latches[ChillerLatches.getId((String)cond)] = LatchState.WARNING;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of condition names")
    public List<String> getConditionNames() {
        return new ArrayList<String>(conditionMap.keySet());
    }

    @Command(type=Command.CommandType.ACTION, description="Set the state of a condition")
    public void setCondition(@Argument(description="Running condition name") String cond, @Argument(description="Condition on state") boolean set) throws RefrigException {
        Integer condNum = conditionMap.get(cond);
        if (condNum == null) {
            throw new RefrigException("Unknown condition name: " + cond);
        }
        this.conditions[condNum.intValue()] = set ? ConditionState.YES : ConditionState.NO;
    }

    @Command(type=Command.CommandType.ACTION, description="Set whether PLC is active")
    public void setPLCActive(@Argument(description="PLC active state") boolean set) {
        this.plcActive = set;
    }

    static {
        conditionMap.put("Allowed", 5);
        conditionMap.put("BdRetnNoError", 11);
        conditionMap.put("BdRetnNoWarn", 10);
        conditionMap.put("BdSuppNoError", 9);
        conditionMap.put("BdSuppNoWarn", 8);
        conditionMap.put("ChillerEmo", 6);
        conditionMap.put("ClpRefPerm", 4);
        conditionMap.put("EmoReadback", 2);
        conditionMap.put("KeySwitch", 1);
        conditionMap.put("MasterReset", 7);
        conditionMap.put("Permit", 0);
        conditionMap.put("SmokeOkay", 3);
        LOG = Logger.getLogger(SimChillerPlutoDevice.class.getName());
    }
}

