/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.agilent.DL34970;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;

public class DL34970Device
extends Device {
    private static final int BAUD_RATE = 9600;
    private static final String tcTypes = "JKTERSBN";
    private static final Map<String, DriverConstants.ConnType> cTypeMap = new HashMap<String, DriverConstants.ConnType>();
    private static final Map<String, Integer> typeMap;
    private static final Map<String, DL34970.TcType> tcMap;
    private String connType;
    private String devcId;
    private int baudRate = 9600;
    private static final Logger LOG;
    private DriverConstants.ConnType connTypeC;
    private final DL34970 dl = new DL34970();
    private final Set<Integer> hwChanSet = new TreeSet<Integer>();
    private final Map<Integer, Integer> hwChanMap = new HashMap<Integer, Integer>();
    private double[] chanValues;
    private boolean initError = false;

    public DL34970Device(String connType, String devcId, int baudRate) {
        this.connType = connType;
        this.devcId = devcId;
        this.baudRate = baudRate == 0 ? 9600 : baudRate;
    }

    public DL34970Device() {
    }

    protected void initDevice() {
        if (this.connType == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"connType", (String)"is missing");
        }
        this.connTypeC = cTypeMap.get(this.connType);
        if (this.connTypeC == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"connType", (String)("is invalid: " + this.connType));
        }
        if (this.devcId == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.getName(), (String)"devcId", (String)"is missing");
        }
        this.fullName = "DL34970 Logger (" + this.devcId + ")";
    }

    protected void initialize() {
        try {
            this.dl.open(this.connTypeC, this.devcId, this.baudRate);
            this.initSensors();
            if (!this.hwChanSet.isEmpty()) {
                int index = 0;
                int[] chans = new int[this.hwChanSet.size()];
                for (int chan : this.hwChanSet) {
                    this.hwChanMap.put(chan, index);
                    chans[index++] = chan;
                }
                this.dl.setScanList(chans);
            }
            LOG.log(Level.INFO, "Connected to {0}", this.fullName);
            this.initError = false;
            this.setOnline(true);
        }
        catch (DriverException | ChannelInitializationException e) {
            if (!this.initError) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
            try {
                this.dl.close();
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
    }

    protected void close() {
        try {
            this.dl.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        String type = ch.getTypeStr();
        Integer iType = typeMap.get(type.toUpperCase());
        int iSubtype = 0;
        if (iType == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"type", (Object)type);
        }
        String subtype = ch.getSubTypeStr();
        if (iType == 0) {
            int n = iSubtype = subtype.length() == 1 ? tcTypes.indexOf(subtype) : -1;
            if (iSubtype < 0) {
                ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"subtype", (Object)subtype);
            }
        } else if (iType == 1) {
            try {
                double range = Math.abs(Double.valueOf(subtype));
                double exp = Math.floor(Math.log10(range));
                double fract = range / Math.pow(10.0, exp);
                iSubtype = (int)(exp - 3.0) << 16 | (int)(1000.0 * fract);
            }
            catch (NumberFormatException e) {
                ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"subtype", (Object)subtype);
            }
        }
        this.hwChanSet.add(ch.getHwChan());
        return new int[]{iType, iSubtype};
    }

    protected void initChannel(Channel ch) {
        try {
            int type = ch.getType();
            int subtype = ch.getSubType();
            int chan = ch.getHwChan();
            if (type == 0) {
                this.dl.configTC(tcMap.get(tcTypes.substring(subtype, subtype + 1)), new int[]{chan});
            } else if (type == 1) {
                this.dl.configVolts(Math.pow(10.0, subtype >> 16) * (double)(subtype & 0xFFFF), new int[]{chan});
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error configuring {0}: {1}", new Object[]{this.fullName, e});
            throw new ChannelInitializationException(e);
        }
    }

    protected String getGroupForChannel(Channel ch) {
        if (this.hwChanSet.contains(ch.getHwChan())) {
            return "data";
        }
        return null;
    }

    protected void readChannelGroup(String group) {
        if (!this.isOnline()) {
            return;
        }
        try {
            if (!this.hwChanSet.isEmpty()) {
                this.chanValues = this.dl.readData();
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error reading data logger: {0}", e);
            this.setOnline(false);
        }
    }

    protected double readChannel(Channel ch) {
        if (this.isOnline()) {
            try {
                return this.chanValues[this.hwChanMap.get(ch.getHwChan())];
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Error reading data logger: {0}", e);
                this.setOnline(false);
            }
        }
        return Double.NaN;
    }

    static {
        cTypeMap.put("SERIAL", DriverConstants.ConnType.SERIAL);
        typeMap = new HashMap<String, Integer>();
        typeMap.put("TEMP", 0);
        typeMap.put("VOLT", 1);
        tcMap = new HashMap<String, DL34970.TcType>();
        tcMap.put("J", DL34970.TcType.J);
        tcMap.put("K", DL34970.TcType.K);
        tcMap.put("T", DL34970.TcType.T);
        tcMap.put("E", DL34970.TcType.E);
        tcMap.put("R", DL34970.TcType.R);
        tcMap.put("S", DL34970.TcType.S);
        tcMap.put("B", DL34970.TcType.B);
        tcMap.put("N", DL34970.TcType.N);
        LOG = Logger.getLogger(DL34970Device.class.getName());
    }

    private class ChannelInitializationException
    extends RuntimeException {
        public ChannelInitializationException(DriverException ex) {
            super((Throwable)ex);
        }
    }
}

