/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema;

import org.hibernate.internal.util.StringHelper;

public enum JdbcMetadaAccessStrategy {
    INDIVIDUALLY("individually"),
    GROUPED("grouped");

    private final String strategy;

    private JdbcMetadaAccessStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String toString() {
        return this.strategy;
    }

    public static JdbcMetadaAccessStrategy interpretHbm2ddlSetting(Object value) {
        if (value == null) {
            return GROUPED;
        }
        String name = value.toString();
        if (StringHelper.isEmpty(name) || JdbcMetadaAccessStrategy.GROUPED.strategy.equals(name)) {
            return GROUPED;
        }
        if (JdbcMetadaAccessStrategy.INDIVIDUALLY.strategy.equals(name)) {
            return INDIVIDUALLY;
        }
        throw new IllegalArgumentException("Unrecognized `hibernate.hbm2ddl.jdbc_metadata_extraction_strategy` value : " + name);
    }
}

