/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class StringTokenizer {
    private static final Pattern shortOptionPattern = Pattern.compile("^-[a-zA-Z]+.*");
    private static final Pattern optionPattern = Pattern.compile("^--[a-zA-Z]+.*");

    public static List<Token> tokenize(String input) {
        ArrayList<Token> result = new ArrayList<Token>();
        if (input == null) {
            return result;
        }
        State state = State.WHITESPACE;
        int tokenIndex = -1;
        StringBuilder token = new StringBuilder("");
        int nBrackets = 0;
        block8: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            boolean isLastCharacter = i == input.length() - 1;
            switch (state) {
                case WHITESPACE: {
                    if (Character.isWhitespace(ch)) continue block8;
                    if (Character.isLetterOrDigit(ch) || ch == '_') {
                        state = State.WORD;
                        tokenIndex = i;
                        token.append(ch);
                        continue block8;
                    }
                    if (ch == '\"') {
                        state = State.STRINGDQ;
                        tokenIndex = i;
                        continue block8;
                    }
                    if (ch == '\'') {
                        state = State.STRINGSQ;
                        tokenIndex = i;
                        continue block8;
                    }
                    if (ch == '#') {
                        state = State.COMMENT;
                        continue block8;
                    }
                    if (ch == '[') {
                        state = State.SQUARE_BRAKET;
                        ++nBrackets;
                        token.append(ch);
                        tokenIndex = i;
                        continue block8;
                    }
                    state = State.WORD;
                    tokenIndex = i;
                    token.append(ch);
                    continue block8;
                }
                case WORD: {
                    if (Character.isWhitespace(ch) || ch == '#' || isLastCharacter) {
                        String currentTokenValue;
                        if (isLastCharacter && !Character.isWhitespace(ch) && ch != '#') {
                            token.append(ch);
                        }
                        if (StringTokenizer.isShortOption(currentTokenValue = token.toString())) {
                            if (currentTokenValue.equals("-")) {
                                result.add(new Token(tokenIndex + 1, "", State.SHORT_OPTION));
                            } else {
                                String shortOptions = currentTokenValue.substring(1);
                                for (int jj = 0; jj < shortOptions.length(); ++jj) {
                                    result.add(new Token(tokenIndex + 1 + jj, Character.toString(shortOptions.charAt(jj)), State.SHORT_OPTION));
                                }
                            }
                            token.setLength(0);
                        } else if (StringTokenizer.isOption(currentTokenValue)) {
                            String optionValue = "";
                            if (!currentTokenValue.equals("--")) {
                                optionValue = currentTokenValue.substring(2);
                            }
                            result.add(new Token(tokenIndex + 2, optionValue, State.OPTION));
                            token.setLength(0);
                        } else {
                            result.add(new Token(tokenIndex, token.toString(), State.WORD));
                            token.setLength(0);
                        }
                        state = Character.isWhitespace(ch) ? State.WHITESPACE : State.COMMENT;
                        continue block8;
                    }
                    token.append(ch);
                    continue block8;
                }
                case STRINGDQ: {
                    if (ch == '\"') {
                        if (i < input.length() - 1 && input.charAt(i + 1) == '\"') {
                            token.append('\"');
                            ++i;
                            continue block8;
                        }
                        state = State.WORD;
                        continue block8;
                    }
                    token.append(ch);
                    continue block8;
                }
                case STRINGSQ: {
                    if (ch == '\'') {
                        if (i < input.length() - 1 && input.charAt(i + 1) == '\'') {
                            token.append('\'');
                            ++i;
                            continue block8;
                        }
                        state = State.WORD;
                        continue block8;
                    }
                    token.append(ch);
                    continue block8;
                }
                case SQUARE_BRAKET: {
                    if (ch == '[') {
                        ++nBrackets;
                    } else if (ch == ']') {
                        --nBrackets;
                    }
                    token.append(ch);
                    if (nBrackets != 0) continue block8;
                    result.add(new Token(tokenIndex, token.toString()));
                    token.setLength(0);
                    state = State.WHITESPACE;
                    continue block8;
                }
                case COMMENT: {
                    continue block8;
                }
                default: {
                    assert (false) : "Unknown state in StringTokenizer state machine";
                    continue block8;
                }
            }
        }
        String currentTokenValue = token.toString();
        if (currentTokenValue.equals("-")) {
            state = State.SHORT_OPTION;
            result.add(new Token(tokenIndex + 1, "", state));
        }
        if (!currentTokenValue.isEmpty() && state == State.WORD || state == State.STRINGDQ || state == State.STRINGSQ) {
            result.add(new Token(tokenIndex, token.toString(), state));
        }
        return result;
    }

    public static boolean isShortOption(String input) {
        return input.equals("-") || shortOptionPattern.matcher(input).matches();
    }

    public static boolean isOption(String input) {
        return input.equals("--") || optionPattern.matcher(input).matches();
    }

    private static enum State {
        WHITESPACE,
        WORD,
        STRINGDQ,
        STRINGSQ,
        COMMENT,
        SQUARE_BRAKET,
        OPTION,
        SHORT_OPTION;

    }

    public static class Token
    implements Serializable {
        private static final long serialVersionUID = 999886576830939492L;
        private final int location;
        private final String string;
        private final State state;

        Token(int location, String string) {
            this(location, string, State.WORD);
        }

        Token(int location, String string, State state) {
            this.location = location;
            this.string = string;
            this.state = state;
        }

        public int getLocation() {
            return this.location;
        }

        public String getString() {
            return this.string;
        }

        public boolean isOption() {
            return this.state == State.OPTION || this.state == State.SHORT_OPTION;
        }

        public boolean isShortOption() {
            return this.state == State.SHORT_OPTION;
        }
    }
}

