/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.subsystem.refrig.PcpPlutoDevice;

public class SimPcpPlutoDevice
extends PcpPlutoDevice {
    private static final List<Integer>[] clearList = new ArrayList[3];
    private static final Map<Integer, Integer> switchMap;
    private static final Logger LOG;
    private final boolean[] switches = new boolean[5];
    private final Boolean[] latches = new Boolean[3];
    private final boolean[] conditions = new boolean[4];
    private final int[] simTempLimits = new int[]{-39, 39, -139, 29};

    protected void initDevice() {
    }

    protected void initialize() {
        this.setOnline(true);
        LOG.log(Level.INFO, "Connected to {0} (simulated Pluto gateway)", this.getPath());
    }

    protected void close() {
    }

    protected int[] checkChannel(Channel ch) {
        return new int[]{0, 0};
    }

    protected double readChannel(Channel ch) {
        return 315.0 + (double)ch.getHwChan();
    }

    @Override
    public Boolean isPlcActive() {
        return true;
    }

    @Override
    public void setSwitchOn(int sw, boolean on) {
        this.switches[sw] = on;
        Integer cond = switchMap.get(sw);
        if (cond != null) {
            this.conditions[cond.intValue()] = on;
        }
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        return this.switches[sw];
    }

    @Override
    public Boolean isLatchActive(int cond) {
        Boolean latch = this.latches[cond];
        return latch != null && latch != false;
    }

    @Override
    public Boolean isLatchLatched(int cond) {
        Boolean latch = this.latches[cond];
        return latch != null && latch == false;
    }

    @Override
    public void clearLatch(int cond) {
        for (int cnd : clearList[cond]) {
            Boolean latch = this.latches[cnd];
            this.latches[cnd] = latch != null && latch == false ? null : latch;
        }
    }

    @Override
    public Boolean isConditionActive(int cond) {
        return this.conditions[cond];
    }

    @Override
    public int[] getTempLimits() {
        return this.simTempLimits;
    }

    @Command(type=Command.CommandType.ACTION)
    public void setLatchActive(@Argument(description="Latched condition number") int cond) {
        this.latches[cond] = true;
    }

    @Command(type=Command.CommandType.ACTION)
    public void setLatchLatched(@Argument(description="Latched condition number") int cond) {
        this.latches[cond] = false;
    }

    @Command(type=Command.CommandType.ACTION)
    public void setCondition(@Argument(description="Running condition number") int cond, @Argument(description="Condition on state") boolean set) {
        this.conditions[cond] = set;
    }

    static {
        for (int cond = 0; cond < 3; ++cond) {
            SimPcpPlutoDevice.clearList[cond] = new ArrayList<Integer>();
        }
        clearList[1].add(1);
        clearList[2].add(2);
        switchMap = new HashMap<Integer, Integer>();
        switchMap.put(2, 1);
        switchMap.put(3, 2);
        switchMap.put(4, 3);
        LOG = Logger.getLogger(SimPcpPlutoDevice.class.getName());
    }
}

