/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20AnalogControl;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;
import org.lsst.ccs.subsystem.refrig.CompMaq20DiscControl;
import org.lsst.ccs.subsystem.refrig.Compressor;

public class CompMaq20Device
extends Maq20Device
implements Compressor.SwitchDevice {
    public static final int SW_OIL_SEP_HEATER = 1;
    public static final int NUM_COLD_SWITCHES = 1;
    public static final int SW_COOLANT_VALVE = 17;
    public static final int SW_ORIFICE_VALVE = 2;
    public static final int SW_BYPASS_VALVE = 3;
    public static final int SW_SURGE_HEATER = 4;
    public static final int SW_CABINET_LIGHT = 16;
    public static final int NUM_CRYO_SWITCHES = 4;
    public static final int CHAN_HGB_VALVE = 0;
    public static final int CHAN_EEPR_VALVE = 1;
    public static final int CHAN_COOLANT_VALVE = 2;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<CompMaq20DiscControl> discCtrlDef = new ArrayList<CompMaq20DiscControl>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Maq20AnalogControl anlgCtrl;
    private static final Logger LOG = Logger.getLogger(CompMaq20Device.class.getName());
    private CompMaq20DiscControl[] discCtrl;
    private boolean gotValveError = false;

    public void setType(int type) {
        if (this.discCtrlDef.isEmpty()) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"MAQ20 discrete control", (String)"not defined");
        }
        if (this.discCtrlDef.size() < 2) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"MAQ20 discrete module count", (String)"must be at least 2");
        }
        this.discCtrl = new CompMaq20DiscControl[this.discCtrlDef.size()];
        for (CompMaq20DiscControl ctrl : this.discCtrlDef) {
            int index = ctrl.getIndex();
            if (index < 0 || index >= this.discCtrl.length) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)ctrl.getPath(), (String)"index", (String)"is negative or exceeds discrete module count");
            }
            if (this.discCtrl[index] != null) {
                ErrorUtils.reportConfigError((Logger)LOG, (String)ctrl.getPath(), (String)"index", (String)"is already used by another discrete module");
            }
            this.discCtrl[index] = ctrl;
        }
        if (type == 0 && this.anlgCtrl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"MAQ20 analog control", (String)"not defined");
        }
    }

    @Override
    public void setSwitchOn(int sw, boolean on) {
        try {
            this.discCtrl[sw >> 4].setLineOn(sw & 0xF, on);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error setting switch for {0}: {1}", new Object[]{this.getPath(), e});
            this.setOnline(false);
        }
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        return this.discCtrl[sw >> 4].isLineOn(sw & 0xF);
    }

    public void setValvePosition(int chan, double posn) {
        double value = 10.0 * Math.min(Math.max(posn, 0.0), 1.0);
        try {
            this.anlgCtrl.writeValue(chan, value);
            this.gotValveError = false;
        }
        catch (DriverException e) {
            if (!this.gotValveError) {
                LOG.log(Level.SEVERE, "Error setting valve position for {0}: {1}", new Object[]{this.getPath(), e});
                this.setOnline(false);
            }
            this.gotValveError = true;
        }
    }

    public double getValvePosition(int chan) {
        try {
            double value = this.anlgCtrl.readValue(chan) / 10.0;
            this.gotValveError = false;
            return value;
        }
        catch (DriverException e) {
            if (!this.gotValveError) {
                LOG.log(Level.SEVERE, "Error getting valve position for {0}: {1}", new Object[]{this.getPath(), e});
                this.setOnline(false);
            }
            this.gotValveError = true;
            return Double.NaN;
        }
    }
}

