/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.mks;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.mks.GP390;

public class TestGP390 {
    private static final Map<Integer, String> unitsMap = new HashMap<Integer, String>();
    private static final Map<Integer, String> gmodeMap;
    private static final Map<Integer, String> vtypeMap;
    private final GP390 gp = new GP390();

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="ident", description="Identification") String ident, @Argument(name="baud", description="Baud rate") int baud, @Argument(name="addr", description="Device address") int address) throws DriverException {
        this.gp.open(ident, baud, address);
    }

    @Command(name="close", description="Close the connection")
    public void close() throws DriverException {
        this.gp.close();
    }

    @Command(name="unlock", description="Unlock protected settings")
    public void unlock() throws DriverException {
        this.gp.unlock();
    }

    @Command(name="toggle", description="Toggle protected settings lock")
    public String toggleLock() throws DriverException {
        return this.gp.toggleLock() ? "Locked" : "Unlocked";
    }

    @Command(name="lock", description="Set protected settings lock")
    public void setLock(@Argument(name="onoff", description="ON or OFF") OnOff onoff) throws DriverException {
        this.gp.setLock(onoff == OnOff.ON);
    }

    @Command(name="reset", description="Reset to power-on state")
    public void reset() throws DriverException {
        this.gp.reset();
    }

    @Command(name="setdefaults", description="Set factory defaults")
    public void setDefaults() throws DriverException {
        this.gp.setDefaults();
    }

    @Command(name="showversion", description="Show firmware version")
    public String showFwVersion() throws DriverException {
        return this.gp.getFwVersion();
    }

    @Command(name="showstatus", description="Show status word")
    public String showStatusWord() throws DriverException {
        return String.format("%08x", this.gp.getStatusWord());
    }

    @Command(name="setunits", description="Set pressure units")
    public void setUnits(@Argument(name="unit", description="Pressure units") Units units) throws DriverException {
        this.gp.setPressureUnit(units.getValue());
    }

    @Command(name="showunits", description="Show pressure units")
    public String showUnits() throws DriverException {
        return unitsMap.get(this.gp.getPressureUnit());
    }

    @Command(name="readvacuum", description="Read vacuum pressure")
    public String readPressure() throws DriverException {
        return this.gp.readPressure() + " " + this.getUnitsString();
    }

    @Command(name="readdiff", description="Read differential pressure")
    public String readDiffPressure() throws DriverException {
        return this.gp.readDiffPressure() + " " + this.getUnitsString();
    }

    @Command(name="setatmospheric", description="Set atmospheric pressure")
    public void setAtmospheric(@Argument(name="press", description="Atmospheric pressure") double press) throws DriverException {
        this.gp.setAtmospheric(press);
    }

    @Command(name="showatmospheric", description="Show atmospheric pressure")
    public String showAtmospheric() throws DriverException {
        double press = this.gp.getAtmospheric();
        return press < 0.0 ? "Actual" : press + " " + this.getUnitsString();
    }

    @Command(name="setfilament", description="Set filament mode")
    public void setFilament(@Argument(name="mode", description="Filament mode") Fmode mode) throws DriverException {
        this.gp.setFilamentMode(mode.getValue());
    }

    @Command(name="showfilament", description="Show filament status")
    public String showFilament() throws DriverException {
        return String.valueOf(this.gp.getFilamentStatus());
    }

    @Command(name="setgauge", description="Set gauge on or off")
    public void setGaugeOn(@Argument(name="onoff", description="ON or OFF") OnOff onoff) throws DriverException {
        this.gp.setMiGaugeOn(onoff == OnOff.ON);
    }

    @Command(name="showgauge", description="Show gauge state")
    public String showGauge() throws DriverException {
        return this.gp.isMiGaugeOn() ? "On" : "Off";
    }

    @Command(name="setdegas", description="Turn gauge degas on or off")
    public void setDegasOn(@Argument(name="onoff", description="ON or OFF") OnOff onoff) throws DriverException {
        this.gp.setMiDegasOn(onoff == OnOff.ON);
    }

    @Command(name="showdegas", description="Show gauge degas state")
    public String showDegas() throws DriverException {
        return this.gp.isMiDegasOn() ? "On" : "Off";
    }

    @Command(name="setdegastime", description="Set gauge degas time")
    public void setDegasTime(@Argument(name="time", description="Degas time") int time) throws DriverException {
        this.gp.setMiDegasTime(time);
    }

    @Command(name="showdegastime", description="Show degas time")
    public String showDegasTime() throws DriverException {
        return String.valueOf(this.gp.getMiDegasTime());
    }

    @Command(name="setdelay", description="Turn gauge delay on or off")
    public void setDelayOn(@Argument(name="onoff", description="ON or OFF") OnOff onoff) throws DriverException {
        this.gp.setMiDelayOn(onoff == OnOff.ON);
    }

    @Command(name="showdelay", description="Show gauge delay state")
    public String showDelay() throws DriverException {
        return this.gp.isMiDelayOn() ? "On" : "Off";
    }

    @Command(name="setdelaytime", description="Set gauge delay time")
    public void setDelayTime(@Argument(name="time", description="Delay time") int time) throws DriverException {
        this.gp.setMiDelayTime(time);
    }

    @Command(name="showdelaytime", description="Show gauge delay time")
    public String showDelayTime() throws DriverException {
        return String.valueOf(this.gp.getMiDelayTime());
    }

    @Command(name="setswitch", description="Set gauge switch pressure")
    public void setSwitchPressure(@Argument(name="pressure", description="Switch pressure") double press) throws DriverException {
        this.gp.setMiSwitchPressure(press);
    }

    @Command(name="showswitch", description="Show gauge switch pressure")
    public String showSwitchPressure() throws DriverException {
        return this.gp.getMiSwitchPressure() + " " + this.getUnitsString();
    }

    @Command(name="showcurrent", description="Show gauge current")
    public String showCurrent() throws DriverException {
        return this.gp.getMiGaugeCurrent() + " mA";
    }

    @Command(name="setrelaytrip", description="Set relay trip point")
    public void setRelayTrip(@Argument(name="relay", description="Relay number") int relay, @Argument(name="type", description="Set point type") TripType type, @Argument(name="value", description="Set point value") double value) throws DriverException {
        this.gp.setRelayTrip(relay, type.getValue(), value);
    }

    @Command(name="showrelaytrip", description="Show relay trip point")
    public String showRelayTrip(@Argument(name="relay", description="Relay number") int relay, @Argument(name="type", description="Set point type") TripType type) throws DriverException {
        return String.valueOf(this.gp.getRelayTrip(relay, type.getValue()));
    }

    @Command(name="assignrelay", description="Assign relay to vacuum type")
    public void assignRelay(@Argument(name="relay", description="Relay number") int relay, @Argument(name="type", description="Vacuum type") VacType type) throws DriverException {
        this.gp.assignRelay(relay, type.getValue());
    }

    @Command(name="showrelayassign", description="Show relay assignment type")
    public String showRelayAssign(@Argument(name="relay", description="Relay number") int relay) throws DriverException {
        return vtypeMap.get(this.gp.getRelayAssignment(relay));
    }

    @Command(name="enablerelay", description="Enable a relay")
    public void enableRelay(@Argument(name="relay", description="Relay number") int relay, @Argument(name="enable", description="Whether to enable") boolean enable) throws DriverException {
        this.gp.enableRelay(relay, enable);
    }

    @Command(name="isrelayenabled", description="Check whether relay enabled")
    public String isRelayEnabled(@Argument(name="relay", description="Relay number") int relay) throws DriverException {
        return String.valueOf(this.gp.isRelayEnabled(relay));
    }

    @Command(name="isrelayactive", description="Check whether relay is active")
    public String isRelayActive(@Argument(name="relay", description="Relay number") int relay) throws DriverException {
        return String.valueOf(this.gp.isRelayActive(relay));
    }

    @Command(name="setoffset", description="Set address offset")
    public void setOffset(@Argument(name="offset", description="Address first digit") int offset) throws DriverException {
        this.gp.setAddressOffset(offset);
    }

    @Command(name="setbaud", description="Set baud rate")
    public void setUnits(@Argument(name="unit", description="Baud rate") int baud) throws DriverException {
        this.gp.setBaudRate(baud);
    }

    @Command(name="settimeout", description="Set response timeout")
    public void setTimeout(@Argument(name="timeout", description="Timeout (secs)") double timeout) throws DriverException {
        this.gp.setTimeout(timeout);
    }

    private String getUnitsString() throws DriverException {
        return unitsMap.get(this.gp.getPressureUnit()).toLowerCase();
    }

    static {
        unitsMap.put(0, "Torr");
        unitsMap.put(1, "Mbar");
        unitsMap.put(2, "Pascal");
        gmodeMap = new HashMap<Integer, String>();
        gmodeMap.put(0, "Off");
        gmodeMap.put(1, "Degas");
        gmodeMap.put(2, "High emission");
        gmodeMap.put(3, "Low emission");
        vtypeMap = new HashMap<Integer, String>();
        vtypeMap.put(0, "Abs");
        vtypeMap.put(1, "Diff");
    }

    protected static enum VacType {
        ABS(0),
        DIFF(1);

        int value;

        private VacType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    protected static enum TripType {
        ACT(1),
        DEACT(0);

        int value;

        private TripType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    protected static enum Fmode {
        MANUAL(0),
        ALT(1),
        AUTO(2);

        int value;

        private Fmode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    protected static enum Units {
        TORR(0),
        MBAR(1),
        PASCAL(2);

        int value;

        private Units(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    protected static enum OnOff {
        ON,
        OFF;

    }
}

