/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.chiller.Chiller;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorUpdateTask;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.HeatTransferChannel;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.refrig.ChillerMaq20Device;
import org.lsst.ccs.subsystem.refrig.ChillerPlutoDevice;
import org.lsst.ccs.subsystem.refrig.FanControl;
import org.lsst.ccs.subsystem.refrig.InTESTChillerDevice;
import org.lsst.ccs.subsystem.refrig.constants.ChillerAlerts;
import org.lsst.ccs.subsystem.refrig.constants.ChillerLatches;
import org.lsst.ccs.subsystem.refrig.constants.ChillerState;
import org.lsst.ccs.subsystem.refrig.data.ChillerControlState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;
import org.lsst.ccs.subsystem.refrig.data.RefrigUtils;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class ChillerSubsystem
extends Subsystem
implements HasLifecycle,
StatusMessageListener,
AgentPresenceListener {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private InTESTChillerDevice devChiller;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private ChillerPlutoDevice devPluto;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private ChillerMaq20Device devMaq20;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private List<Channel> chanList = new ArrayList<Channel>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Monitor mon;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private List<HeatTransferChannel> heatXferList = new ArrayList<HeatTransferChannel>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private FanControl fanControl;
    @LookupName
    private String name;
    @ConfigurationParameter(isFinal=true, description="whether this is the chiller providing fluid to the camera", units="unitless")
    protected volatile boolean connectedToCamera;
    @ConfigurationParameter(isFinal=true, description="Which refrig subsystem to listen to (RefrigAgentProperties)", units="unitless")
    protected volatile String listenTo;
    @ConfigurationParameter(isFinal=true, description="path of coldplate temperature Channel to listen for", units="unitless")
    protected volatile String coldplateChannelPath;
    @ConfigurationParameter(isFinal=true, description="path of cold inlet temperature Channel to listen for", units="unitless")
    protected volatile String coldInletChannelPath;
    @ConfigurationParameter(isFinal=true, description="path of cold outlet temperature Channel to listen for", units="unitless")
    protected volatile String coldOutletChannelPath;
    @ConfigurationParameter(description="Factor on temperature-setting timeout", range="1.0..1.4", units="unitless")
    protected volatile double temperatureTimeoutFactor;
    @ConfigurationParameter(isFinal=true, description="cooling by glycol (true)/water (false)", units="unitless")
    protected volatile boolean glycolCooling;
    @ConfigurationParameter(isFinal=true, description="Burst-disc presssure to stop flow", units="psig")
    protected volatile double maxPressure;
    private static final Logger LOG = Logger.getLogger(ChillerSubsystem.class.getName());
    private static final int emoMask = 32;
    private static final double rampCorrection = -0.04;
    private static final double waterCoolFactor = 0.26384238000000004;
    private static final double glycolCoolFactor = 0.23672834666666667;
    private static final double coolantXferFactor = 0.111564;
    private final Object listeningLock = new Object();
    private volatile boolean isListeningToThermal = false;
    private volatile boolean isListeningToHex = false;
    private volatile String thermalName = null;
    private volatile String hexName = null;
    private volatile boolean setTempInProgress = false;
    private volatile boolean setFlowInProgress = false;
    private volatile String refrigAgentProperty;
    private String refrigAgentHexProperty = "hexType";
    private String refrigGroup = null;
    private boolean listenAlarm = false;
    private Channel chanFlow;
    private MonitorUpdateTask taskFlow;
    private Channel chanPSupply;
    private Channel chanPReturn;
    private Channel chanFlowSet;
    private Channel chanTempSet;
    private Channel chanTankSet;
    private HeatTransferChannel chanGlycXfer;
    private HeatTransferChannel chanCoolantXfer;
    private HeatTransferChannel chanColdXfer;
    private volatile CCSTimeStamp timeLastData;
    private volatile boolean lastControlMode;
    private volatile AlertState lastDataAlert = AlertState.NOMINAL;
    private double lastRampValue;
    private final ChillerAlerts[] blockingAlerts = new ChillerAlerts[]{ChillerAlerts.VACUUM_LIMIT, ChillerAlerts.PRESSURE_LIMIT, ChillerAlerts.COLD_TEMP_LOW, ChillerAlerts.COLD_TEMP_HIGH};
    private String blockingCause;
    private Thread checkTemp;
    private Thread checkFlow;
    private static final Duration intervalCheckTemp = Duration.ofSeconds(30L);
    private static final Duration intervalCheckFlow = Duration.ofSeconds(5L);
    private static final Duration setFlowTimeout = Duration.ofSeconds(45L);
    private static final double flowTolerance = 0.1;
    private AgentPeriodicTask checkDataArrival;
    private static final Duration periodCheckData = Duration.ofMillis(500L);
    private static long timeDataWarning = 3000L;
    private static long timeDataAlarm = 20000L;
    private AgentPeriodicTask updateCtrlState;
    private static final int UPDATE_CONTROL_INTVL = 1000;
    private AgentPeriodicTask sendDUTTemperature;
    private static final Duration periodDUT = Duration.ofMillis(1000L);
    private AgentPeriodicTask checkBurstDiscP;
    private static final Duration periodBurst = Duration.ofMillis(500L);
    private AgentPeriodicTask publishParams;
    private static final Duration periodParams = Duration.ofMinutes(30L);
    private MonitorTaskControl monitorControl;
    private final ChillerControlState controlState = new ChillerControlState();
    private boolean gotCommand;

    public ChillerSubsystem() {
        super("chiller", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        this.updateCtrlState = new AgentPeriodicTask("updateCtrlState", () -> this.updateControlState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(this.updateCtrlState);
        Runnable checkData = new Runnable(){

            @Override
            public void run() {
                AlertState dataAlert;
                boolean controlMode = ChillerSubsystem.this.devChiller.getTempControlMode();
                String msg = "";
                if (controlMode) {
                    long dt = System.currentTimeMillis() - ChillerSubsystem.this.timeLastData.getUTCInstant().toEpochMilli();
                    dataAlert = controlMode != ChillerSubsystem.this.lastControlMode || dt <= timeDataWarning ? AlertState.NOMINAL : (dt <= timeDataAlarm ? AlertState.WARNING : AlertState.ALARM);
                    msg = "time since last data = " + Long.toString(dt) + " ms";
                } else {
                    dataAlert = AlertState.NOMINAL;
                }
                if (dataAlert != ChillerSubsystem.this.lastDataAlert) {
                    ChillerSubsystem.this.alertService.raiseAlert(ChillerAlerts.MISSING_THERMAL.newAlert(), dataAlert, msg);
                    ChillerSubsystem.this.lastDataAlert = dataAlert;
                }
                ChillerSubsystem.this.lastControlMode = controlMode;
            }
        };
        this.checkDataArrival = new AgentPeriodicTask("checkDataArrival", checkData).withPeriod(periodCheckData);
        this.periodicTaskService.scheduleAgentPeriodicTask(this.checkDataArrival);
        Runnable sendDUT = new Runnable(){

            @Override
            public void run() {
                if (ChillerSubsystem.this.devChiller.getTempControlMode()) {
                    ChillerSubsystem.this.devChiller.sendDUTData();
                }
            }
        };
        this.sendDUTTemperature = new AgentPeriodicTask("sendDutTemperature", sendDUT).withPeriod(periodDUT);
        this.periodicTaskService.scheduleAgentPeriodicTask(this.sendDUTTemperature);
        Runnable checkBurst = new Runnable(){

            @Override
            public void run() {
                double pSupply = ChillerSubsystem.this.chanPSupply.getValue();
                double pReturn = ChillerSubsystem.this.chanPReturn.getValue();
                if (pSupply >= ChillerSubsystem.this.maxPressure || pReturn >= ChillerSubsystem.this.maxPressure) {
                    if (ChillerSubsystem.this.devChiller.isOnline()) {
                        try {
                            ChillerSubsystem.this.quitControllingTemperature();
                        }
                        catch (DriverException ex) {
                            LOG.log(Level.SEVERE, "DriverException while trying to stop chiller flow because of burs-disc pressureb:" + (Object)((Object)ex));
                        }
                    }
                    ChillerSubsystem.this.alertService.raiseAlert(ChillerAlerts.PRESSURE_LIMIT.newAlert(), AlertState.ALARM, "Burst-disc pressures = " + pSupply + ", " + pReturn + " over limit " + ChillerSubsystem.this.maxPressure + " psig");
                }
            }
        };
        this.checkBurstDiscP = new AgentPeriodicTask("checkBurstDiscP", checkBurst).withPeriod(periodBurst);
        this.periodicTaskService.scheduleAgentPeriodicTask(this.checkBurstDiscP);
        Runnable publishFParams = new Runnable(){

            @Override
            public void run() {
                ChillerSubsystem.this.devChiller.publishParameters();
            }
        };
        this.publishParams = new AgentPeriodicTask("publishParams", publishFParams).withPeriod(periodParams);
        this.periodicTaskService.scheduleAgentPeriodicTask(this.publishParams);
    }

    public void init() {
        ClearAlertHandler chillerClearAlertHandler = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                String alertId = alert.getAlertId();
                if (alertId.equals(ChillerAlerts.TEMP_TIMEOUT.getId()) || alertId.equals(ChillerAlerts.FLOW_TIMEOUT.getId())) {
                    return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
                }
                if (alertId.equals(ChillerAlerts.PRESSURE_LIMIT.getId())) {
                    return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
                }
                return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
            }
        };
        this.propertiesService.setAgentProperty("chillerType", ChillerSubsystem.class.getCanonicalName());
        this.refrigGroup = RefrigUtils.getGroupName(this.getAgentInfo());
        this.alertService.registerAlert(ChillerAlerts.TEMP_TIMEOUT.newAlert(), chillerClearAlertHandler);
        this.alertService.registerAlert(ChillerAlerts.FLOW_TIMEOUT.newAlert(), chillerClearAlertHandler);
        this.alertService.registerAlert(ChillerAlerts.LOST_LISTENED.newAlert());
        this.alertService.registerAlert(ChillerAlerts.MISSING_THERMAL.newAlert());
        for (ChillerAlerts chillerAlerts : this.blockingAlerts) {
            this.alertService.registerAlert(chillerAlerts.newAlert());
        }
        this.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        Predicate filter = BusMessageFilterFactory.messageClass(StatusSubsystemData.class);
        this.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, filter);
        if (this.devChiller == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Chiller device", (String)"not specified");
        }
        if (this.devPluto == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Pluto device", (String)"not specified");
        }
        List listTasks = this.mon.getMonitorUpdateTasksForDevice((Device)this.devChiller);
        for (MonitorUpdateTask monitorUpdateTask : listTasks) {
            List chList = monitorUpdateTask.getAllChannels();
            for (Channel ch : chList) {
                if (this.chanFlow != null || !ch.getSubTypeStr().equals("FLOW_RATE")) continue;
                this.chanFlow = ch;
                this.taskFlow = monitorUpdateTask;
            }
        }
        for (Channel channel : this.chanList) {
            if (this.chanFlowSet == null && channel.getSubTypeStr().equals("FLOW_SETPT")) {
                this.chanFlowSet = channel;
                continue;
            }
            if (this.chanTempSet == null && channel.getSubTypeStr().equals("SET_POINT")) {
                this.chanTempSet = channel;
                continue;
            }
            if (this.chanTankSet == null && channel.getSubTypeStr().equals("TANK_P_SET")) {
                this.chanTankSet = channel;
                continue;
            }
            if (this.chanPSupply == null && channel.getName().contains("PBurstSupply")) {
                this.chanPSupply = channel;
                continue;
            }
            if (this.chanPReturn != null || !channel.getName().contains("PBurstReturn")) continue;
            this.chanPReturn = channel;
        }
        for (HeatTransferChannel heatTransferChannel : this.heatXferList) {
            if (this.chanGlycXfer == null && heatTransferChannel.getName().contains("Glyc")) {
                this.chanGlycXfer = heatTransferChannel;
                continue;
            }
            if (this.chanCoolantXfer == null && heatTransferChannel.getName().contains("Coolant")) {
                this.chanCoolantXfer = heatTransferChannel;
                continue;
            }
            if (this.chanColdXfer != null || !heatTransferChannel.getName().contains("Cold")) continue;
            this.chanColdXfer = heatTransferChannel;
        }
        if (this.taskFlow == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"taskFlow", (String)"no update task found with Channel subtype FLOW_RATE");
        }
        if (this.chanPSupply == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"chanPSupply", (String)"no update task found with Channel PBurstSupply");
        }
        if (this.chanPReturn == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"chanPReturn", (String)"no update task found with Channel PBurstReturn");
        }
        if (this.chanGlycXfer != null) {
            if (this.glycolCooling) {
                this.chanGlycXfer.setFactor(0.23672834666666667);
            } else {
                this.chanGlycXfer.setFactor(0.26384238000000004);
            }
        }
        if (this.chanCoolantXfer != null) {
            this.chanCoolantXfer.setFactor(0.111564);
        }
        if (this.chanColdXfer != null) {
            this.chanColdXfer.setFactor(0.111564);
        }
        this.timeLastData = CCSTimeStamp.currentTime();
    }

    public void postStart() {
        this.checkTemp = new Thread("dummyT"){};
        this.checkFlow = new Thread("dummyF"){};
        if (this.fanControl != null) {
            LOG.log(Level.INFO, "Starting fan speed controller for chiller");
            this.fanControl.startLoop();
        }
    }

    public void shutdown() {
        this.getMessagingAccess().getAgentPresenceManager().removeAgentPresenceListener((AgentPresenceListener)this);
        this.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
        try {
            this.devChiller.shutdownDUT();
        }
        catch (DriverException ex) {
            throw new RuntimeException("DriverException in shutdownDUT() " + (Object)((Object)ex));
        }
    }

    @ConfigurationParameterChanger(propertyName="listenTo")
    public void setListenTo(String value) {
        if (value.toLowerCase().equals("thermal")) {
            this.refrigAgentProperty = "thermalType";
            this.listenTo = value;
        } else if (value.toLowerCase().equals("pcp")) {
            this.refrigAgentProperty = "pcpType";
            this.listenTo = value;
        } else {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"listenTo", (String)"Must specify either Thermal or Pcp subsystem");
        }
    }

    public String vetoTransitionToNormalMode() {
        String lights;
        String reply = "";
        if (this.stateService.getState(ChillerState.class) != ChillerState.SETPOINT) {
            reply = reply + "Chiller not controlling at setpoint  ";
        }
        if (this.devChiller.getTempControlMode() && !this.isListeningToThermal) {
            reply = reply + "Chiller subayatem in DUT mode but not listening to Thermal input  ";
        }
        if ((lights = this.showLights()).contains("on")) {
            reply = reply + "Chiller cabinet lights " + lights + ", must be off  ";
        }
        if (reply.equals("") && !this.devChiller.isGuiLocked()) {
            try {
                this.devChiller.setGuiLock(true);
                LOG.log(Level.INFO, "Locking Chiller controller Gui for transition to Normal mde");
            }
            catch (DriverException ex) {
                LOG.log(Level.SEVERE, "DriverException on setting Gui lock " + (Object)((Object)ex));
                reply = reply + "DriverException on setting Chiller Gui lock";
            }
        }
        return reply.equals("") ? null : reply;
    }

    private boolean blockFlow() {
        boolean block = false;
        this.blockingCause = "";
        for (ChillerAlerts ca : this.blockingAlerts) {
            RaisedAlertHistory alertHistory = this.alertService.getRaisedAlertSummary().getRaisedAlert(ca.getId());
            if (alertHistory == null || alertHistory.getLatestAlertState() != AlertState.ALARM) continue;
            block = true;
            this.blockingCause = this.blockingCause + ca.getId() + " ";
        }
        if (block) {
            this.blockingCause = this.blockingCause + " raised at ALARM level";
        }
        return block;
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="setTemperature", autoAck=false, description="go to temperature setting using default ramp")
    public void setTemperature(@Argument(description="tempeature in degrees") double temperature) throws DriverException {
        this.helper().precondition(!this.blockFlow(), "operattion blocked due to " + this.blockingCause, new Supplier[0]).precondition(this.devChiller.getLastErrorAlert() != AlertState.ALARM, "operation blocked due to Chiller Error", new Supplier[0]).precondition(!this.setTempInProgress, "Previous set command in progress, quitControllingTemperature must be issued first", new Supplier[0]).action(() -> {
            this.gotCommand = true;
            double ramp = Double.parseDouble(this.devChiller.readNamedParameter(Chiller.FParam.RAMP_DEFAULT));
            this.devChiller.setTemperature(temperature);
            this.setTempInProgress = true;
            this.lastRampValue = ramp;
            this.waitForTemp(temperature, ramp);
        });
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="setTemperatureWithRamp", autoAck=false, description="go to temperature setting using provided ramp")
    public void setTemperatureWithRamp(@Argument(description="tempeature in degrees") double temperature, @Argument(description="ramp in degrees/min") double ramp) throws DriverException {
        this.helper().precondition(!this.blockFlow(), "operattion blocked due to " + this.blockingCause, new Supplier[0]).precondition(this.devChiller.getLastErrorAlert() != AlertState.ALARM, "operation blocked due to Chiller Error", new Supplier[0]).precondition(!this.setTempInProgress, "Previous set command in progress, quitControllingTemperature must be issued first", new Supplier[0]).precondition(ramp + -0.04 >= 0.01, "Ramp + correction (-0.04) must be at least 0.01", new Supplier[0]).action(() -> {
            this.gotCommand = true;
            this.devChiller.setTemperatureWithRamp(temperature, ramp);
            this.setTempInProgress = true;
            this.lastRampValue = ramp;
            this.waitForTemp(temperature, ramp);
        });
    }

    private void waitForTemp(double temp, double ramp) throws DriverException {
        Double currentTemp = this.devChiller.getTempControlMode() ? this.mon.getChannelValue("Chiller/ImportedColdTemp") : this.mon.getChannelValue("Chiller/FluidTemperature");
        final long timeEst = Math.round(60.0 * Math.abs(currentTemp - temp) / (ramp + -0.04));
        LOG.info("Initiating temperature change to " + Double.toString(temp) + " deg, estimated duration " + Double.toString(timeEst) + " seconds.");
        this.checkTemp = new Thread("checkTemp"){

            @Override
            public void run() {
                block3: {
                    long timeStart = System.currentTimeMillis();
                    long timeout = Math.round(ChillerSubsystem.this.temperatureTimeoutFactor * 1000.0 * (double)timeEst);
                    do {
                        try {
                            Thread.sleep(intervalCheckTemp.toMillis());
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException("Unexpected interrupt while waiting for requested temperature", ex);
                        }
                        if (ChillerSubsystem.this.stateService.getState(ChillerState.class) != ChillerState.SETPOINT) continue;
                        ChillerSubsystem.this.setTempInProgress = false;
                        LOG.info("Chiller temperature is at requested setpoint");
                        break block3;
                    } while (System.currentTimeMillis() - timeStart <= timeout);
                    ChillerSubsystem.this.alertService.raiseAlert(ChillerAlerts.TEMP_TIMEOUT.newAlert(), AlertState.ALARM, "Set temperature timed out at " + Long.toString(timeout / 1000L) + " s");
                    ChillerSubsystem.this.setTempInProgress = false;
                }
            }
        };
        this.checkTemp.setDaemon(true);
        this.checkTemp.start();
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="quitControllingTemperature", description="stop controlling temperature")
    public void quitControllingTemperature() throws DriverException {
        this.devChiller.quitControllingTemperature();
        this.setTempInProgress = false;
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="setFlow", description="set flow rate of chilled fluid")
    public String setFlow(final @Argument(description="flow rate in gpm") double flow) throws DriverException {
        this.gotCommand = true;
        this.devChiller.setFlow(flow);
        ChillerState state = (ChillerState)this.stateService.getState(ChillerState.class);
        if (state != ChillerState.SETPOINT && state != ChillerState.CONTROLLING) {
            return "setFlow command rejected because chiller pumps are off";
        }
        this.setFlowInProgress = true;
        this.checkFlow = new Thread("checkFlow"){

            @Override
            public void run() {
                block3: {
                    long timeStart = System.currentTimeMillis();
                    long timeout = setFlowTimeout.toMillis();
                    ChillerSubsystem.this.taskFlow.forceDataPublicationForDuration(setFlowTimeout);
                    do {
                        try {
                            Thread.sleep(intervalCheckFlow.toMillis());
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException("Unexpected interrupt while waiting for requested flow", ex);
                        }
                        if (!(Math.abs(ChillerSubsystem.this.chanFlow.getValue() - flow) < 0.1)) continue;
                        LOG.info("Chiller flpw is at requested setpoint");
                        ChillerSubsystem.this.taskFlow.resetForcedDataPublication();
                        break block3;
                    } while (System.currentTimeMillis() - timeStart <= timeout);
                    ChillerSubsystem.this.alertService.raiseAlert(ChillerAlerts.FLOW_TIMEOUT.newAlert(), AlertState.ALARM, "Set flow timed out at " + Long.toString(timeout / 1000L) + " s");
                }
                ChillerSubsystem.this.setFlowInProgress = false;
            }
        };
        this.checkFlow.setDaemon(true);
        this.checkFlow.start();
        return "Chilled fluid flow setting initiated";
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="setTankPressure", description="Set tank pressure in psig")
    public void setTankPressure(@Argument(description="Tank pressure set value in psig") double value) throws DriverException {
        this.gotCommand = true;
        this.devChiller.setTankPressure(value);
    }

    public void onStatusMessage(StatusMessage msg) {
        String agentName = msg.getOriginAgentInfo().getName();
        if (!agentName.equals(this.thermalName) && !agentName.equals(this.hexName)) {
            return;
        }
        StatusSubsystemData ssd = (StatusSubsystemData)msg;
        KeyValueData kvd = ssd.getSubsystemData();
        if (kvd instanceof KeyValueDataList && ssd.getDataKey().equals("monitorPublication")) {
            KeyValueDataList kvdl = (KeyValueDataList)kvd;
            if (agentName.equals(this.thermalName)) {
                for (KeyValueData data : kvdl.getListOfKeyValueData()) {
                    this.timeLastData = data.getCCSTimeStamp();
                    if (!data.getKey().equals(this.coldplateChannelPath)) continue;
                    this.devChiller.updateColdplateTemp((Double)data.getValue(), this.timeLastData);
                    break;
                }
            }
            if (agentName.equals(this.connectedToCamera ? this.hexName : this.thermalName)) {
                for (KeyValueData data : kvdl.getListOfKeyValueData()) {
                    this.timeLastData = data.getCCSTimeStamp();
                    if (data.getKey().equals(this.coldInletChannelPath)) {
                        this.devChiller.updateColdInletTemp((Double)data.getValue(), this.timeLastData);
                        continue;
                    }
                    if (!data.getKey().equals(this.coldOutletChannelPath)) continue;
                    this.devChiller.updateColdOutletTemp((Double)data.getValue(), this.timeLastData);
                }
            }
        }
    }

    public void connected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (agent.hasAgentProperty(this.refrigAgentProperty) && (this.refrigGroup.equals(RefrigUtils.getGroupName(agent)) || !this.refrigGroup.equals(""))) {
                if (!this.isListeningToThermal && (this.thermalName == null || this.thermalName.equals(agent.getName()))) {
                    this.isListeningToThermal = true;
                    this.thermalName = agent.getName();
                    LOG.log(Level.INFO, "Starting to listen to messages from " + this.listenTo.toUpperCase() + " subsystem {0}.", this.thermalName);
                    if (this.listenAlarm) {
                        this.alertService.raiseAlert(ChillerAlerts.LOST_LISTENED.newAlert(), AlertState.NOMINAL, "Subsystem " + this.thermalName + " reconnected");
                        this.listenAlarm = false;
                    }
                } else {
                    LOG.log(Level.SEVERE, "More than one thermal subsystem on the buses!!! Currently listening to {0} and just connected {1}!!", new Object[]{this.thermalName, agent.getName()});
                }
            }
            if (!agent.hasAgentProperty(this.refrigAgentHexProperty) || !this.refrigGroup.equals(RefrigUtils.getGroupName(agent)) && this.refrigGroup.equals("")) continue;
            if (!this.isListeningToHex && (this.hexName == null || this.hexName.equals(agent.getName()))) {
                this.isListeningToHex = true;
                this.hexName = agent.getName();
                LOG.log(Level.INFO, "Starting to listen to messages from HEX subsystem {0}.", this.hexName);
                continue;
            }
            LOG.log(Level.SEVERE, "More than one hex subsystem on the buses!!! Currently listening to {0} and just connected {1}!!", new Object[]{this.hexName, agent.getName()});
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            String msg;
            if (this.isListeningToThermal && agent.getName().equals(this.thermalName)) {
                msg = "Subsystem " + this.thermalName + "disconnected";
                if (this.devChiller.getTempControlMode()) {
                    this.alertService.raiseAlert(ChillerAlerts.LOST_LISTENED.newAlert(), AlertState.ALARM, msg);
                    this.listenAlarm = true;
                }
                LOG.log(Level.INFO, msg + ", no longer listening to its messages");
                this.isListeningToThermal = false;
            }
            if (!this.isListeningToHex || !agent.getName().equals(this.hexName)) continue;
            msg = "Subsystem " + this.hexName + "disconnected";
            LOG.log(Level.INFO, msg + ", no longer listening to its messages");
            this.isListeningToHex = false;
        }
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="getControlState", description="Get the chiller state")
    public ChillerControlState getControlState() {
        this.controlState.setFastPeriod(this.monitorControl.getFastPeriod());
        return this.controlState;
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="setLights", description="Turn chiller-cabinet lights on or off")
    public void setLights(@Argument(description="<true/false> for <on/off>") boolean on) throws DriverException {
        this.devMaq20.setLightOn(ChillerMaq20Device.LightNumber.LIGHT1, on);
        this.devMaq20.setLightOn(ChillerMaq20Device.LightNumber.LIGHT2, on);
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="showLights", description="Get status of cabinet lights")
    public String showLights() {
        String status = "";
        for (ChillerMaq20Device.LightNumber light : ChillerMaq20Device.LightNumber.values()) {
            status = status + (Object)((Object)light) + " = " + (this.devMaq20.isLightOn(light) != false ? "on  " : "off ");
        }
        return status;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Enable or disable chiller operation")
    public void enableChiller(boolean on) {
        this.gotCommand = true;
        this.devPluto.setSwitchOn(0, on);
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get latched PLC condition names")
    public List<String> getPlcLatchNames() {
        return ChillerLatches.getNames();
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clear a latched PLC condition")
    public void clearPlcLatch(@Argument(description="The condition name") String cond) throws RefrigException {
        this.gotCommand = true;
        this.devPluto.clearLatch(ChillerLatches.getId(cond));
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Clear all latched PLC conditions")
    public void clearAllPlcLatches() {
        this.gotCommand = true;
        this.devPluto.clearAllLatches();
    }

    private void updateControlState() {
        Chiller.ErrorWords ew;
        String oldMode;
        String mode;
        boolean changed = this.monitorControl.hasPeriodChanged() || this.gotCommand;
        this.gotCommand = false;
        ChillerState state = this.devChiller.getChillerState();
        if (state != this.controlState.getChillerState()) {
            this.controlState.setChillerState(state);
            changed = true;
        }
        double flow = this.chanFlowSet.getValue();
        double oldFlow = this.controlState.getFlowSet();
        if (!(Double.isNaN(flow) && Double.isNaN(oldFlow) || flow == oldFlow)) {
            this.controlState.setFlowSet(flow);
            changed = true;
        }
        double temp = this.chanTempSet.getValue();
        double oldTemp = this.controlState.getSetPoint();
        if (!(Double.isNaN(temp) && Double.isNaN(oldTemp) || temp == oldTemp)) {
            this.controlState.setSetPoint(temp);
            changed = true;
        }
        double tank = this.chanTankSet.getValue();
        double oldTank = this.controlState.getTankSet();
        if (!(Double.isNaN(tank) && Double.isNaN(oldTank) || tank == oldTank)) {
            this.controlState.setTankSet(tank);
            changed = true;
        }
        double oldLastRamp = this.controlState.getLastRamp();
        if (!(Double.isNaN(this.lastRampValue) && Double.isNaN(oldLastRamp) || this.lastRampValue == oldLastRamp)) {
            this.controlState.setLastRamp(this.lastRampValue);
            changed = true;
        }
        double ramp = this.devChiller.getDefaultRamp();
        double oldRamp = this.controlState.getDefaultRamp();
        if (!(Double.isNaN(ramp) && Double.isNaN(oldRamp) || ramp == oldRamp)) {
            this.controlState.setDefaultRamp(ramp);
            changed = true;
        }
        if (!(mode = this.devChiller.getTempControlMode() ? "DUT" : "RTD1").equals(oldMode = this.controlState.getTemperatureMode())) {
            this.controlState.setTemperatureMode(mode);
            changed = true;
        }
        if ((ew = this.devChiller.getLastErrorWords()) != null) {
            boolean oldWarning;
            boolean warning;
            boolean oldErrorOther;
            boolean errorOther;
            boolean oldErrorEMO;
            boolean errorEMO = (ew.getError2() & 0x20) != 0;
            if (errorEMO != (oldErrorEMO = this.controlState.getChillerErrorEMO())) {
                this.controlState.setChillerErrorEMO(errorEMO);
                changed = true;
            }
            if ((errorOther = ew.getError1() != 0 || (ew.getError2() & 0xFFFFFFDF) != 0) != (oldErrorOther = this.controlState.getChillerErrorOther())) {
                this.controlState.setChillerErrorOther(errorOther);
                changed = true;
            }
            if ((warning = ew.getWarning1() != 0 || ew.getWarning1() != 0) != (oldWarning = this.controlState.getChillerWarning())) {
                this.controlState.setChillerWarning(warning);
                changed = true;
            }
        }
        if (this.devPluto.isOnline()) {
            changed |= this.devPluto.updateState(this.controlState.getPlcState());
        }
        if (changed) {
            this.publishControlState();
        }
    }

    private void publishControlState() {
        this.controlState.setFastPeriod(this.monitorControl.getFastPeriod());
        this.publishSubsystemDataOnStatusBus(new KeyValueData("ChillerControlState", (Serializable)this.controlState));
    }

    boolean getConnectedToCamera() {
        return this.connectedToCamera;
    }
}

