/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.logging.Log;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Promise;

public class Leaver {
    protected final GMS gms;
    protected final Log log;
    protected final Promise<Address> leave_promise = new Promise();
    protected final AtomicBoolean leaving = new AtomicBoolean(false);

    public Leaver(GMS gms) {
        this.gms = Objects.requireNonNull(gms);
        this.log = gms.getLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave() {
        if (!this.leaving.compareAndSet(false, true)) {
            Address coord = this.gms.getCoord();
            if (coord == null) {
                this.log.trace("%s: last member in the group (coord); leaving now", this.gms.local_addr);
                this.leave_promise.setResult(this.gms.local_addr);
            } else {
                this.log.trace("%s: re-sending LEAVE request to %s", this.gms.local_addr, coord);
                this.sendLeaveRequest(coord, this.gms.local_addr);
            }
            return;
        }
        try {
            int leave_attempts = 0;
            this.leave_promise.reset(false);
            Address leaving_mbr = Objects.requireNonNull(this.gms.local_addr);
            Address coord = this.gms.getCoord();
            if (coord == null) {
                this.log.trace("%s: last member in the group (coord); leaving now", this.gms.local_addr);
                return;
            }
            this.log.trace("%s: sending LEAVE request to %s", this.gms.local_addr, coord);
            long start = System.currentTimeMillis();
            this.sendLeaveRequest(coord, leaving_mbr);
            while (this.leaving.get()) {
                Address sender = this.leave_promise.getResult(this.gms.leave_timeout);
                long time = System.currentTimeMillis() - start;
                if (this.leave_promise.hasResult()) {
                    if (sender != null) {
                        boolean self = Objects.equals(sender, this.gms.local_addr);
                        this.log.trace("%s: got LEAVE response from %s in %d ms", this.gms.local_addr, self ? " self" : sender, time);
                    } else {
                        this.log.trace("%s: timed out waiting for LEAVE response from %s (after %d ms)", this.gms.local_addr, coord, time);
                    }
                } else {
                    if (this.gms.max_leave_attempts <= 0 || ++leave_attempts < this.gms.max_leave_attempts) continue;
                    this.log.warn("%s: terminating after %d unsuccessful LEAVE attempts (waited %d ms): ", this.gms.local_addr, leave_attempts, time);
                }
                break;
            }
        }
        finally {
            this.reset();
        }
    }

    public void handleLeaveResponse(Address sender) {
        this.leave_promise.setResult(Objects.requireNonNull(sender));
    }

    public void coordChanged(Address new_coord) {
        if (!this.leaving.get() || new_coord == null) {
            return;
        }
        Address leaving_mbr = this.gms.local_addr;
        if (leaving_mbr == null) {
            this.log.error("local address is null, cannot re-send LEAVE request");
        } else {
            this.log.trace("%s: re-sending LEAVE request to %s", this.gms.local_addr, new_coord);
            this.sendLeaveRequest(new_coord, leaving_mbr);
        }
    }

    public void reset() {
        if (this.leaving.compareAndSet(true, false)) {
            this.leave_promise.setResult(null);
        }
    }

    protected void sendLeaveRequest(Address coord, Address leaving_mbr) {
        Message msg = new Message(coord).setFlag(Message.Flag.OOB).putHeader(this.gms.getId(), new GMS.GmsHeader(3, leaving_mbr));
        ((Protocol)this.gms.getDownProtocol()).down(msg);
    }
}

