/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.subsystem.refrig.CompLimits;

public class CryoCompLimits
extends CompLimits {
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    private volatile double phaseSepTempDelayLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    private volatile int phaseSepTempDelayTime;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    private volatile double pressDiffImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    private volatile double discTempLowImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    private volatile double oilLevelImmedLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    private volatile double heaterTempLimit;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    private volatile double orificeOffPress;
    @ConfigurationParameter(category="CompLimits", isFinal=true)
    private volatile double orificeOnPress;

    @Override
    public void postInit() {
        super.postInit();
        this.limitData[0].delayTime = -1;
        this.limitData[4].immedLimit = Double.NaN;
        this.limitData[9].isLower = true;
        this.limitData[9].noShutoff = true;
        this.limitData[9].delayLimit = Double.NaN;
        this.limitData[8].noShutoff = true;
        this.limitData[8].delayLimit = Double.NaN;
        this.limitData[6].isLower = true;
        this.limitData[6].delayLimit = Double.NaN;
    }

    @ConfigurationParameterChanger
    public void setPhaseSepTempDelayLimit(double value) {
        this.phaseSepTempDelayLimit = value;
        this.limitData[4].delayLimit = value;
    }

    @ConfigurationParameterChanger
    public void setPhaseSepTempDelayTime(int value) {
        this.phaseSepTempDelayTime = value;
        this.limitData[4].delayTime = 1000 * value;
    }

    @ConfigurationParameterChanger
    public void setDiscTempLowImmedLimit(double value) {
        this.discTempLowImmedLimit = value;
        this.limitData[9].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setPressDiffImmedLimit(double value) {
        this.pressDiffImmedLimit = value;
        this.limitData[8].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setOilLevelImmedLimit(double value) {
        this.oilLevelImmedLimit = value;
        this.limitData[6].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setHeaterTempLimit(double value) {
        this.heaterTempLimit = value;
        this.limitData[10].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setOrificeOffPress(double value) {
        this.orificeOffPress = value;
        this.limitData[12].immedLimit = value;
    }

    @ConfigurationParameterChanger
    public void setOrificeOnPress(double value) {
        this.orificeOnPress = value;
        this.limitData[11].immedLimit = value;
    }
}

