/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;
import org.lsst.ccs.subsystem.refrig.HexMain;
import org.lsst.ccs.subsystem.refrig.PressureTemperatureUtils;

public class SuperHeatChannel
extends DerivedChannel {
    private Channel evapExitTempChannel;
    private Channel returnPressureChannel;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private HexMain hex;

    public void build() {
        if (this.evapExitTempChannel == null || this.returnPressureChannel == null) {
            throw new RuntimeException("Both evapExitTemp and returnPressure channels must be defined and not null. " + this.evapExitTempChannel + " " + this.returnPressureChannel);
        }
        super.build();
    }

    public double evaluateDerivedValue() {
        double pRead = this.returnPressureChannel.getValue();
        double tRead = this.evapExitTempChannel.getValue();
        if (Double.isNaN(pRead) || Double.isNaN(tRead)) {
            return Double.NaN;
        }
        double result = tRead - PressureTemperatureUtils.evaluateSaturationTemperature(pRead += this.hex.getRtnToEvapOffset());
        return result;
    }
}

