/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;

public class ConfiguredAverageChannel
extends DerivedChannel {
    @LookupField(strategy=LookupField.Strategy.SIBLINGS)
    Map<String, Channel> channelMap = new HashMap<String, Channel>();
    @LookupName
    private String name;
    private static final Logger LOG = Logger.getLogger(ConfiguredAverageChannel.class.getName());
    private List<Channel> channels = new ArrayList<Channel>();
    private double sumWeights;
    @ConfigurationParameter(name="chanNames", category="General", description="Names of Channels to be averaged", maxLength=-1, units="unitless")
    protected volatile List<String> chanNames = new ArrayList<String>();
    @ConfigurationParameter(name="chanWeights", category="General", description="Weights of Channels to be averaged", maxLength=-1, units="unitless")
    protected volatile List<Double> chanWeights = new ArrayList<Double>();

    public void validateBulkChange(Map<String, Object> params) {
        super.validateBulkChange(params);
        List channelList = (List)params.get("chanNames");
        List weightList = (List)params.get("chanWeights");
        int len = channelList.size();
        if (weightList.size() != len) {
            throw new RuntimeException(this.name + ": chanWeights and chanNames do not have same size");
        }
        for (int i = 0; i < len; ++i) {
            if (this.channelMap.get(channelList.get(i)) == null) {
                throw new RuntimeException(this.name + "/chanNames element " + (String)channelList.get(i) + " not among available Channels");
            }
            if ((Double)weightList.get(i) >= 0.0) continue;
            throw new RuntimeException(this.name + "/chanWeights element " + i + " is not positive-definite");
        }
    }

    public void setParameterBulk(Map<String, Object> params) {
        int i;
        super.setParameterBulk(params);
        Set<String> keys = params.keySet();
        if (keys.contains("chanNames")) {
            this.chanNames.clear();
            this.chanNames.addAll((List)params.get("chanNames"));
            this.channels.clear();
            for (i = 0; i < this.chanNames.size(); ++i) {
                this.channels.add(this.channelMap.get(this.chanNames.get(i)));
            }
        }
        if (keys.contains("chanWeights")) {
            this.chanWeights.clear();
            this.chanWeights.addAll((List)params.get("chanWeights"));
            this.sumWeights = 0.0;
            for (i = 0; i < this.chanWeights.size(); ++i) {
                this.sumWeights += this.chanWeights.get(i).doubleValue();
            }
        }
    }

    public double evaluateDerivedValue() {
        double sum = 0.0;
        for (int i = 0; i < this.channels.size(); ++i) {
            sum += this.chanWeights.get(i) * this.channels.get(i).getValue();
        }
        return sum / this.sumWeights;
    }
}

