/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.chiller.Chiller;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.refrig.constants.ChillerAlerts;
import org.lsst.ccs.subsystem.refrig.constants.ChillerState;

public class InTESTChillerDevice
extends Device {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alert;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent subsys;
    private final Chiller chiller = new Chiller();
    private final Map<Integer, String> typeMap = new HashMap<Integer, String>();
    private final Map<Integer, String> itemMap = new HashMap<Integer, String>();
    private Integer chanKey;
    private boolean readHeatCool = false;
    private double[] heatCool;
    private Chiller.ErrorWords lastErrorWords;
    private AlertState lastErrorAlert;
    private volatile ChillerState lastState;
    @ConfigurationParameter(isFinal=true, description="IP host")
    protected volatile String host;
    private static final Logger LOG = Logger.getLogger(InTESTChillerDevice.class.getName());

    protected void initDevice() {
        this.fullName = "InTESTChiller " + this.name + " (" + this.host + ")";
        this.chanKey = 0;
        this.lastErrorAlert = AlertState.NOMINAL;
        this.lastErrorWords = new Chiller.ErrorWords(0, 0, 0, 0);
        this.lastState = ChillerState.CHILLER_OFF;
        if (this.host == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"host", (String)"is missing");
        }
        this.alert.registerAlert(ChillerAlerts.CHILLER_ERR.newAlert());
        this.stateService.registerState(ChillerState.class, "Chiller State", (Object)this.subsys);
        this.stateService.updateAgentState(new Enum[]{this.lastState});
    }

    protected void initialize() {
        try {
            this.chiller.open(this.host);
            this.initSensors();
            this.setOnline(true);
            LOG.info("\n Connected to " + this.fullName);
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.severe("Error connecting to or initializaing " + this.fullName + ": " + (Object)((Object)e));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.chiller.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        try {
            switch (type) {
                case "Temp": {
                    Chiller.Query qu = Chiller.Query.valueOf((String)subtype);
                    if (!qu.getIsTemp()) {
                        throw new IllegalArgumentException("bad subtype");
                    }
                    break;
                }
                case "Flow": {
                    Chiller.Query.valueOf((String)subtype);
                    break;
                }
                case "Pres": {
                    Chiller.Query.valueOf((String)subtype);
                    break;
                }
                case "HC": {
                    if (!subtype.equals("Heat") && !subtype.equals("Cool")) {
                        throw new IllegalArgumentException("bad subtype");
                    }
                    this.readHeatCool = true;
                    break;
                }
                case "Life": {
                    Chiller.Life.valueOf((String)subtype);
                    break;
                }
                case "Register": {
                    if (!subtype.equals("Status")) {
                        throw new IllegalArgumentException("bad subtype");
                    }
                    break;
                }
                default: {
                    ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"type", (Object)type);
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)(type + " subtype "), (Object)subtype);
        }
        Object object = this.chanKey;
        Integer n = this.chanKey = Integer.valueOf(this.chanKey + 1);
        this.typeMap.put(this.chanKey, type);
        this.itemMap.put(this.chanKey, subtype);
        return new int[]{this.chanKey, 0};
    }

    protected void readChannelGroup() {
        if (!this.isOnline()) {
            return;
        }
        if (this.readHeatCool) {
            try {
                this.heatCool = this.chiller.getHeatCool();
            }
            catch (DriverTimeoutException et) {
                LOG.severe("Chiller timeout reading HeatCool:  " + (Object)((Object)et));
                this.setOnline(false);
            }
            catch (DriverException e) {
                LOG.severe("Chiller exception reading HeatCool:  " + (Object)((Object)e));
            }
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (!this.isOnline()) {
            return value;
        }
        String itemType = this.typeMap.get(type);
        String item = this.itemMap.get(type);
        if (itemType.equals("HC")) {
            if (item.equals("Heat")) {
                value = this.heatCool[0];
            } else if (item.equals("Cool")) {
                value = this.heatCool[1];
            }
        } else {
            try {
                switch (itemType) {
                    case "Temp": {
                        value = this.chiller.getTemperature(Chiller.Query.valueOf((String)item));
                        break;
                    }
                    case "Flow": {
                        value = this.chiller.getFlow(Chiller.Query.valueOf((String)item));
                        break;
                    }
                    case "Pres": {
                        value = this.chiller.getPressure(Chiller.Query.valueOf((String)item));
                        break;
                    }
                    case "Life": {
                        value = this.chiller.getLifetime(Chiller.Life.valueOf((String)item));
                        break;
                    }
                    case "Register": {
                        if (!item.equals("Status")) break;
                        int status = this.chiller.getStatusReg();
                        value = status;
                        Chiller.ErrorWords errorWords = this.chiller.getErrorWords();
                        this.checkForErrors(status, errorWords);
                        ChillerState st = this.getState(status);
                        if (st == this.lastState) break;
                        this.stateService.updateAgentState(new Enum[]{st});
                        this.lastState = st;
                    }
                }
            }
            catch (DriverTimeoutException et) {
                LOG.severe("Chiller timeout reading data " + item + ": " + (Object)((Object)et));
                this.setOnline(false);
            }
            catch (DriverException e) {
                LOG.severe("Chiller exception reading data " + item + ": " + (Object)((Object)e));
            }
        }
        return value;
    }

    private ChillerState getState(int status) {
        ChillerState state = ChillerState.CHILLER_OFF;
        if ((status & Chiller.StatusRegister.AT_SETPT.getMask()) != 0) {
            state = ChillerState.CHILLER_SETPOINT;
        } else if ((status & Chiller.StatusRegister.T_CONTROL.getMask()) != 0) {
            state = ChillerState.CHILLER_CONTROLLING;
        } else if ((status & Chiller.StatusRegister.CMPRS_ON.getMask()) != 0) {
            state = ChillerState.CHILLER_IDLE;
        }
        return state;
    }

    private void checkForErrors(int status, Chiller.ErrorWords errorWords) {
        boolean raise;
        boolean warning;
        boolean error = (status & Chiller.StatusRegister.ERROR.getMask()) != 0;
        boolean bl = warning = (status & Chiller.StatusRegister.WARNING.getMask()) != 0;
        AlertState errorAlert = error ? AlertState.ALARM : (warning ? AlertState.WARNING : AlertState.NOMINAL);
        boolean bl2 = raise = errorAlert != this.lastErrorAlert;
        if (!raise && errorAlert != AlertState.NOMINAL && !errorWords.equals((Object)this.lastErrorWords)) {
            raise = true;
        }
        if (raise) {
            this.alert.raiseAlert(ChillerAlerts.CHILLER_ERR.newAlert(), errorAlert, "Chiller " + errorWords.toString());
        }
        this.lastErrorWords = errorWords;
        this.lastErrorAlert = errorAlert;
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="listQueries", description="List available queries")
    public String listQueries() {
        return this.chiller.listQueries();
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="listStatusBits", description="List status register bits")
    public String listStatusBits() {
        return this.chiller.listStatusBits();
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="queryChiller", description="send specified query to chiller")
    public String queryChiller(@Argument(description="Read Enumerated quantity from Chiller") Chiller.Query quantity) throws DriverException {
        String response = "";
        try {
            response = this.chiller.queryChiller(quantity);
        }
        catch (DriverTimeoutException ex) {
            this.checkCommand(ex);
        }
        return response;
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="readParameter", description="Read value of specified parameter")
    public String readParameter(@Argument(description="index of parameter") int index) throws DriverException {
        String response = "";
        try {
            response = this.chiller.readParameter(index);
        }
        catch (DriverTimeoutException ex) {
            this.checkCommand(ex);
        }
        return response;
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="showEvtReg", description="Show decoded Event Register")
    public String showEvtReg() throws DriverException {
        return this.chiller.decodeEvtReg();
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="showStatusReg", description="Show decoded Event Register")
    public String showStatusReg() throws DriverException {
        return this.chiller.decodeStatusReg();
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="showErrorWords", description="Show error and warning words in hex")
    public String showErrorWords() throws DriverException {
        return this.chiller.getErrorWords().toString();
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="showChillerState", description="Show ChillerState")
    public String showChillerState() {
        return this.lastState + ":  " + this.lastState.getDescription();
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="setParams", description="Invoke Chiller command tp set parameter(s)")
    public void setParams(@Argument(description="enumerated command") Chiller.SetParam setParam, double ... values) throws DriverException {
        try {
            this.chiller.setParamCommand(setParam, values);
        }
        catch (DriverTimeoutException ex) {
            this.checkCommand(ex);
        }
    }

    private void checkCommand(DriverTimeoutException ex) throws DriverException {
        String eventReg = "";
        try {
            eventReg = this.chiller.decodeEvtReg();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (eventReg.contains("BAD_CMND")) {
            throw new DriverException("Chiller command not recognizw");
        }
        if (eventReg.contains("BAD_ARG")) {
            throw new IllegalArgumentException("Bad argument(s) to Chiller comand");
        }
        if (ex != null) {
            throw ex;
        }
    }
}

